-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------

deferred class COMPARABLE
                        -- This class describes a total order
                        -- relation.
inherit
    PART_COMPARABLE
        redefine
            infix "<", infix "<="
        end
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    infix "<" (other : like Current) : BOOLEAN is
                    -- Is 'Current' strictly less than 'other'?
        deferred
        ensure then
            other_not_less_or_equal : Result = not (other <= Current) 
        end
-----------------------------------------------------------

    infix "<=" (other : like Current) : BOOLEAN is
                    -- Is 'Current' less or equal 'other'?
        do
            Result := not (other < Current)
        ensure then
            other_not_less : Result = not (other < Current) 
        end
-----------------------------------------------------------

    compare (other : like Current) : INTEGER is
                        -- Compare 'Current' with 'other'.
                        -- '<' <==> Result < 0
                        -- '>' <==> Result > 0
                        -- Otherwise Result = 0.
        require
            other_not_void : other /= Void
        do
            if Current < other then
                Result := -1
            elseif other < Current then
                Result := 1
            end
        ensure
            negative_condition: (Result < 0) = (Current < other)
            zero_condition    : (Result = 0) = not (Current < other or Current > other)
            positive_condition: (Result > 0) = (Current > other)
        end
-----------------------------------------------------------

    min (other : like Current) : like Current is 
                        -- Minimum of 'Current' and 'other'.
        require
            other_not_void : other /= Void
        do
            if Current < other then
                Result := Current
            else
                Result := other
            end
        ensure
            less_or_equal_both : Result <= Current and then Result <= other
            one_or_the_other   : compare (Result)       = 0 or else
                                 other.compare (Result) = 0
        end
-----------------------------------------------------------

    max (other : like Current) : like Current is 
                        -- Maximum of 'Current' and 'other'.
        require
            other_not_void : other /= Void
        do
            if other < Current then
                Result := Current
            else
                Result := other
            end
        ensure
            greater_or_equal_both : Result >= Current and then Result >= other
            one_or_the_other      : compare (Result)       = 0 or else
                                    other.compare (Result) = 0
        end
-----------------------------------------------------------

end -- class COMPARABLE

