-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   FSYS_DAT

inherit
    COMPARABLE
        redefine
            infix "<"
    end
-----------------------------------------------------------
creation {FILE_SYSTEM}
    make 
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    name : STRING               -- Name of file or cluster
    path : STRING               -- Full path to file or cluster

-----------------------------------------------------------

    time : REAL is
                        -- Time of last modification
        do
            compute_all
            Result := ftime
        end
-----------------------------------------------------------

    perm : STRING is
                        -- Permissions
        do
            compute_all
            Result := fperm
        end
-----------------------------------------------------------

    count : INTEGER is
                        -- Size of file or no. files in cluster
        do
            compute_all
            Result := fcount
        end
-----------------------------------------------------------

    infix "<" (other : like Current) : BOOLEAN is

        do
            Result := path < other.path
        end
-----------------------------------------------------------
feature {FILE_SYSTEM}
-----------------------------------------------------------

    make (n : STRING, pa : STRING, my_fs : FILE_SYSTEM, is_file : BOOLEAN) is

        do
            name      := n
            path      := pa
            filesys   := my_fs
            is_a_file := is_file
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    ftime       : REAL              -- Time of last modification.
    fperm       : STRING            -- Permissions.
    fcount      : INTEGER           -- Length of file in bytes or
                                    -- No. files in cluster.
    filesys     : FILE_SYSTEM       -- The file system.
    is_a_file   : BOOLEAN           -- File or cluster?
-----------------------------------------------------------

    compute_all is

        do
            if is_a_file then
                if filesys.file_exists (path) then
                    ftime  := filesys.file_time (path)
                    fperm  := filesys.file_perm (path)
                    fcount := filesys.file_count (path)
                else
                    ftime  := 0.0
                    fperm  := no_fperm
                    fcount := 0
                end
            else
                if filesys.cluster_exists (path) then
                    ftime  := filesys.cluster_time (path)
                    fperm  := filesys.cluster_perm (path)
                    fcount := filesys.cluster_count (path)
                else
                    ftime  := 0.0
                    fperm  := no_cperm
                    fcount := 0
                end
            end
        end
-----------------------------------------------------------

    no_fperm : STRING is

        once
            Result := "---.---.---"
        end
-----------------------------------------------------------

    no_cperm : STRING is

        once
            Result := "--.--.--"
        end
-----------------------------------------------------------

end -- class FSYS_DAT

