-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   SYSTEM_TIME

-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    year        : INTEGER
    month       : INTEGER
    day         : INTEGER
    hour        : INTEGER
    minute      : INTEGER
    second      : INTEGER
    day_of_year : INTEGER
    day_of_week : INTEGER

-----------------------------------------------------------

    now : REAL is
                        -- The current time (GMT)
        external "C" -- changed by x_c_cwc
        alias    "RTC12_now"
        end
-----------------------------------------------------------

    localtime (gm_time : REAL) : REAL is
                        -- The local time corresponding to
                        -- to GMT `gm_time'. Takes timezones
                        -- and daylight savings into account.
        external "C" -- changed by x_c_cwc
        alias    "RTC12_localtime"
        end
-----------------------------------------------------------
                        
    to_time (y, mo, d, h, mi, s : INTEGER) : REAL is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_d2t"
        end
-----------------------------------------------------------

    to_date (t : REAL) is

        do
            rt_compute (t)

            year        := rt_year
            month       := rt_month
            day         := rt_day
            hour        := rt_hour
            minute      := rt_minute
            second      := rt_second
            day_of_week := rt_day_of_week
            day_of_year := rt_day_of_year
        end
-----------------------------------------------------------

    sysclock : INTEGER is
                        -- High resolution system clock
                        -- Result is in 1/1000 seconds.
                        -- The value is 0 immediately after
                        -- start of program execution.
        external "C" -- changed by x_c_cwc
        alias    "RTC12_clock"
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    rt_compute (t : REAL) is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_t2d_compute"
        end
-----------------------------------------------------------

    rt_year : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_year"
        end
-----------------------------------------------------------

    rt_month : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_month"
        end
-----------------------------------------------------------

    rt_day : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_day"
        end
-----------------------------------------------------------

    rt_hour : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_hour"
        end
-----------------------------------------------------------

    rt_minute : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_minute"
        end
-----------------------------------------------------------

    rt_second : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_second"
        end
-----------------------------------------------------------

    rt_day_of_week : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_day_of_week"
        end
-----------------------------------------------------------

    rt_day_of_year : INTEGER is

        external "C" -- changed by x_c_cwc
        alias    "RTC12_day_of_year"
        end
-----------------------------------------------------------

end -- class SYSTEM_TIME

