--
-- FILE:  File data-type
--
-- %Z%%Y%:%M%	%I%

indexing

   date: "$Date: D T ";
   revision: "$Revision: R.L $";

   authors: roy;
   names: file

class FILE

inherit

   	IO_STREAM ;

	ANY redefine out
	end

creation

   make_named,
   make_descriptor

feature { ANY}

   x:INTEGER

   file_name: STRING
         -- when not Void, name of file being accessed

   out: STRING is
   	do
		!!Result.make_from_string ( file_name)
	end -- out

   make_named ( f_name: STRING) is
         -- create an object referencing a file
         -- named `file_name'
      do
         file_name := f_name
      end -- make_named

   make_descriptor ( fd: INTEGER) is
         -- create an object to reference a file
         -- already opened on `fd'
      do
         file_name := Void
         stream_id := fd
      end -- make_descriptor


   open_read is
         -- open stream created by `make_named' in read mode
      require
         file_name /= Void
      do
         stream_id := open ( file_name.to_c, Read_mode)
      end -- open_read

   open_write is
         -- open stream created by `make_named' in write mode
      require
         file_name /= Void
      do
         stream_id := open ( file_name.to_c, Write_mode)
      end -- open_read


   Read_mode: INTEGER is 0
   Write_mode: INTEGER is 1

   --
   -- input features
   --

   lastchar: CHARACTER
         -- last character read from `Current' input stream by readchar

   lastint: INTEGER
         -- last integer read from `Current' input stream by readint

   lastreal: REAL
         -- last real read from `Current' input stream by readreal

   laststring: STRING
         -- last string read from `Current' input stream by readstream
         -- or readline

   readchar is
         -- assign next character on `Current' input stream to lastchar
      do
         lastchar := c_readchar ( stream_id)
      end -- readchar


   readint is
         -- assign next integer on `Current' input stream to lastint 
      do
         lastint := c_readint ( stream_id)
      end -- readint


   readreal is
         -- assign next real on `Current' input stream to lastreal
      do
         lastreal := c_readreal ( stream_id)
      end -- readreal


   readline is
         -- Read a string until a new line or an end of file is encountered
         -- Make result available in `laststring'
         -- New line will be consumed but not part of `laststring'
      local
         c_str: POINTER
      do
         c_str := c_readline ( stream_id)
         if
            laststring = Void
         then
            !!laststring.make_from_c ( c_str)
         else
            laststring.make_from_c ( c_str)
         end
      end -- readline


   readstream ( i: INTEGER) is
         -- assign next string of `i' characters on 
         -- `Current' input stream to laststring
      local
         c_str: POINTER
      do
         c_str := c_readstream ( stream_id, i)
         if
            laststring = Void
         then
            !!laststring.make_from_c ( c_str)
         else
            laststring.make_from_c ( c_str)
         end
      end -- readstream


   next_line is
         -- move to next input line
      do
         c_next_line ( stream_id)
      end  -- next_line


   --
   -- output features
   --

   putbool ( b: BOOLEAN) is
         -- append boolean to (Current) output stream 
         -- in character format ("true"/"false")
      do
         if
            b = True
         then
            putstring ( True_string)
         else
            putstring ( False_string)
         end
      end

   putchar ( c: CHARACTER) is
         -- append character to (Current) output stream
      do
         c_putchar ( stream_id, c)
      end

   putint ( i: INTEGER) is
         -- append integer to (Current) output stream in character format
      do
         c_putint ( stream_id, i)
      end

   putreal ( r: REAL) is
         -- append real to (Current) output stream in character format
      do
         c_putreal ( stream_id, r)
      end

   putdouble ( d: DOUBLE) is
         -- append double to (Current) output stream in character format
      do
         c_putdouble ( stream_id, d)
      end


   putstring ( s: STRING) is
         -- append string to (Current) output stream
      do
         c_putstring ( stream_id, s.to_c)
      end

   new_line is
         -- append a new line character to (Current) output stream
      do
         c_putchar ( stream_id, '%N')
      end



   stream_id: INTEGER
         -- file descriptor for file access

feature { NONE}

   c_readchar ( sid: INTEGER): CHARACTER is
         --
      external "C"
      end -- c_readchar

   c_readint ( sid: INTEGER): INTEGER is
         --
      external "C"
      end -- c_readint

   c_readreal ( sid: INTEGER): REAL is
         --
      external "C"
      end -- c_readreal

   c_readline ( sid: INTEGER): POINTER is
         --
      external "C"
      end -- c_readline

   c_readstream ( sid, i: INTEGER): POINTER is
         --
      external "C"
      end -- c_readstream

   c_next_line ( i: INTEGER) is
         --
      external "C"
      end -- c_next_line

   c_putchar ( sid: INTEGER; c: CHARACTER) is
         --
      external "C"
      end -- c_putchar

   c_putint ( sid: INTEGER; i: INTEGER) is
         --
      external "C"
      end -- c_putint

   c_putreal ( sid: INTEGER; r: REAL) is
         --
      external "C"
      end -- c_putreal

   c_putdouble ( sid: INTEGER; d: DOUBLE) is
         --
      external "C"
      end -- c_putdouble

   c_putstring ( sid: INTEGER; c_str: POINTER) is
         --
      external "C"
      end -- c_putstring

   open ( c_name: POINTER; mode: INTEGER): INTEGER is
         --
      external "C"
      alias "c_open"
      end -- open

   close ( fd: INTEGER) is
         --
      external "C"
      alias "c_close"
      end -- close

end -- class FILE
