class GENERAL

feature

   -- Void value

   Void: NONE is
         -- value of ANY entity when not *attached* to an object
      once
      end -- Void

   is_equal, frozen standard_is_equal ( other: like Current): BOOLEAN is
         -- Is `other' attached to an object field-by-field identical  
         -- (on common fields) to `Current'?
      require
         other_not_void: other /= Void
	 do
		Result := c_equal ( 0, 1, other)
      end -- is_equal

   frozen equal ( some:ANY; other:like some):BOOLEAN is
         -- Are `some' and `other' both Void or attached to
         -- to objects field-by-field identical (on fields `some')?
         -- Defined in terms of `is_equal'.
      do
         
         Result := ( some = Void and other = Void) or else
                  some /= Void and then some.is_equal( other)
      end -- equal

   deep_equal, frozen standard_deep_equal 
					( some:ANY; other:like some):BOOLEAN is
         -- Are `some' and `other' both Void or attached to
         -- to recursivly isomorphic object structures?
         -- Defined in terms of `is_equal'.
      do
         Result := ( some = Void and other = Void) or
                  ( some /= Void and other /= Void and then
                    some.c_equal( 1, 1, other))
      end -- deep_equal

   copy, frozen standard_copy ( other: like Current) is
         -- Copy every field of other onto
         -- corresponding field of current object
      require
         other_not_void: other /= Void
	 do
	    c_copy ( 0, 1, other)
      end -- copy

   deep_copy, frozen standard_deep_copy ( other: like Current) is
         -- Copy field-by-field to `other'
      require
         other_not_void: other /= Void
	 do
	    c_copy ( 1, 1, other)
      end -- deep_copy


   frozen clone ( other: ANY): like other is
         -- Void if `other' is void; otherwise, new object
         -- field-by-field identical to object attached to
         -- `other'.
         -- (Defined in terms of `copy')
      do
         if 
            other /= Void
         then
           !!Result
		 Result.c_copy ( 0, 1, other)
         end
      end -- clone

   deep_clone, frozen standard_deep_clone ( other:ANY):like other is
         -- Void if `other' is void; otherwise, new object
         -- field-by-field identical to object attached to
         -- `other'.
         -- (Defined in terms of `copy')
      do
         if 
            other /= Void
         then
           !!Result
		 Result.c_copy ( 1, 1, other)
         end
 	end -- deep clone


   io: STD_FILES is
         -- default IO streams
      once
         !!Result.make
      end -- io

   except: EXCEPTIONS is
	    -- default exception handler
	  once
		!!Result
	  end -- except
   
   out: STRING is
	    -- This is a fall back for assertions and debugging, it is supposed 
	    -- to display a useful string from the object in question. A class
	    -- may want to redefine this ( see STRING).
	    -- Don't add assertions, they will use `out' and infinite
	    -- recursion will result.
      do
	 	!!Result.make_from_string ( "out - not implemented")
      end -- out

   print (s: OUT_STREAM) is
	   -- Print `out' to stdout
      do
          s.putstring ( out)
	 end -- print

   generator: STRING is
         -- Name of the current object's generating class,
         -- (base class of the type of which it is a direct instance).
         -- Every call to this function allocates a new result string
      do
         !!Result.make_from_c ( c_class_name)
      end -- generator

   object_id: STRING is
         -- Representation of object's value.  If current object is a
         -- complex object, then this value is differant than any other
         -- in the system - it is unique
      do
         !!Result.make_from_int ( c_address_of ( c_object_address))
      end -- object_id

   conforms_to ( other: like Current): BOOLEAN is
         -- Is dynamic type of current object a descendant
         -- of dynamic type of other?
      require
         not_other_void: other /= Void
      do
         Result := id_conforms_to ( other.class_id)
      end -- conforms_to

   c_errno: INTEGER is
		-- Return the C errno variable
	 external "C"
	 alias "_ert_errno"
	 end -- c_errno

   default_rescue is
	    -- Exception response for routines a Rescue clause
	    -- Default: do nothing
      do
	 end -- default_rescue

feature { GENERAL}

   class_id: INTEGER
         -- implementation code for current class
         -- (this value is automatically set by the implementation)

-- to_addr: POINTER is
--         -- low-level version of `out': returns a C-pointer to
--         -- the printable representation, as a POINTER
--      do
--         Result := c_object_address
--      end -- to_addr

   c_object_address: POINTER
         -- address of current object in memory
         -- (note: this value is set by the implementation)

   c_class_name: POINTER
         -- low-level version of `generator': contains a C-pointer to
         -- the name of the current object's class.  Value is constant
         -- (note: this value is set by the implementation)

   c_address_of ( sp: POINTER): INTEGER is
		-- return address of C pointer as an integer
	external "C"
	end -- c_address_of

   c_copy ( deep, top:INTEGER; other:like Current) is
         -- interface to copy constructor
      external "C++"
      alias "_Copy"
      end -- c_copy
      
   c_equal ( deep, top:INTEGER; other:like Current):BOOLEAN is
         -- interface to copy constructor
      external "C++"
      alias "_Equal"
      end -- c_equal
      
   id_conforms_to ( other_id: INTEGER): BOOLEAN is
         -- is current object's class_id a descendant
         -- of `other_id'?
      external "C++"
      alias "_Conforms_to"
      end -- conforms_to

end -- class GENERAL
