class STD_FILES

inherit

   IO_STREAM

creation

   make

feature

   make is
         -- set-up the standard IO file streams
      do
      end -- make

   input: FILE is
         -- Standard input file
      once
         !!Result.make_descriptor ( 0)
      end -- input

   output: FILE is
         -- Standard output file
      once
         !!Result.make_descriptor ( 1)
      end -- output

   error: FILE is
         -- Standard error file
      once
         !!Result.make_descriptor ( 3)
      end -- error

   putchar, put_char (c: CHARACTER) is
         -- Write `c' at end of default output.
      do
         output.putchar ( c)
      end -- putchar

   putstring, put_string (s: STRING) is
         -- Write `s' at end of default output.
      do
         output.putstring ( s)
      end -- putstring

   putreal, put_real (r: REAL) is
         -- Write `r' at end of default output.
      do
         output.putreal ( r)
      end -- putreal

   putdouble, put_double (d: DOUBLE) is
         -- Write `d' at end of default output.
      do
         output.putdouble ( d)
      end -- putdouble

   putint, put_int (i: INTEGER) is
         -- Write `i' at end of default output.
      do
         output.putint ( i)
      end -- putint

   putbool, put_bool (b: BOOLEAN) is
         -- Write `b' at end of default output.
      do
         output.putbool ( b)
      end -- putbool 

   new_line, newline, put_newline is
         -- Write line feed at end of default output.
      do
         output.new_line
      end -- new_line

   readint is
         -- Read a new integer from standard input.
      do
         input.readint
      end -- readint

   readreal is
         -- Read a new real from standard input.
      do
         input.readreal
      end -- readreal

   readline is
         -- Read a line from standard input.
      do
         input.readline
      end -- readline

   readstream (nb_char: INTEGER) is
          -- Read a string of at most `nb_char' bound characters
            -- from standard input.
      do
         input.readstream (nb_char)
      end -- readstream

   readchar is
         -- Read a new character from standard input.
      do
         input.readchar
      end -- readchar

   next_line is
         -- Move to next input line on standard input.
         do
            input.next_line
         end -- next_line

   lastchar: CHARACTER is
         -- Last character read by readchar
      do
         Result := input.lastchar
      end -- lastchar

   lastint: INTEGER is
         -- Last integer read by readint
      do
         Result := input.lastint
      end -- lastint

   lastreal: REAL is
         -- Last real read by readreal
      do
         Result := input.lastreal
      end -- lastreal

   laststring: STRING is
         -- Last string read by readstring
      do
         Result := input.laststring
      end -- laststring


end -- class STD_FILES
