/*
 *
 * Non-expanded forms of basic type
*/
#include <stdio.h>

#include <ert.H>
#include <string.H>
#include <any.H>
#include <numeric.H>
#include <char_ref.H>

class STRING;

CHARACTER_REF::CHARACTER_REF () {
#ifdef _BOOLEAN_REF_H
	val = false; 
#else
	val = 0; 
#endif
	class_id = _bibt_CHARACTER_REF_id;		/* defined in ert.H */
	c_object_address = (POINTER) this;
	c_class_name = (POINTER) "CHARACTER_REF";
}

void CHARACTER_REF::set_value ( CHARACTER v) { val = v; }

CHARACTER CHARACTER_REF::item () { return val; }

void CHARACTER_REF::_Copy ( int deep, int sclass, CHARACTER_REF* v) { 
	val = v->val; 
}

BOOLEAN CHARACTER_REF::_Equal ( int deep, int sclass, CHARACTER_REF* v) {
	return v->val == val ? true : false; 
}

STRING* CHARACTER_REF::out() { 
	STRING *result;

   	result = new STRING;
   	result->make_from_character ( val);
	return result;
}

				 	/* BUG! we don't have STD_FILES available */
void CHARACTER_REF::print ( ANY *s)
{ 
	fprintf ( stderr, "%d", val); 
}
 
CHARACTER_REF* CHARACTER_REF::_Clone (
					int deep, int sclass, CHARACTER_REF *_arg) { 
	CHARACTER_REF *r = new CHARACTER_REF; r->val = _arg->val; return r; 
}

CHARACTER_REF*
_ert_clone_CHARACTER ( CHARACTER v)
{
	CHARACTER_REF *result;
	result = new CHARACTER_REF;
	result->val = v;
	return result;
}

CHARACTER_REF*
_ert_clone_CHARACTER_REF ( CHARACTER_REF *v)
{
	if ( v) {
		CHARACTER_REF *result;
		result = new CHARACTER_REF;
		result->val = v->val;
		return result;
	}

	return ( CHARACTER_REF *) 0;
}

CHARACTER_REF *_CHARACTER_REF_chk(CHARACTER_REF *rtc, char *fname)
{
   if ( !rtc)
      _eiffel_rt_Assert ( 107, "CHARACTER_REF", fname, "void target", 
			false, _ert_longjmp());
   return rtc;
}


BOOLEAN CHARACTER_REF::is_equal (CHARACTER_REF* p1) { 
	return _Equal( 1, 1, p1); 
}

BOOLEAN CHARACTER_REF::equal (ANY* p1, CHARACTER_REF* p2) { 
	return (p1)->_Equal ( 0, 1, p2); 
}

void CHARACTER_REF::copy ( CHARACTER_REF* p1) { 
	_Copy ( 0, 1, p1); 
}

CHARACTER_REF* CHARACTER_REF::clone (CHARACTER_REF *x) {
	 return _Clone( 0, 1, x); 
}

CHARACTER_REF* CHARACTER_REF::_localClone ( int deep, int sclass) { 
	CHARACTER_REF *r = new CHARACTER_REF; r->val = val; return r; 
}

BOOLEAN CHARACTER_REF::deep_equal ( CHARACTER_REF* p1, CHARACTER_REF* p2) {
	 return p1->_Equal ( 1, 1, p2); 
}

void CHARACTER_REF::deep_copy ( CHARACTER_REF* p1) { 
	_Copy ( 1, 1, p1); 
}

CHARACTER_REF* CHARACTER_REF::deep_clone ( CHARACTER_REF *x) {
	 return _Clone (1,1,x); 
}

CHARACTER_REF* _bibt_CHARACTER_CHARACTER_REF ( CHARACTER v)
{
	CHARACTER_REF *result;
	result = new CHARACTER_REF;
	result->set_value ( v);
	return result;
}

#ifndef _BOOLEAN_REF_H

BOOLEAN CHARACTER_REF::_INFIX_LEQ ( CHARACTER_REF* other)
{
	return val < _CHARACTER_REF_chk ( other, "other")->val ? 
       		_ert_BOOLEAN_Const ( true) : _ert_BOOLEAN_Const ( false);
}

CHARACTER_REF* CHARACTER_REF::_INFIX_ADD ( CHARACTER_REF* other)
{
	CHARACTER_REF *r = new CHARACTER_REF; 
	r->val = _CHARACTER_REF_chk ( other, "other")->val + val;
	return r;
}

CHARACTER_REF* CHARACTER_REF::_INFIX_SUB ( CHARACTER_REF* other)
{
	CHARACTER_REF *r = new CHARACTER_REF; 
	r->val = _CHARACTER_REF_chk ( other, "other")->val - val;
	return r;
}

CHARACTER_REF* CHARACTER_REF::_INFIX_MUL ( CHARACTER_REF* other)
{
	CHARACTER_REF *r = new CHARACTER_REF; 
	r->val = _CHARACTER_REF_chk ( other, "other")->val * val;
	return r;
}

CHARACTER_REF* CHARACTER_REF::_INFIX_DIV ( CHARACTER_REF* other)
{
	CHARACTER_REF *r = new CHARACTER_REF; 
	r->val = _CHARACTER_REF_chk ( other, "other")->val / val;
	return r;
}
#endif /* _BOOLEAN_REF_H */

BOOLEAN CHARACTER_REF::_Conforms_to ( int other_id)  /* Don't use CHARACTER */
{
   	if ( class_id == other_id)
      	return true;

#ifdef _BOOLEAN_REF_H
	{
		ANY a;

		return a._Conforms_to ( other_id);
	}
#else
	{
   		NUMERIC n;

   		if ( n.class_id == other_id)
      		return true;

		return n._Conforms_to ( other_id);
	}
#endif
}
