/*
 *
 * Non-expanded forms of basic type
*/
#include <stdio.h>

#include <ert.H>
#include <string.H>
#include <any.H>
#include <numeric.H>
#include <int_ref.H>

class STRING;

INTEGER_REF::INTEGER_REF () {
#ifdef _BOOLEAN_REF_H
	val = false; 
#else
	val = 0; 
#endif
	class_id = _bibt_INTEGER_REF_id;		/* defined in ert.H */
	c_object_address = (POINTER) this;
	c_class_name = (POINTER) "INTEGER_REF";
}

void INTEGER_REF::set_value ( INTEGER v) { val = v; }

INTEGER INTEGER_REF::item () { return val; }

void INTEGER_REF::_Copy ( int deep, int sclass, INTEGER_REF* v) { 
	val = v->val; 
}

BOOLEAN INTEGER_REF::_Equal ( int deep, int sclass, INTEGER_REF* v) {
	return v->val == val ? true : false; 
}

STRING* INTEGER_REF::out() { 
	STRING *result;

   	result = new STRING;
   	result->make_from_int ( val);
	return result;
}

				 	/* BUG! we don't have STD_FILES available */
void INTEGER_REF::print ( ANY *s)
{ 
	fprintf ( stderr, "%d", val); 
}
 
INTEGER_REF* INTEGER_REF::_Clone (
					int deep, int sclass, INTEGER_REF *_arg) { 
	INTEGER_REF *r = new INTEGER_REF; r->val = _arg->val; return r; 
}

INTEGER_REF*
_ert_clone_INTEGER ( INTEGER v)
{
	INTEGER_REF *result;
	result = new INTEGER_REF;
	result->val = v;
	return result;
}

INTEGER_REF*
_ert_clone_INTEGER_REF ( INTEGER_REF *v)
{
	if ( v) {
		INTEGER_REF *result;
		result = new INTEGER_REF;
		result->val = v->val;
		return result;
	}

	return ( INTEGER_REF *) 0;
}

INTEGER_REF *_INTEGER_REF_chk(INTEGER_REF *rtc, char *fname)
{
   if ( !rtc)
      _eiffel_rt_Assert ( 107, "INTEGER_REF", fname, "void target", 
			false, _ert_longjmp());
   return rtc;
}


BOOLEAN INTEGER_REF::is_equal (INTEGER_REF* p1) { 
	return _Equal( 1, 1, p1); 
}

BOOLEAN INTEGER_REF::equal (ANY* p1, INTEGER_REF* p2) { 
	return (p1)->_Equal ( 0, 1, p2); 
}

void INTEGER_REF::copy ( INTEGER_REF* p1) { 
	_Copy ( 0, 1, p1); 
}

INTEGER_REF* INTEGER_REF::clone (INTEGER_REF *x) {
	 return _Clone( 0, 1, x); 
}

INTEGER_REF* INTEGER_REF::_localClone ( int deep, int sclass) { 
	INTEGER_REF *r = new INTEGER_REF; r->val = val; return r; 
}

BOOLEAN INTEGER_REF::deep_equal ( INTEGER_REF* p1, INTEGER_REF* p2) {
	 return p1->_Equal ( 1, 1, p2); 
}

void INTEGER_REF::deep_copy ( INTEGER_REF* p1) { 
	_Copy ( 1, 1, p1); 
}

INTEGER_REF* INTEGER_REF::deep_clone ( INTEGER_REF *x) {
	 return _Clone (1,1,x); 
}

INTEGER_REF* _bibt_INTEGER_INTEGER_REF ( INTEGER v)
{
	INTEGER_REF *result;
	result = new INTEGER_REF;
	result->set_value ( v);
	return result;
}

#ifndef _BOOLEAN_REF_H

BOOLEAN INTEGER_REF::_INFIX_LEQ ( INTEGER_REF* other)
{
	return val < _INTEGER_REF_chk ( other, "other")->val ? 
       		_ert_BOOLEAN_Const ( true) : _ert_BOOLEAN_Const ( false);
}

INTEGER_REF* INTEGER_REF::_INFIX_ADD ( INTEGER_REF* other)
{
	INTEGER_REF *r = new INTEGER_REF; 
	r->val = _INTEGER_REF_chk ( other, "other")->val + val;
	return r;
}

INTEGER_REF* INTEGER_REF::_INFIX_SUB ( INTEGER_REF* other)
{
	INTEGER_REF *r = new INTEGER_REF; 
	r->val = _INTEGER_REF_chk ( other, "other")->val - val;
	return r;
}

INTEGER_REF* INTEGER_REF::_INFIX_MUL ( INTEGER_REF* other)
{
	INTEGER_REF *r = new INTEGER_REF; 
	r->val = _INTEGER_REF_chk ( other, "other")->val * val;
	return r;
}

INTEGER_REF* INTEGER_REF::_INFIX_DIV ( INTEGER_REF* other)
{
	INTEGER_REF *r = new INTEGER_REF; 
	r->val = _INTEGER_REF_chk ( other, "other")->val / val;
	return r;
}
#endif /* _BOOLEAN_REF_H */

BOOLEAN INTEGER_REF::_Conforms_to ( int other_id)  /* Don't use INTEGER */
{
   	if ( class_id == other_id)
      	return true;

#ifdef _BOOLEAN_REF_H
	{
		ANY a;

		return a._Conforms_to ( other_id);
	}
#else
	{
   		NUMERIC n;

   		if ( n.class_id == other_id)
      		return true;

		return n._Conforms_to ( other_id);
	}
#endif
}
