#
# FreeBSD/options.mk --- Part of Makefile for PFE, compiler options for FreeBSD
#

# My FreeBSD came with gcc-2.4.5 which dies in floating.c when register
# variables are enabled. Comment out -DUSE_REGS if you use this compiler.

PREFIX	= /usr/local
PFELIB	= $(PREFIX)/lib/pfe
PFEHLP	= $(PFELIB)/help

SYSTEM	= FreeBSD

CC	= gcc -pipe -Wall

# for Pentium:
OPTIM	= -O2 -fomit-frame-pointer -DUSE_REGS

# for 486:
OPTIM	= -m486 -O2 -fomit-frame-pointer -DUSE_REGS -DUNROLL_NEXT

DEBUG	= -g

CL	= $(CC)
CPP	= $(CC) -E

OPTIONS	= -D_BSD -DUSE_TERMCAP
STRIP	= -s
TERM_O	= termunix$o
SYS_O	= unix$o
LFLAGS	= 
LIBS	= -ltermcap -lm


