/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * const.h ---	lots of constants and other #defines
 * (duz 09Jul93)
 */

#ifndef __CONST_H
#define	__CONST_H

/* See file options.h for configurable options! */

/*
 * Decompiler style. Each 5 comma separated numbers, meaning:
 * additional spaces after print,
 * cr before print, changed indentation for first cr,
 * cr after print, changed indentation for second cr.
 */

#define	DEFAULT_STYLE	0, 0,  0,  0,  0
#define	LOCALS_STYLE	0, 0,  0,  1,  0
#define	SEMICOLON_STYLE	0, 0, -4,  0,  0
#define	DOES_STYLE	0, 1, -4,  0,  4

#define	IF_STYLE	1, 1,  0,  0,  4
#define	ELSE_STYLE	1, 1, -4,  1,  4
#define	THEN_STYLE	1, 1, -4,  1,  0

#define	BEGIN_STYLE	1, 1,  0,  0,  4
#define	WHILE_STYLE	1, 1, -4,  0,  4
#define	REPEAT_STYLE	1, 1, -4,  1,  0
#define	UNTIL_STYLE	1, 1, -4,  1,  0
#define	AGAIN_STYLE	1, 1, -4,  1,  0

#define	DO_STYLE	1, 1,  0,  0,  4
#define	LOOP_STYLE	1, 1, -4,  1,  0

#define	CASE_STYLE	1, 1,  0,  0,  4
#define	OF_STYLE	1, 1,  0,  0,  4
#define	ENDOF_STYLE	0, 0,  0,  1, -4
#define	ENDCASE_STYLE	0, 1, -4,  1,  0


/* other constants, do not change! */

#define	VERSION		"0.9.13"
#define	DATE		"17-July-95"

#undef FALSE
#undef TRUE
#define	FALSE		((Cell)0)
#define	TRUE		(~FALSE)

#define	SMUDGED		0x20	/* these bits are flags in */
#define	IMMEDIATE	0x40	/* the count byte of a definition */

#define	TIB_SIZE	0x100	/* size of terminal input buffer */
#define	BPBUF		0x400	/* bytes per block */

#define	MAX_LOCALS	(1<<LD_LOCALS)
#define	THREADS		(1<<LD_THREADS)

#ifndef PATH_LENGTH		/* suggested by Andrew Houghton */

# if defined _POSIX_PATH_MAX
#   define PATH_LENGTH _POSIX_PATH_MAX
# elif defined MAXPATHLEN
#   define PATH_LENGTH MAXPATHLEN
# elif defined MAXNAMLEN
#   define PATH_LENGTH MAXNAMLEN
# elif defined PATH_MAX
#   define PATH_LENGTH PATH_MAX
# else
#   define PATH_LENGTH 256
# endif

#endif


/* Readable macros for magic numbers suggested by spc@pineal.math.fau.edu */

#if HIGHBYTE_FIRST
#define	MAKE_MAGIC(A,B,C,D)	((Cell)A << 24 | (Cell)B << 16 |\
				 (Cell)C <<  8 | (Cell)D)
#else
#define	MAKE_MAGIC(A,B,C,D)	((Cell)D << 24 | (Cell)C << 16 |\
				 (Cell)B <<  8 | (Cell)A)
#endif

#define	SAVE_MAGIC		MAKE_MAGIC('P','F','E','S')
#define	EXCEPTION_MAGIC		MAKE_MAGIC('X','C','P','T')
#define	INPUT_MAGIC		MAKE_MAGIC('S','V','I','N')
#define	DEST_MAGIC		MAKE_MAGIC('D','E','S','T')
#define	ORIG_MAGIC		MAKE_MAGIC('O','R','I','G')
#define	LOOP_MAGIC		MAKE_MAGIC('L','O','O','P')
#define	CASE_MAGIC		MAKE_MAGIC('C','A','S','E')
#define	OF_MAGIC		MAKE_MAGIC('O','F','O','F')
#define SEMANT_MAGIC		MAKE_MAGIC('S','E','M','A')

/* THROW codes */

#define	THROW_ABORT		-1
#define	THROW_ABORT_QUOTE	-2
#define	THROW_STACK_OVER	-3
#define	THROW_STACK_UNDER	-4
#define	THROW_RSTACK_OVER	-5
#define	THROW_RSTACK_UNDER	-6
#define	THROW_INVALID_MEMORY	-9
#define	THROW_ARG_TYPE		-12
#define	THROW_UNDEFINED		-13
#define	THROW_COMPILE_ONLY	-14
#define	THROW_INVALID_FORGET	-15
#define	THROW_ZERO_NAME		-16
#define	THROW_PICNUM_OVER	-17
#define	THROW_PARSE_OVER	-18
#define	THROW_NAME_TOO_LONG	-19
#define	THROW_UNSUPPORTED	-21
#define	THROW_CONTROL_MISMATCH	-22
#define	THROW_ADDRESS_ALIGNMENT	-23
#define	THROW_USER_INTERRUPT	-28
#define	THROW_COMPILER_NESTING	-29
#define	THROW_INVALID_NAME	-32
#define	THROW_BLOCK_READ	-33
#define	THROW_BLOCK_WRITE	-34
#define	THROW_INVALID_BLOCK	-35
#define	THROW_FILE_ERROR	-37
#define	THROW_FILE_NEX		-38
#define	THROW_UNEXPECTED_EOF	-39
#define	THROW_FSTACK_OVER	-44
#define	THROW_FSTACK_UNDER	-45
#define	THROW_CURRENT_DELETED	-47
#define	THROW_SEARCH_OVER	-49
#define	THROW_SEARCH_UNDER	-50
#define	THROW_FLOATING_POINT	-55
#define	THROW_QUIT		-56
#define	THROW_IF_ELSE		-58

#define	THROW_NO_BINARY		-2048
#define	THROW_BIN_TOO_BIG	-2049
#define	THROW_OUT_OF_MEMORY	-2050
#define	THROW_INDEX_RANGE	-2051

#endif
