/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * facility.c ---     The Optional Facility Word Set
 * (duz 13Jul93)
 */

#include "forth.h"
#include "support.h"
#include "term.h"

#include <time.h>

#include "missing.h"

Code (at_x_y)
{
  c_gotoxy (sp[1], sp[0]);
  sp += 2;
}

code (key_question)
{
  *--sp = FLAG (c_keypressed ());
}

Code (page)
{
  c_clrscr ();
}

/* Facility Extension Words */

Code (ekey)
{
  *--sp = (Cell) getekey ();
}

Code (ekey_to_char)
{
  --sp;
  sp[0] = FLAG ((uCell) sp[1] < 0x100);
}

Code (ekey_question)
{
  *--sp = FLAG (ekeypressed ());
}

Code (emit_question)
{
  *--sp = TRUE;
}

Code (ms)
{
  millisec (*sp++);
}

Code (time_and_date)
{
  time_t t;
  struct tm *tm;

  time (&t);
  tm = localtime (&t);
  sp -= 6;
  sp[5] = tm->tm_sec;
  sp[4] = tm->tm_min;
  sp[3] = tm->tm_hour;
  sp[2] = tm->tm_mday;
  sp[1] = tm->tm_mon + 1;
  sp[0] = tm->tm_year + 1900;
}

/* *INDENT-OFF* */
LISTWORDS (facility) =
{
  CO ("AT-XY",		at_x_y),
  CO ("KEY?",		key_question),
  CO ("PAGE",		page),
  CO ("EKEY",		ekey),
  CO ("EKEY>CHAR",	ekey_to_char),
  CO ("EKEY?",		ekey_question),
  CO ("EMIT?",		emit_question),
  CO ("MS",		ms),
  CO ("TIME&DATE",	time_and_date)
};
COUNTWORDS (facility, "Facility + extensions");
