/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * search.c ---       The Optional Search Order Word Set
 * (duz 09Jul93)
 */

#include "forth.h"
#include "support.h"
#include "compiler.h"

#include <string.h>

#include "missing.h"

code (definitions)
{
  CURRENT = CONTEXT[0];
}

Code (get_current)
{
  *--sp = (Cell) CURRENT;
}

Code (get_order)
{
  Wordl **p;
  Cell n = 0;

  for (p = &CONTEXT[ORDER_LEN]; --p >= CONTEXT;)
    if (*p)
      *--sp = (Cell) *p, n++;
  *--sp = n;
}

Code (search_wordlist)
{
  char *nfa;

  nfa = search_wordlist ((char *) sp[2], sp[1], (Wordl *) sp[0]);
  if (nfa == NULL)
    {
      sp += 2;
      sp[0] = 0;
    }
  else
    {
      sp += 1;
      sp[0] = *nfa & IMMEDIATE ? 1 : -1;
      sp[1] = (Cell) name_from (nfa);
    }
}

Code (set_current)
{
  CURRENT = (Wordl *) *sp++;
}

Code (set_order)
{
  Cell i, n = *sp++;

  if (n == -1)			/* minimum search order */
    n = 0;			/* equals cleared search order */
  if ((uCell) n > ORDER_LEN)
    tHrow (THROW_SEARCH_OVER);
  for (i = 0; i < n; i++)
    CONTEXT[i] = (Wordl *) *sp++;
  for (; i < ORDER_LEN; i++)
    CONTEXT[i] = NULL;
}

Code (wordlist)
{
  *--sp = (Cell) word_list ();
}

/* Search order extension words ============================================ */

code (also)
{
  int i;

  if (CONTEXT[ORDER_LEN - 1])
    tHrow (THROW_SEARCH_OVER);
  for (i = ORDER_LEN; --i > 0;)
    CONTEXT[i] = CONTEXT[i - 1];
}

void
only_runtime (void)
{
  ZERO (CONTEXT);
  CONTEXT[0] = CURRENT = ONLY;
}

Code (order)
{
  int i;

  get_order_ ();
  for (i = *sp++; --i >= 0;)
    {
      Wordl *w = (Wordl *) *sp++;

      dot_name (to_name (BODY_FROM (w)));
    }
  cr_ ();
  dot_name (to_name (BODY_FROM (ONLY)));
  dot_name (to_name (BODY_FROM (CURRENT)));
}

Code (previous)
{
  int i;

  for (i = 0; i < ORDER_LEN - 1; i++)
    CONTEXT[i] = CONTEXT[i + 1];
  CONTEXT[i] = NULL;
  for (i = 0; i < ORDER_LEN; i++)
    if (CONTEXT[i])
      return;
  tHrow (THROW_SEARCH_UNDER);
}

code (default_order)
{
  memcpy (DEFAULT_ORDER, CONTEXT, sizeof (CONTEXT));
}

code (reset_order)
{
  memcpy (CONTEXT, DEFAULT_ORDER, sizeof (CONTEXT));
}

/* *INDENT-OFF* */
LISTWORDS (search) =
{
  CO ("DEFINITIONS",	definitions),
  DC ("FORTH-WORDLIST",	forth),
  CO ("GET-CURRENT",	get_current),
  CO ("GET-ORDER",	get_order),
  CO ("SEARCH-WORDLIST",search_wordlist),
  CO ("SET-CURRENT",	set_current),
  CO ("SET-ORDER",	set_order),
  CO ("WORDLIST",	wordlist),
  CO ("ALSO",		also),
  VO ("FORTH",		&forth_list),
  OY ("ONLY",		&only_list),
  CO ("ORDER",		order),
  CO ("PREVIOUS",	previous),
  /* hook to activate all pfe extensions: */
  VO ("EXTENSIONS",	&extensions_list),
  CO ("DEFAULT-ORDER",	default_order),
  CO ("RESET-ORDER",	reset_order),
};
COUNTWORDS (search, "Search-order + extensions");
