/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * unix.c ---	Words making sense in UNIX-like systems only.
 *		This file exports a word set system_words. So should do
 *		any alternative files you might create for your OS.
 *
 * (duz 24Feb94)
 */

#include "forth.h"
#include "support.h"

#include <time.h>

#include "nonansi.h"
#include "missing.h"



#if defined (Linux) && !defined (__cplusplus)
/************************************************************************/
/* Linux shared library calls -- KAH 930824				*/
/************************************************************************/

/* ================ */
/* Dynload macros   */
/* ================ */

typedef struct
  {
    unsigned nargs	:4;	/* # of arguments */
    unsigned restype	:2;	/* result type */
    unsigned		:2;	/* reserved -- complex res */
    unsigned argtype	:2;	/* double/long arg flags */
    unsigned		:22;	/* other argtypes shifted */
				/* from here */
  }
control_word;

#define DYN_INTEGER	0
#define DYN_LONGINT	1
#define DYN_FLOAT	2
#define DYN_LONGFLOAT	3

#define exec(sub,resulthi,resultlo)	\
	__asm__ __volatile__ ("call %2;movl %%edx, %0;movl %%eax, %1":	\
	"=g" (resulthi), "=g" (resultlo):"g" (sub): "eax", "edx");
#define cpush(x)	\
	__asm__ __volatile__ ("pushl %0;"::"g" (x));

/* not sure if this float stuff is right.  Are singles and 
   doubles same length?  Are these stored in a different forth stack?
   How do I copy things back and forth from int/pointer stack to
   float stack? */

#define lowfresult(x)	__asm__ __volatile__ ("fstpl %0;":"=g" (x));
#define highfresult(x)	lowfresult(x);


Code (uselibrary)
{
  *sp = uselib ((char *) *sp);
}

static void
call_c (pCode * sub)
{
  int i, high, low, result_type;
  udCell *tmp;
  control_word x = *(control_word *) sp++;

  i = x.nargs;
  result_type = x.restype;
  tmp = (udCell *) fp;
  while (i--)
    {
      switch (x.argtype)
	{
	case DYN_LONGINT:
	  cpush (*sp++);
	case DYN_INTEGER:
	  cpush (*sp++);
	  break;
	case DYN_LONGFLOAT:
	  cpush (tmp->hi);
	case DYN_FLOAT:
	  cpush (tmp++->lo);
	}
      *(uCell *) & x >>= 2;
    }
  exec (sub, high, low);
  switch (result_type)
    {
    case DYN_INTEGER:
      *--sp = low;
      break;
    case DYN_LONGINT:
      *--sp = low;
      *--sp = high;
      break;
    case DYN_FLOAT:
      lowfresult (*--tmp);
      break;
    case DYN_LONGFLOAT:
      lowfresult (*--tmp);
      highfresult (*--tmp);
    }
}

Code (call_c)
{
  call_c ((pCode *) * sp++);
}

#endif /* Linux shared library calls */


#if !(defined(EMX) || defined(WATCOM))

/* defining `#!' to support forth scripts executed by the unix kernel: */
#define ignore_line_ (pCode)refill

Code (termcap)			/* display what we got from termcap */
{
  extern void show_control_strings (int (*) (const char *, ...));
  extern void show_rawkey_strings (int (*) (const char *, ...));
  show_control_strings (outf);
  show_rawkey_strings (outf);
}
#endif

Code (clock)			/* CLOCK ( --- ticks )	return clock() */
{
  *--sp = (Cell)clock ();
}


LISTWORDS (system) =
{
#if defined Linux && !defined __cplusplus
  /* shared libraries */
  CO ("CALL-C",		call_c),
  CO ("USELIBRARY",	uselibrary),
#endif

#if !(defined(EMX) || defined(WATCOM))
  CO ("#!",		ignore_line),
  CO ("TERMCAP",	termcap),
#endif

  CO ("CLOCK",		clock),
#if defined AIX1
  OC ("CLK_TCK",	1000000),
#elif defined CLOCKS_PER_SEC
  OC ("CLK_TCK",	CLOCKS_PER_SEC),
#elif defined CLK_TCK
  OC ("CLK_TCK",	CLK_TCK),
#else
  OC ("CLK_TCK",	1000000), /* just a guess :-) */
#endif
};
COUNTWORDS (system, "Unix words");
