      BLOCK DATA
C
C   This initializes the parameters in MPCOM1 and the error codes in MPCOM2
C   with default values.
C>
C   On IEEE systems and most other 32 bit systems, set BBXC = 4096.D0,
C   NBTC = 24, NPRC = 32, and MCRC = 7.  On Cray systems, set BBXC = 2048.D0,
C   NBTC = 22, NPRC = 16, and MCRC = 8.
C
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      COMMON /MPCOM0/ BBX, BDX, BX2, RBX, RDX, RX2, RXX, NBT, NPR
      COMMON /MPCOM1/ NW, IDB, LDB, IER, MCR, IRD, ICS, IHS, IMS
      COMMON /MPCOM2/ KER(72)
C
      PARAMETER (BBXC = 4096.D0, NBTC = 24, NPRC = 32, MCRC = 7,        
     $  BDXC = BBXC ** 2, BX2C = BDXC ** 2, RBXC = 1.D0 / BBXC,         
     $  RDXC = RBXC ** 2, RX2C = RDXC ** 2, RXXC = 16.D0 * RX2C)
      DATA BBX, BDX, BX2, RBX, RDX, RX2, RXX, NBT, NPR / BBXC, BDXC,    
     $  BX2C, RBXC, RDXC, RX2C, RXXC, NBTC, NPRC/
      DATA NW, IDB, LDB, IER, MCR, IRD, ICS, IHS, IMS /                 
     $  16, 0, 6, 0, MCRC, 1, 1, 1, 1024/
      DATA KER /72 * 2/
      END
