CMP+ PRECISION LEVEL 40
CMP+ OUTPUT PRECISION 40
C
	program chebtst
CMP+ IMPLICIT MULTIP REAL (A-H, O-Z)
	parameter( one = 1)
	parameter( nmax = 50 )
	dimension c(nmax), d(nmax)
CMP+ MULTIP REAL chebfun, chebev
	external chebfun, chebev
	pi = 4 * atan( one )
	b =  pi/2
	a = - b
	n = 22
        write(6,*)  'Chebycheff coefficients for sin(x)/x'
        write(6,*) 'a=',a,' b=',b,' n=',n
	call chebft( a, b, c, n, chebfun )
        write(6,*) 'C coefficients:'
	do 10 i = 1, n
 	  write(6,*) c(i)
 10     continue
        do 20 n = 3, 19, 2
	write(6,*) 'Error at x=', b
	write(6,*)   chebfun(b) - chebev(a,b,c,n,b)
	write(6,*) 'Maximum relative error:', abs(c(n+2))/chebfun(b)
	call chebpc( c, d, n )
	call pcshft( a, b, d, n )
        write(6,*) 'D coefficients:'
	do 20 i = 1, n, 2
 	  write(6,*) d(i)
 20     continue
	end

CMP+ MULTIP REAL chebfun
	function chebfun(x)
CMP+ IMPLICIT MULTIP REAL (A-H, O-Z)
	parameter( one = 1 )
	if( abs(1+x*x) .eq. one ) then
	   chebfun = one
	else
	   chebfun = sin(x) / x
	endif
	end


C* The following fortran routines are Copyright by
C*  W.H. Press, B.R. Flannery, S.A. Taukolsky, W.T. Vetterling,
C*  Numerical Recipes, Cambridge University Press, 1986
C*  (Get the new, expanded edition !)
C*  FTP servers:
C*		world.std.com: vendors/Numerical-Recipes
C*		ic16.ee.umanitoba.ca: pub/srclib (?)
C*
C*  No significant changes were done to the code
C*
      subroutine chebft(a,b,c,n,func)
CMP+ IMPLICIT MULTIP REAL (A-H, O-Z)
CMP+  MULTIP REAL func
      external func
      parameter (nmax=50)
C     parameter (pi=3.141592653589793d0)     Modified j.g.
CMP+  MULTIP REAL sum, pi, one
      real*8 sum, pi, one
      parameter ( one = 1 )
      dimension c(n),f(nmax)
C					     Modified j.g.
      pi = 4 * atan( one )
      bma=0.5*(b-a)
      bpa=0.5*(b+a)
      do 11 k=1,n
        y=cos(pi*(k-0.5)/n)
        f(k)=func(y*bma+bpa)
11    continue
      fac=2./n
      do 13 j=1,n
        sum=0.d0
        do 12 k=1,n
          sum=sum+f(k)*cos((pi*(j-1))*((k-0.5d0)/n))
12      continue
        c(j)=fac*sum
13    continue
      return
      end

CMP+  MULTIP REAL chebev
      function chebev(a,b,c,m,x)
CMP+ IMPLICIT MULTIP REAL (A-H, O-Z)
      dimension c(m)
C      if ((x-a)*(x-b).gt.0.) pause 'x not in range.'     Modified j.g.
      d=0.
      dd=0.
      y=(2.*x-a-b)/(b-a)
      y2=2.*y
      do 11 j=m,2,-1
        sv=d
        d=y2*d-dd+c(j)
        dd=sv
11    continue
      chebev=y*d-dd+0.5*c(1)
      return
      end

      subroutine chebpc(c,d,n)
CMP+ IMPLICIT MULTIP REAL (A-H, O-Z)
      parameter (nmax=50)
      dimension c(n),d(n),dd(nmax)
      do 11 j=1,n
        d(j)=0.
        dd(j)=0.
11    continue
      d(1)=c(n)
      do 13 j=n-1,2,-1
        do 12 k=n-j+1,2,-1
          sv=d(k)
          d(k)=2.*d(k-1)-dd(k)
          dd(k)=sv
12      continue
        sv=d(1)
        d(1)=-dd(1)+c(j)
        dd(1)=sv
13    continue
      do 14 j=n,2,-1
        d(j)=d(j-1)-dd(j)
14    continue
      d(1)=-dd(1)+0.5*c(1)
      return
      end


      subroutine pcshft(a,b,d,n)
CMP+ IMPLICIT MULTIP REAL (A-H, O-Z)
      dimension d(n)
      const=2./(b-a)
      fac=const
      do 11 j=2,n
        d(j)=d(j)*fac
        fac=fac*const
11    continue
      const=0.5*(a+b)
      do 13 j=1,n-1
        do 12 k=n-1,j,-1
          d(k)=d(k)-const*d(k+1)
12      continue
13    continue
      return
      end
