#! /bin/csh
#  apt is a csh script to convert a REAL (DOUBLE PRECISION) version of
#  a Fortran program to DOUBLE PRECISION (REAL) using ISTPT.
#    (via the combined tool fragment ISTQP = ISTLX/ISTYP/ISTPT/ISTPL)
#
#
#  Invocation:
#
#  apt <s or d> Polish_option_file Fortran_source_file
#
#  If the first argument is "s" ("d") then the Fortran in Fortran_source_file
#  will be transformed to a REAL (DOUBLE PRECISION) version.
#
#  Polish_option_file is the name of a file containing Polish options used in
#  reconstructing the transformed Fortran.  If Polish_option_file is "-"
#  then default Polish options will be used.
#
#  Check command line validity.
if ( $#argv < 3 || ( $1 != "s" && $1 != "d" ) ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"apt <s or d> Polish_option_file Fortran_source_file"
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
The first argument is s or d indicating that the transformed
TOOLPACKPATH/toolpack1.2/util/echoerr \
program is to be single or double precision, respectively.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Polish_option_file is created by using script "polx".'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Note: "-" as Polish_option_file gives default options.'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Transformed code is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  "-" as Polish_option_file gives default options.
if ( $2 != - ) then
#  Check that Polish_option_file exists.
   if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist. '-' as the second argument gives default Polish options."
      exit
   endif
endif
#  Check that Fortran_source_file exists.
if ( -e $3 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$3' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = qp.src$$
expand $3 > _.TOOLPACK/$src
#  Create the inter-process file IST.CMD and append parameters for ISTQP.
if ( $1 == "s") then
   set ptoptfile = 'single'
else
   set ptoptfile = 'double'
endif
if ( $2 == - ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src \#1 "$ptoptfile" -
else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src \#1 "$ptoptfile" \#$2
endif
#
#  Invoke ISTQP.
#
TOOLPACKPATH/toolpack1.2/exec/istqp.u
#
#  If tool terminated with errors, advise user to obtain listing.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Errors detected.  Invoke script "getlst" to obtain a listing showing'
TOOLPACKPATH/toolpack1.2/util/echoerr \
statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
endif
#
/bin/rm -r _.TOOLPACK
#
