#! /bin/csh
#  decs is a csh script to rebuild the declarative part of a Fortran program
#  according to a template of options using ISTDS.
#    (via the combined tool fragment ISTQD = ISTLX/ISTYP/ISTDS/ISTPL)
#
#
#  Invocation:
#
#  decs decs_option_file Polish_option_file Fortran_source_file
#
#  decs_option_file is the name of a file containing template options, one per
#  line.  If decs_option_file is "-" then default decs options will be used.
#
#  Polish_option_file is the name of a file containing Polish options used in
#  reconstructing the transformed Fortran.  If Polish_option_file is "-"
#  then default Polish options will be used.
#
#  Check command line validity.
if ( $#argv < 3 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
decs decs_option_file Polish_option_file Fortran_source_file
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
For information about decs_option_file, see Users\' Guide.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Polish_option_file is created by using script "polx".'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Note: "-" in place of either or both option files gives default options.'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Transformed code is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  "-" as decs_option_file gives default options.
if ( $1 != - ) then
#  Check that decs_option_file exists.
   if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$1' does not exist. '-' as the first argument gives default decs options."
      exit
   endif
endif
#  "-" as Polish_option_file gives default options.
if ( $2 != - ) then
#  Check that Polish_option_file exists.
   if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist. '-' as the second argument gives default Polish options."
      exit
   endif
endif
#  Check that Fortran_source_file exists.
if ( -e $3 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$3' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = qd.src$$
expand $3 > _.TOOLPACK/$src
#  Create the inter-process file IST.CMD and append parameters for ISTQD.
if ( $1 == - ) then
   set decsoptfile = 'mode=rebuild_declaratives'
else
   set decsoptfile = `cat $1`
endif
if ( $2 == - ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src \#1 "$decsoptfile" -
else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src \#1 "$decsoptfile" \#$2
endif
#
#  Invoke ISTQD.
#
TOOLPACKPATH/toolpack1.2/exec/istqd.u
#
#  If tool terminated with errors, advise user to obtain listing.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Errors detected.  Invoke script "getlst" to obtain a listing showing'
TOOLPACKPATH/toolpack1.2/util/echoerr \
statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
endif
#
/bin/rm -r _.TOOLPACK
#
