#! /bin/csh
#  getlst is a csh script to produce and send to standard output a listing
#  of a Fortran program showing statement and token numbers, using ISTLX.
#
#
#  Invocation:
#
#  getlst Fortran_source_file
#
#  Check command line validity.
if ( $#argv < 1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
getlst Fortran_source_file
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Listing is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr \
Error/Warning messages are embedded in the listing.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  Check that Fortran_source_file exists.
if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$1' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = src_gl
expand $1 > _.TOOLPACK/$src
#  Lexer token stream file name.
set tkn = tkn_gl
#  Lexer comment file name.
set cmt = cmt_gl
#  Lexer token listing file name.
set lst = lst_gl
#  Create the interprocess file IST.CMD and append parameters for ISTLX.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src $lst $tkn $cmt
#
#  Invoke ISTLX.
#
TOOLPACKPATH/toolpack1.2/exec/istlx.u
#
echo ""
echo In the following listing, the first number is the statement number and
echo the second number is the number of the first token in the statement.
echo Statements are numbered within a program unit, tokens within the file.
echo Scanning errors are indicated.  When a scanning error occurs, the
echo scanner resets and continues.
echo ""
#  Write the listing to standard output.
cat _.TOOLPACK/$lst
#
/bin/rm -r _.TOOLPACK
#
