#! /bin/csh
#  inst is a csh script to instrument a Fortran program using ISTAN.
#  The output report is produced using ISTAL.
#
#
#  Invocation:
#
#  inst Fortran_source_file instrumented_Fortran_source
#
#  Fortran_source_file is the name of a file containing one or more Fortran
#  program units that may contain embedded assertions.  The instrumented
#  source is placed in instrumented_Fortran_source.  Both of these files
#  should have a ".f" suffix.  Files _.ANSTATICSUM and _.ANANNOLIST are
#  created for later use by script rundoc.
#
#  Output to stdout is a report consisting of two parts:  (1) a program
#  listing annotated with segment and assertion identification numbers,
#  (2) a static count of Fortran key words and other program elements.
#
#  Check command line validity.
if ( $#argv < 2 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
inst Fortran_source_file instrumented_Fortran_source
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
An instrumentation report is sent to standard output
TOOLPACKPATH/toolpack1.2/util/echoerr \
and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Files '"_.ANSTATICSUM"' and '"_.ANANNOLIST"' are saved in the working
TOOLPACKPATH/toolpack1.2/util/echoerr \
directory for later use by script rundoc.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  Check that Fortran_source_file exists.
if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$1' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = lx.src$$
expand $1 > _.TOOLPACK/$src
#  Lexer token stream file name.
set tkn = _.lxtkn
#  Lexer comment file name.
set cmt = _.lxcmt
#  Create the interprocess file IST.CMD and append parameters for ISTLX.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src - $tkn $cmt
#
#  Invoke ISTLX.
#
TOOLPACKPATH/toolpack1.2/exec/istlx.u
#
#  If lexer errors are reported, advise user to obtain listing and exit.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Program has lexical scanning errors.  Invoke script "getlst"'
TOOLPACKPATH/toolpack1.2/util/echoerr \
to obtain a listing showing statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   /bin/rm -r _.TOOLPACK
   exit
endif
#
#  Create parameters for ISTAN.
#
#  The static summary file.
set statsum = \#_.ANSTATICSUM
#  The annotated token stream.
set antkn = an.atk$$
#  The annotated comment stream.
set ancmt = an.acm$$
#  The readable summary file (will be discarded because the same
#  information will be created by ISTAL later).
set pitch = an.dis$$
#  Create the interprocess file IST.CMD and append parameters for ISTAN.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt \#$2 $statsum $antkn $ancmt $pitch \
"rund='_.ANRUNDATA' asse trac='Trace_Requests','Trace_Output' list='_.XREPORT'"
#
#  Invoke ISTAN.
#
TOOLPACKPATH/toolpack1.2/exec/istan.u
#
#  Create the annotated listing file by unscanning the annotated token
#  and comment streams.
set anlst = \#_.ANANNOLIST
#  Create the interprocess file IST.CMD and append parameters for ISTPL.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$antkn $ancmt $anlst -
#
#  Invoke ISTPL.
#
TOOLPACKPATH/toolpack1.2/exec/istpl.u
#
#  Create an output file for ISTAL.
set repout = alout$$
#  Create the interprocess file IST.CMD and append parameters for ISTAL.
#  (.../instREP is an input document for ISTAL written to report the
#  desired information.  The output will be nroff'ed to produce the
#  static summary report and the annotated listing.)
TOOLPACKPATH/toolpack1.2/util/mkipf \
\#TOOLPACKPATH/toolpack1.2/util/instREP $repout
#
#  Invoke ISTAL.
#
TOOLPACKPATH/toolpack1.2/exec/istal.u
nroff _.TOOLPACK/$repout
#
/bin/rm -r _.TOOLPACK
#
