#! /bin/csh
#  lname is a csh script to standardize long Fortran variable names
#  using ISTLS.
#
#
#  Invocation:
#
#  lname name_conversion_file Polish_option_file Fortran_source_file
#
#  Check command line validity
if ( $#argv < 3 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
lname name_conversion_file Polish_option_file Fortran_source_file
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
name_conversion_file contains a list of name conversions.  The user
TOOLPACKPATH/toolpack1.2/util/echoerr \
is prompted for replacements for long names that do not occur in
TOOLPACKPATH/toolpack1.2/util/echoerr \
name_conversion_file.  This file is created if it does not exist and
TOOLPACKPATH/toolpack1.2/util/echoerr \
is updated at the conclusion of the run.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Polish_option_file is created by script "polx".'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Note: "-" as Polish_option_file gives default options.'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Transformed code is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
A file '"_.LOG"' showing the name changes by token number is created
TOOLPACKPATH/toolpack1.2/util/echoerr \
in the working directory.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  Conversion file name.
set conv = $1
if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"New conversion file: '$1'"
endif
#  "-" as Polish_option_file gives default options.
if ( $2 != - ) then
#  Check that Polish_option_file exists.
   if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist. '-' as the first argument gives default Polish options."
      exit
   endif
endif
#  Check that Fortran_source_file exists.
if ( -e $3 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$3' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = lx.src$$
expand $3 > _.TOOLPACK/$src
#  Lexer token stream file name.
set tkn = _.lxtkn
#  Lexer comment file name.
set cmt = _.lxcmt
#  Create the interprocess file IST.CMD and append parameters for ISTLX.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src - $tkn $cmt
#
#  Invoke ISTLX.
#
TOOLPACKPATH/toolpack1.2/exec/istlx.u
#
#  If lexer errors are reported, advise user to obtain listing and exit.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Program has lexical scanning errors.  Invoke script "getlst"'
TOOLPACKPATH/toolpack1.2/util/echoerr \
to obtain a listing showing statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   /bin/rm -r _.TOOLPACK
   exit
endif
#  Files for output token stream.
set tknout = _.lstkn$$
set cmtout = _.lscmt$$
#  Log file.
set log = _.lslog$$
#  Create the interprocess file IST.CMD and append parameters for ISTLS.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt $tknout $cmtout \#$conv $log
#
#  Invoke ISTLS.
#
TOOLPACKPATH/toolpack1.2/exec/istls.u
#
#  Invoke Polish to unscan and format transformed code.
if ( $2 == - ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tknout $cmtout \#1 -
else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tknout $cmtout \#1 \#$2
endif
#
#  Invoke ISTPL.
#
TOOLPACKPATH/toolpack1.2/exec/istpl.u
#
TOOLPACKPATH/toolpack1.2/util/echoerr \
See log of token changes in file '"_.LOG"'.
TOOLPACKPATH/toolpack1.2/util/echoerr \
A listing showing token numbers can be obtained by running script '"getlst"'.
mv _.TOOLPACK/$log _.LOG
#
/bin/rm -r _.TOOLPACK
#
