#! /bin/csh
#  rundoc is a csh script to run a Fortran program instrumented by ISTAN
#  and generate documentation information therefrom using ISTAL.
#
#
#  Invocation:
#
#  rundoc execute_command_line input_file output_file
#
#  Note: execute_command_line is a command line in Unix for the execution
#  of a program instrumented with script inst.  The command line must be
#  written without blanks.
#
#  Check command line validity.
if ( $#argv < 3 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
rundoc execute_command_line input_file output_file
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
execute_command_line is a Unix command line, written without blanks, for
TOOLPACKPATH/toolpack1.2/util/echoerr \
the execution of a program instrumented with script '"inst"'.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
input_file is a user-written template of a report that will be written
TOOLPACKPATH/toolpack1.2/util/echoerr \
as output_file.  input_file has the form of a document containing troff
TOOLPACKPATH/toolpack1.2/util/echoerr \
requests.  In the places in the document where information derived from
TOOLPACKPATH/toolpack1.2/util/echoerr \
instrumenting and executing the program is to be inserted, the user
TOOLPACKPATH/toolpack1.2/util/echoerr \
writes a special request of the form '".al X"' where '"X"' indicates
TOOLPACKPATH/toolpack1.2/util/echoerr \
the information to be inserted.  Following are the acceptable values
TOOLPACKPATH/toolpack1.2/util/echoerr \
for X showing the nature of the information that will be inserted:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_SE    A summary, by program unit, of segment execution counts'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_TO    A summary, by program unit, of segment execution counts as'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'       fractions of the total'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_Z     A summary, by program unit, of segments not executed'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_L     A listing of the program showing segment execution counts'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_AS    A summary, by program unit, of assertion failures'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_DY    A summary, by program unit, of statement type execution counts'
TOOLPACKPATH/toolpack1.2/util/echoerr \
"_IC    Blocks of comments included by the SED "switch" (see Users' Guide)"
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
A summary report of segment execution counts and assertion failure
TOOLPACKPATH/toolpack1.2/util/echoerr \
counts will be placed in a file called '"_.XREPORT"' in the working
TOOLPACKPATH/toolpack1.2/util/echoerr \
directory, regardless of what information is specified in input_file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Files '"_.ANSTATICSUM"' and '"_.ANANNOLIST"' from the execution of inst
TOOLPACKPATH/toolpack1.2/util/echoerr \
must be present in the working directory and are retained.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  The output file is written to stdout.  The existence of files
#  _.ANSTATICSUM and _.ANANNOLIST from an execution of script inst
#  is assumed.  Check to be sure these files exist.
if ( -e _.ANSTATICSUM == 0 || -e _.ANANNOLIST == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
_.ANSTATICSUM and _.ANANNOLIST from execution of script inst
TOOLPACKPATH/toolpack1.2/util/echoerr \
must be present in the working directory.
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Run the instrumented program.
$1
#  Create the input file for ISTAL by prepending the macro definitions
#  and file loading commands to input_file, and then expanding the macros.
set repin = alin$$
set scratch = scrch$$
cat TOOLPACKPATH/toolpack1.2/util/Rundoc.Head $2 > _.TOOLPACK/$scratch
m4 _.TOOLPACK/$scratch > _.TOOLPACK/$repin
#  Create the interprocess file IST.CMD and append parameters for ISTAL.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$repin \#$3
#
#  Invoke ISTAL.
#
TOOLPACKPATH/toolpack1.2/exec/istal.u
#
#  Move instrumented-run generated file to the PFS where it will be removed.
mv _.ANRUNDATA _.TOOLPACK
/bin/rm -r _.TOOLPACK
#
