C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
C
C  ZLLAPP - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  APPEND A NEW ELEMENT INTO A LINKED LIST AFTER THE CURRENT ELEMENT
C  AND MAKE THE NEW ELEMENT THE CURRENT ELEMENT
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' OR 'NOERR'.
C
      INTEGER FUNCTION ZLLAPP(VALUES, ARRAY)
 
      INTEGER FREPNT, STEP, I, POINT
      INTEGER VALUES(*), ARRAY(*)
 
C  CHECK LEGALITY OF REQUEST
      ZLLAPP = -1
      IF(ARRAY(1) .NE. 108)  RETURN
      ZLLAPP = -100
      IF(ARRAY(8) - ARRAY(4) .EQ. 0) RETURN
 
C  LOOK FOR AN EMPTY ENTRY (NEGATIVE POINTERS).
      STEP = ARRAY(3) + 2
      DO 10 FREPNT = 9, ARRAY(2), STEP
        IF((ARRAY(FREPNT) .EQ. -1) .AND.
     +     (ARRAY(FREPNT+1) .EQ. -1)) GO TO 20
   10 CONTINUE
      RETURN
 
C  COPY THE VALUES INTO THE ENTRY
   20 CONTINUE
      DO 30 I = 1, ARRAY(3)
        ARRAY(FREPNT + 1 + I) = VALUES(I)
   30 CONTINUE
 
C  UPDATE THE POINTERS, THERE IS A DIFFERENT TECHNIQUE IF THE LIST
C  IS CURRENTLY EMPTY
 
      IF(ARRAY(4) .EQ. 0) THEN
        ARRAY(7)          = FREPNT
        ARRAY(FREPNT)     = FREPNT
        ARRAY(FREPNT + 1) = FREPNT
 
      ELSE
        POINT = ARRAY(6)
        ARRAY(FREPNT)            = POINT
        ARRAY(FREPNT + 1)        = ARRAY(POINT + 1)
        ARRAY(ARRAY(POINT + 1))  = FREPNT
        ARRAY(POINT + 1)         = FREPNT
 
      ENDIF
 
      ARRAY(4) = ARRAY(4) + 1
      ARRAY(5) = ARRAY(5) + 1
      ARRAY(6) = FREPNT
 
      ZLLAPP = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZLLCHG - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  CHANGE THE CONTENTS OF THE CURRENT ELEMENT
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' , 'EOF' OR THE ELEMENT NUMBER
C
      INTEGER FUNCTION ZLLCHG(VALUES, ARRAY)
 
      INTEGER I
      INTEGER VALUES(*), ARRAY(*)
 
C  CHECK LEGALITY OF REQUEST
      ZLLCHG = -1
      IF(ARRAY(1) .NE. 108)  RETURN
      IF(ARRAY(4) .EQ. 0)     RETURN
 
C  UPDATE THE LIST ELEMENT VALUES
      DO 10 I = 1, ARRAY(3)
        ARRAY(ARRAY(6) + 1 + I) = VALUES(I)
   10 CONTINUE
 
      ZLLCHG = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZLLDEL - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  DELETE THE CURRENT ELEMENT FROM THE LIST AND MAKE THE PREVIOUS ELEMENT
C  THE CURRENT ELEMENT
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR', 'EOF' OR 'NOERR'.
C
      INTEGER FUNCTION ZLLDEL(ARRAY)
 
      INTEGER POINT, FPOINT, BPOINT
      INTEGER ARRAY(*)
 
C  CHECK LEGALITY OF REQUEST
      ZLLDEL = -1
      IF(ARRAY(1) .NE. 108)  RETURN
      ZLLDEL = -100
      IF(ARRAY(4) .EQ. 0) RETURN
 
C SAVE THE POINTERS AND SET THE ELEMENT TO 'EMPTY'
      POINT  = ARRAY(6)
      FPOINT = ARRAY(POINT + 1)
      BPOINT = ARRAY(POINT)
      ARRAY(POINT)     = -1
      ARRAY(POINT + 1) = -1
 
C  UPDATE THE OTHER LIST POINTERS, THERE IS A DIFFERENT ACTION
C  IF THIS IS THE ONLY ELEMENT
      IF(ARRAY(4) .EQ. 1) THEN
        ARRAY(5) = 0
        ARRAY(6) = 0
        ARRAY(7) = 0
 
      ELSE
        IF(POINT .EQ. ARRAY(7)) ARRAY(7) = ARRAY(POINT)
        ARRAY(BPOINT + 1) = FPOINT
        ARRAY(FPOINT)     = BPOINT
        ARRAY(6)          = BPOINT
 
      ENDIF
 
 
      ARRAY(4) = ARRAY(4) - 1
      IF(ARRAY(4) .NE. 0) ZLLDEL = -2
      ARRAY(5) = ARRAY(5) - 1
      IF(ARRAY(5) .LE. 0) ARRAY(5) = ARRAY(4)
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZLLINT - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  INITIALISE AN ARRAY AS A LINKED LIST
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' (THE SIZE OF THE ARRAY
C  OR SPECIFIED WIDTH IS WRONG) OR 'NOERR'. THERE IS
C  AN OVERHEAD OF 8 LOCATIONS RESERVED BY THE ROUTINES. NOT ALL THE
C  RESERVED LOCATIONS ARE USED AT PRESENT.
C  AN ADDITIONAL OVERHEAD OF 2 LOCATIONS PER LIST ENTRY IS USED TO
C  RETAIN THE BAC AND FORWARD POINTERS RESPECTIVELY POINTERS.
C
      INTEGER FUNCTION ZLLINT(ARRAY, SIZE, WIDTH)
 
      INTEGER SIZE, WIDTH, STEP, I
      INTEGER ARRAY(*)
 
      ZLLINT = -1
      IF(WIDTH .LT. 0)          RETURN
      IF(SIZE  .LT. WIDTH + 10) RETURN
 
C  IDENTIFY THE ARRAY AS A TABLE
      ARRAY(1) = 108
C  THE SIZE OF THE ARRAY
      ARRAY(2) = SIZE
C  THE WIDTH OF EACH ELEMENT
      ARRAY(3) = WIDTH
C  THE NUMBER OF ENTRIES
      ARRAY(4) = 0
C  THE CURRENT ENTRY NUMBER
      ARRAY(5) = 0
C  THE CURRENT ENTRY POINTER
      ARRAY(6) = 0
C  THE START OF THE RING
      ARRAY(7) = 0
C  MAXIMUM NUMBER OF ENTRIES
      ARRAY(8) = (ARRAY(2) - 8) / (WIDTH + 2)
 
C  CLEAR THE POINTERS
      STEP = WIDTH + 2
      DO 10 I = 9, SIZE, STEP
        ARRAY(I)     = -1
        ARRAY(I + 1) = -1
   10 CONTINUE
 
      ZLLINT = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZLLMOV - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  MOVE TO A RELATIVE ELEMENT AS IF THIS WERE A RING LIST
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' OR THE ELEMENT NUMBER
C
      INTEGER FUNCTION ZLLMOV(MOVE, VALUES, ARRAY)
 
      INTEGER I, STEP, MOVE
      INTEGER VALUES(*), ARRAY(*)
      LOGICAL DIR
 
      ZLLMOV = -1
      IF(ARRAY(1) .NE. 108)  RETURN
      IF(ARRAY(4) .EQ. 0)     RETURN
 
      STEP = MOVE
      DIR = .TRUE.
      IF(MOVE .LT. 0) THEN
        DIR  = .FALSE.
        STEP = - MOVE
      ENDIF
      STEP = MOD(STEP, ARRAY(4))
 
      IF(STEP .GT. 0) THEN
        IF(DIR) THEN
          DO 20 I = 1, STEP
            ARRAY(5) = ARRAY(5) + 1
            IF(ARRAY(5) .GT. ARRAY(4)) ARRAY(5) = 1
            ARRAY(6) = ARRAY(ARRAY(6) + 1)
   20     CONTINUE
 
        ELSE
          DO 30 I = 1, STEP
            ARRAY(5) = ARRAY(5) - 1
            IF(ARRAY(5) .LE. 0) ARRAY(5) = ARRAY(4)
            ARRAY(6) = ARRAY(ARRAY(6))
   30     CONTINUE
 
        ENDIF
      ENDIF
 
      DO 10 I = 1, ARRAY(3)
        VALUES(I) = ARRAY(ARRAY(6) + 1 + I)
   10 CONTINUE
 
      ZLLMOV = ARRAY(5)
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZLLNXT - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  GO TO THE NEXT ELEMENT AS IF THIS WERE A LINEAR LIST
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' , 'EOF' OR THE ELEMENT NUMBER
C
      INTEGER FUNCTION ZLLNXT(VALUES, ARRAY)
 
      INTEGER I
      INTEGER VALUES(*), ARRAY(*)
 
      ZLLNXT = -1
      IF(ARRAY(1) .NE. 108)  RETURN
      ZLLNXT = -100
      IF(ARRAY(4) .EQ. 0)     RETURN
      IF(ARRAY(5) .GE. ARRAY(4)) RETURN
 
      ARRAY(6) = ARRAY(ARRAY(6) + 1)
      DO 10 I = 1, ARRAY(3)
        VALUES(I) = ARRAY(ARRAY(6) + 1 + I)
   10 CONTINUE
 
      ARRAY(5) = ARRAY(5) + 1
      ZLLNXT = ARRAY(5)
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZLLPRE - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  GO TO THE PREVIOUS ELEMENT AS IF THIS WERE A LINEAR LIST
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' , 'EOF' OR THE ELEMENT NUMBER
C
      INTEGER FUNCTION ZLLPRE(VALUES, ARRAY)
 
      INTEGER I
      INTEGER VALUES(*), ARRAY(*)
 
      ZLLPRE = -1
      IF(ARRAY(1) .NE. 108)  RETURN
      ZLLPRE = -100
      IF(ARRAY(4) .LE. 1) RETURN
 
      ARRAY(6) = ARRAY(ARRAY(6))
      DO 10 I = 1, ARRAY(3)
        VALUES(I) = ARRAY(ARRAY(6) + 1 + I)
   10 CONTINUE
 
      ARRAY(5) = ARRAY(5) - 1
      ZLLPRE   = ARRAY(5)
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZLLTYP - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  RETURN INFORMATION ABOUT AN INITIALISED LINKED LIST
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' OR 'NOERR'.
C
      INTEGER FUNCTION ZLLTYP(ARRAY, WIDTH, CURNO, ENTRYS, FREE)
 
      INTEGER ENTRYS, FREE, CURNO, WIDTH
      INTEGER ARRAY(*)
 
      ZLLTYP = -1
      IF(ARRAY(1) .NE. 108)  RETURN
 
C  THE WIDTH OF EACH ELEMENT
      WIDTH = ARRAY(3)
 
C  THE NUMBER OF ENTRIES
      ENTRYS = ARRAY(4)
      FREE   = ARRAY(8) - ENTRYS
 
C  THE CURRENT ENTRY NUMBER
      CURNO = ARRAY(5)
 
      ZLLTYP = -2
 
      RETURN
      END
