C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
C
C  ZSAGET - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  GET AN ELEMENT FROM THE SPARSE ARRAY, CURRENTLY A LINEAR SEARCH
C  IS USED FOR THE ARRAY REFERENCES, A HASHED SEARCH MAY BE USED
C  IN A LATER RELEASE
C
      INTEGER FUNCTION ZSAGET(VALUE, XIND, YIND, ARRAY)
 
      INTEGER XIND, YIND, VALUE, I, OFFSET
      INTEGER ARRAY(*)
 
      ZSAGET = -1
      IF(ARRAY(1) .NE. 122)     RETURN
      ZSAGET = -2
 
      DO 10 I = 1, ARRAY(5)
        OFFSET = 8 + ((I - 1) * 3)
        IF(ARRAY(OFFSET + 1) .EQ. XIND) THEN
          IF(ARRAY(OFFSET + 2) .EQ. YIND) THEN
            VALUE = ARRAY(OFFSET + 3)
            RETURN
          ENDIF
        ENDIF
   10 CONTINUE
 
      VALUE = ARRAY(3)
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZSAINT - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  INITIALISE AN ARRAY AS A SPARSE ARRAY
C
C  AN OVERHEAD OF 8 LOCATIONS RESERVED BY THE ROUTINES. NOT ALL THE
C  RESERVED LOCATIONS ARE USED AT PRESENT.
C
      INTEGER FUNCTION ZSAINT(ARRAY, SIZE, DEFALT)
 
      INTEGER SIZE, DEFALT
      INTEGER ARRAY(*)
 
      ZSAINT = -1
      IF(SIZE .LE. 9) RETURN
 
C  IDENTIFY THE ARRAY AS A SPARSE ARRAY
      ARRAY(1) = 122
C  THE SIZE OF THE ARRAY
      ARRAY(2) = SIZE
C  THE DEFAULT RESPONSE
      ARRAY(3) = DEFALT
 
C  THE MAXIMUM NUMBER OF ELEMENTS THAT CAN BE STORED IN THE BUFFER
      ARRAY(4) = (SIZE - 8) / 3
C  THE NUMBER OF ELEMENTS CURRENTLY STORED IN THE BUFFER
      ARRAY(5) = 0
C  UNUSED
      ARRAY(6) = 0
      ARRAY(7) = 0
      ARRAY(8) = 0
 
      ZSAINT = ARRAY(4)
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZSAPUT - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  PUT AN ELEMENT INTO THE SPARSE ARRAY, CURRENTLY A LINEAR SEARCH
C  IS USED FOR THE ARRAY REFERENCES, A HASHED SEARCH MAY BE USED
C  IN A LATER RELEASE
C
      INTEGER FUNCTION ZSAPUT(VALUE, XIND, YIND, ARRAY)
 
      INTEGER VALUE, XIND, YIND, OFFSET, I
      INTEGER ARRAY(*)
 
      ZSAPUT = -1
      IF(ARRAY(1) .NE. 122)     RETURN
      ZSAPUT = -100
      IF(ARRAY(4) .EQ. ARRAY(5)) RETURN
      ZSAPUT = -2
 
      DO 10 I = 1, ARRAY(5)
        OFFSET = 8 + ((I - 1) * 3)
        IF(ARRAY(OFFSET + 1) .EQ. XIND) THEN
          IF(ARRAY(OFFSET + 2) .EQ. YIND) THEN
            ARRAY(OFFSET + 3) = VALUE
            RETURN
          ENDIF
        ENDIF
   10 CONTINUE
 
      OFFSET   = 8 + (ARRAY(5) * 3)
      ARRAY(5) = ARRAY(5) + 1
      ARRAY(OFFSET + 1) = XIND
      ARRAY(OFFSET + 2) = YIND
      ARRAY(OFFSET + 3) = VALUE
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZSATYP - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  RECOVER INFORMATION ABOUT AN ARRAY SET UP FOR SPARSE ARRAY HANDLING
C
      INTEGER FUNCTION ZSATYP(ARRAY, DEFALT, FREE)
 
      INTEGER DEFALT, FREE
      INTEGER ARRAY(*)
 
      ZSATYP = -1
      IF(ARRAY(1) .NE. 122) RETURN
 
C  THE DEFAULT RESPONSE
      DEFALT = ARRAY(3)
 
C  THE MAXIMUM NUMBER OF ELEMENTS THAT CAN BE STORED IN THE BUFFER
      FREE = ARRAY(4) - ARRAY(5)
 
      ZSATYP = -2
 
      RETURN
      END
