C---------------------------------------------------------
C    TOOLPACK/1    Release: 2.4
C---------------------------------------------------------
C
C  ISTAL  - FORTRAN 77 ANALYSER  PROGRAM
C           BASED ON NBS F77 ANALYSER BY TRW
C
C  TIE CONFORMANCE:      BOB ILES SEP 1984
C
C          TIE VERSION
C
      PROGRAM ISTAL
 
      INTEGER CMD
      INTEGER CMDPTH(81), OUTPTH(81)
 
      INTEGER OPEN, GETARG, CREATE
C---------------------------------------------------------
C    TOOLPACK/1    Release: 2.4
C---------------------------------------------------------
      INTEGER ANNFD,  DYNFD,  SUMFD
      INTEGER ANNNAM(81), DYNNAM(81),
     +        SUMNAM(81)
 
      COMMON /CFILES/  ANNNAM, DYNNAM, SUMNAM,
     +                 ANNFD,  DYNFD,  SUMFD
C---------------------------------------------------------
C    TOOLPACK/1    Release: 2.4
C---------------------------------------------------------
      LOGICAL VERBOS, CASFOL, DEBUG, INTRIN, IMPLI, DECLIE
      INTEGER OUTFD,  RMARG, REPRTS
 
      COMMON /CINFO/ VERBOS, OUTFD, CASFOL, RMARG,
     +               DEBUG, REPRTS, INTRIN, IMPLI, DECLIE
      SAVE
 
C INITIALISE TIE AND RECOVER PARAMETERS
      CALL ZINIT
 
C CHECK FOR THE EXISTENCE OF THE REQUIRED PATHNAME
      IF(GETARG(1, CMDPTH, 81) .EQ. -100) CALL NAMES(1, CMDPTH)
      IF(GETARG(2, OUTPTH, 81) .EQ. -100) CALL NAMES(2, OUTPTH)
 
C OPEN OR CREATE ALL FILES
      CMD = OPEN (CMDPTH, 0)
      IF (CMD .EQ. -1) CALL ERROR
     +  ('ISTAL - UNABLE TO OPEN COMMAND INPUT FILE.')
 
      OUTFD = CREATE (OUTPTH, 1)
      IF (OUTFD .EQ. -1) CALL ERROR
     +  ('ISTAL - UNABLE TO CREATE OUTPUT FILE.')
 
      ANNFD = -1
      DYNFD = -1
      SUMFD = -1
      ANNNAM(1) = 129
      DYNNAM(1) = 129
      SUMNAM(1) = 129
      REPRTS = 0
      VERBOS = .FALSE.
      DEBUG  = .FALSE.
      CASFOL = .TRUE.
      INTRIN = .TRUE.
      IMPLI  = .TRUE.
      DECLIE = .FALSE.
      IF(OUTFD .EQ. 1) THEN
        RMARG  = 80
      ELSE
        RMARG  = 65
      ENDIF
C
C  CALL THE FORMATTING ROUTINES
C
      CALL SPOSTD(CMD)
 
      IF(REPRTS .EQ. 0) THEN
        CALL ZMESS('[ISTAL Normal Termination].', 1)
        CALL ZQUIT(-2)
      ELSE
        CALL ZMESS('[ISTAL errors reported].', 1)
        CALL ZQUIT(-1)
      ENDIF
 
      END
C---------------------------------------------------------------------
C
      SUBROUTINE NAMES(OPT, PATH)
 
      INTEGER PATH(*), MSG1(13), MSG2(14)
      INTEGER ZGTCMD
      INTEGER STAT, OPT
 
      DATA (MSG1(STAT),STAT=1,13)/73,110,112,117,116,32,
     +                      102,105,108,101,58,32,129/
      DATA (MSG2(STAT),STAT=1,14)/79,117,116,112,117,116,32,
     +                      102,105,108,101,58,32,129/
 
      IF(OPT .EQ. 1) CALL ZPRMPT(MSG1)
      IF(OPT .EQ. 2) CALL ZPRMPT(MSG2)
      STAT = ZGTCMD(PATH, 0)
 
      RETURN
      END
C -------------------------------------------------------------
C
C  INITIALIZE SYSTEM STATEMENT TYPE DIRECTORY.
C
      SUBROUTINE KEYS
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 2.4
C---------------------------------------------------------
C
C     .. Parameters ..
C
C  MAXSEG     The maximum number of segments that can be held in memory
C  MAXROU     The maximum number of routines that can be held in memory
C
 
      INTEGER LMAXG, MAXSEG, MAXROU, MAXASR, MAXPRO
      PARAMETER(LMAXG=61, MAXSEG=2048, MAXROU=512, MAXASR=512)
      PARAMETER(MAXPRO= MAXROU + 1)
C     ..
C---------------------------------------------------------
C    TOOLPACK/1    Release: 2.4
C---------------------------------------------------------
C     .. Scalars in Common ..
      INTEGER     KAGOG,
     +            KAIFG,KASMTG,KASSNG,KBACKG,KBIFG,KBLOKG,KCALLG,KCFUNG,
     +            KCGOG,KCHARG,KCLOSG,KCMPXG,KCOMNG,KCONTG,KDATAG,
     +            KDBLEG,KDFUNG,KDIMNG,KDOG,KELSEG,KELSFG,KENDFG,KENDG,
     +            KENDIG,KEQIVG,KEXTLG,KFORMG,KIFUNG,KIMPLG,KINQRG,
     +            KINSCG,KINTEG,KLFUNG,KLIFG,KLOGCG,KNONEG,KNTRYG,
     +            KOPENG,KPARAG,KPAUSG,KPRNTG,KPROGG,KREADG,KREALG,
     +            KRETNG,KRFUNG,KSAVEG,KSFUNG,KSTOPG,KSUBRG,KUFUNG,
     +            KUGOG,KWINDG,KWRITG,KXFUNG,LASRTG,LCMNTG,LERRG,
     +            LLINEG,LSTMTG
C     ..
C     .. Common blocks ..
      COMMON      /KEYSC/KAGOG,KAIFG,KASMTG,KASSNG,KBACKG,KBIFG,KBLOKG,
     +            KCALLG,KCFUNG,KCGOG,KCHARG,KCLOSG,KCMPXG,KCOMNG,
     +            KCONTG,KDATAG,KDBLEG,KDFUNG,KDIMNG,KDOG,KELSEG,KELSFG,
     +            KENDFG,KENDG,KENDIG,KEQIVG,KEXTLG,KFORMG,KIFUNG,
     +            KIMPLG,KINQRG,KINSCG,KINTEG,KLFUNG,KLIFG,KLOGCG,
     +            KNONEG,KNTRYG,KOPENG,KPARAG,KPAUSG,KPRNTG,KPROGG,
     +            KREADG,KREALG,KRETNG,KRFUNG,KSAVEG,KSFUNG,KSTOPG,
     +            KSUBRG,KUFUNG,KUGOG,KWINDG,KWRITG,KXFUNG,LASRTG,
     +            LCMNTG,LERRG,LLINEG,LSTMTG
C     ..
      SAVE
 
      KASSNG  = 1
      KBACKG  = 2
      KBLOKG  = 3
      KCALLG  = 4
      KCFUNG  = 5
      KCHARG  = 6
      KCLOSG  = 7
      KCOMNG  = 8
      KXFUNG  = 9
      KCMPXG  = 10
      KCONTG  = 11
      KDATAG  = 12
      KDIMNG  = 13
      KDFUNG  = 14
      KDBLEG  = 15
      KDOG    = 16
      KELSFG  = 17
      KELSEG  = 18
      KENDFG  = 19
      KENDIG  = 20
      KENDG   = 21
      KNTRYG  = 22
      KEQIVG  = 23
      KEXTLG  = 24
      KFORMG  = 25
      KUFUNG  = 26
      KUGOG   = 27
      KLIFG   = 28
      KIMPLG  = 29
      KINQRG  = 30
      KIFUNG  = 31
      KINTEG  = 32
      KINSCG  = 33
      KLFUNG  = 34
      KLOGCG  = 35
      KOPENG  = 36
      KPARAG  = 37
      KPAUSG  = 38
      KPRNTG  = 39
      KPROGG  = 40
      KREADG  = 41
      KRFUNG  = 42
      KREALG  = 43
      KRETNG  = 44
      KWINDG  = 45
      KSAVEG  = 46
      KSTOPG  = 47
      KSUBRG  = 48
      KWRITG  = 49
      KAGOG   = 50
      KCGOG   = 51
      KAIFG   = 52
      KBIFG   = 53
      KASMTG  = 54
      KSFUNG  = 55
      KNONEG  = 56
      LASRTG  = 57
      LCMNTG  = 58
      LERRG   = 59
      LLINEG  = 60
      LSTMTG  = 61
 
      RETURN
      END
 
