C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
 
 
 
 
 
 
 
 
C                                   parameter length
 
 
 
 
 
 
 
C ======================================================================
C
C       Y Y L I B   -   Library for Yacc-generated parser for tree build
C
C       Part 1: Parser Interface
C
C       Part 2: String Table Functions
C
C       Part 3: Parse Tree Functions
C
C       Part 4: Symbol Table Functions
C
C ======================================================================
C
C ----------------------------------------------------------------------
C
C       Y P A R S E   -   Call the parser to parse a program
C
C Arguments:
C   INPFD - Input file descriptor as required by the version of YYLEX in
C           use; will either be a source file or a token stream file.
C   CMTFD - Comment file descriptor as required by YYLEX; if INPFD is
C           a source file, then CMTFD will be an output comment file fd,
C           and if INPFD is a token stream CMTFD will be an input comment
C           file descriptor.
C   ERRFD - Secondary error listing file descriptor (e.g. the symbol
C           table file).
C   CIFD  - Comment index file descriptor (output file).
C   NERRS - Receives the parser error count
C   NWARNS- Receives the number of warnings produced
C
C   The function value is 0 (parse successful) and non-zero otherwise.
C   Note: A successful parse doesn't mean there were no errors, just none
C         which weren't recovered from.
C
 
        INTEGER FUNCTION YPARSE(INPFD,CMTFD,ERRFD,CIFD,NERRS,NWARNS)
        INTEGER INPFD,CMTFD,ERRFD,CIFD,NERRS,NWARNS
 
        INTEGER STKSIZ
        PARAMETER (STKSIZ=512)
 
        COMMON/YCONTX/PUNAMP,STMTNO
        INTEGER PUNAMP,STMTNO
 
        COMMON/YPERRC/NERROR,NWARN,IODERR
        INTEGER NERROR,NWARN,IODERR
 
        SAVE /YPERRC/,/YCONTX/
 
        INTEGER STACK(STKSIZ),CUR,STATUS,TOS
 
        INTEGER ZRBINT,ZPUSH,ZPOP,YYPARS
        EXTERNAL ZRBINT,ZPUSH,ZPOP,YYPARS,ERROR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        IF (ZRBINT(STACK,STKSIZ,1).EQ.-1)
     +      CALL ERROR('Stack initialisation failed')
        IODERR=ERRFD
        CALL INILEX(INPFD,CMTFD,CIFD)
        NERROR=0
        NWARN=0
        PUNAMP=0
        STMTNO=1
 
        YPARSE=YYPARS()
 
        NERRS=NERROR
        NWARNS=NWARN
        IF (YPARSE.NE.0) RETURN
 
C Successful parse - insert the up-pointers into the tree
 
        STATUS=ZPUSH(ROOT,STACK)
        CUR=DOWN(ROOT)
        TOS=ROOT
C        CALL SETU(ROOT,ROOT) - assumes a currently zero up-pointer
        TREE(1,ROOT)=TREE(1,ROOT)+46340*ROOT
 
C We are at a node for the first time, so ...
C       If it is not a leaf, stack it and go via the DOWN pointer
C       (Note: negative DOWN pointers are symbol table pointers, NOT
C              actually DOWN pointers).
C 1000   CALL SETU(CUR,TOS)
 1000   TREE(1,CUR)=TREE(1,CUR)+46340*TOS
        IF (DOWN(CUR).GT.0) THEN
            STATUS=ZPUSH(CUR,STACK)
            TOS=CUR
            CUR=DOWN(CUR)
            GOTO 1000
        END IF
 
C No DOWN pointer, so check up on its NEXT pointer ...
C       If it has one, then push the UP pointer back onto the stack
C       (since we popped it during the output routine)
C       and go to the NEXT node
 1100   IF (NEXT(CUR).NE.0) THEN
            CUR=NEXT(CUR)
            GOTO 1000
        END IF
 
C End of the NEXT node chain at this level, so if we haven't finished,
C       return to the previous level, via the stack (UP pointer)
        IF (CUR.NE.ROOT) THEN
            STATUS=ZPOP(CUR,STACK)
            STATUS=ZPOP(TOS,STACK)
            STATUS=ZPUSH(TOS,STACK)
            GOTO 1100
        END IF
 
        END
C ----------------------------------------------------------------------
C
C       Y E R R O R   -   Report a parsing error
C
 
        SUBROUTINE YERROR(STRING)
        CHARACTER*(*) STRING
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C  TKLAST = LAST TOKEN NUMBER
C
      INTEGER TZEOF ,TASSIG,TBACKS,TBLOCK,TCALL ,TCLOSE,TCOMMO,TCONTI,
     +        TDATA ,TDO   ,TDIMEN,TELSE ,TELSIF,TEND  ,TENDFI,TENDIF,
     +        TENTRY,TEQUIV,TEXTER,TFUNCT,TFORMA,TGOTO ,TIF   ,TIMPLI,
     +        TINQUI,TINTRI,TOPEN ,TPARAM,TPAUSE,TPRINT,TPROGR,TREAD ,
     +        TRETUR,TREWIN,TSAVE ,TSTOP ,TSUBRO,TTHEN ,TTO   ,TWRITE,
     +        TINTEG,TREAL ,TDOUBL,TCOMPL,TLOGIC,TCHARA,TDCMPL,TCOMMA,
     +        TEQUAL,TCOLON,TLPARN,TRPARN,TLE   ,TLT   ,TEQ   ,TNE   ,
     +        TGE   ,TGT   ,TAND  ,TOR   ,TEQV  ,TNEQV ,TNOT  ,TSTAR ,
     +        TDSTAR,TPLUS ,TMINUS,TSLASH,TCNCAT,TDCNST,TLCNST,TRCNST,
     +        TPCNST,TCCNST,THCNST,TNAME ,TFIELD,TSCALE,TZEOS ,TCMMNT,
     +        TFMTKD,TENDKD,TERRKD,TKLAST
      PARAMETER (TZEOF = 1,TASSIG= 2,TBACKS= 3,TBLOCK= 4,TCALL = 5,
     +           TCLOSE= 6,TCOMMO= 7,TCONTI= 8,TDATA = 9,TDO   =10,
     +           TDIMEN=11,TELSE =12,TELSIF=13,TEND  =14,TENDFI=15,
     +           TENDIF=16,TENTRY=17,TEQUIV=18,TEXTER=19,TFUNCT=20,
     +           TFORMA=21,TGOTO =22,TIF   =23,TIMPLI=24,TINQUI=25,
     +           TINTRI=26,TOPEN =27,TPARAM=28,TPAUSE=29,TPRINT=30,
     +           TPROGR=31,TREAD =32,TRETUR=33,TREWIN=34,TSAVE =35,
     +           TSTOP =36,TSUBRO=37,TTHEN =38,TTO   =39,TWRITE=40,
     +           TINTEG=41,TREAL =42,TDOUBL=43,TCOMPL=44,TLOGIC=45,
     +           TCHARA=46,TDCMPL=47,TCOMMA=48,TEQUAL=49,TCOLON=50,
     +           TLPARN=51,TRPARN=52,TLE   =53,TLT   =54,TEQ   =55,
     +           TNE   =56,TGE   =57,TGT   =58,TAND  =59,TOR   =60,
     +           TEQV  =61,TNEQV =62,TNOT  =63,TSTAR =64,TDSTAR=65,
     +           TPLUS =66,TMINUS=67,TSLASH=68,TCNCAT=69,TDCNST=70,
     +           TLCNST=71,TRCNST=72,TPCNST=73,TCCNST=74,THCNST=75,
     +           TNAME =76,TFIELD=77,TSCALE=78,TZEOS =79,TCMMNT=80,
     +           TFMTKD=81,TENDKD=82,TERRKD=83,TKLAST=83)
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
 
        COMMON/TOKNCC/TOKTYP,TOKLEN,TOKTXT,TOKNUM
        INTEGER TOKTYP,TOKLEN,TOKTXT(1322),TOKNUM
 
        COMMON/YPERRC/NERROR,NWARN,IODERR
        INTEGER NERROR,NWARN,IODERR
 
        COMMON/YCONTX/PUNAMP,STMTNO
        INTEGER PUNAMP,STMTNO
 
        COMMON/YYCTX2/LASTYP,LASTXT,LASLEN
        INTEGER LASTYP,LASTXT,LASLEN
 
        SAVE /TOKNCC/,/YPERRC/,/YCONTX/,/YYCTX2/
 
        INTEGER TEXT(1322),SNUM
        LOGICAL ISWARN
 
        INTRINSIC LEN
 
        INTEGER ZTOKTX
        EXTERNAL ZTOKTX,ZCHOUT,PUTLIN,ZMESS,ZPTINT,PUTCH
 
        ISWARN=LEN(STRING).GT.10
        IF (TOKTYP.EQ.TZEOS) THEN
            SNUM=STMTNO-1
        ELSE
            SNUM=STMTNO
        END IF
        IF (ISWARN) ISWARN=STRING(:9).EQ.'Warning: '
        IF (.NOT.ISWARN) CALL ZCHOUT('Error: ',2)
        CALL ZCHOUT(STRING,2)
        IF (STMTNO.NE.0) THEN
            CALL ZCHOUT(' at statement ',2)
            CALL ZPTINT(SNUM,1,2)
        END IF
        IF (PUNAMP.NE.0) THEN
            CALL ZCHOUT(' in ',2)
            CALL PUTLIN(STRTXT(PUNAMP),2)
        ELSE IF (SNUM.NE.1) THEN
            CALL ZCHOUT(' in $MAIN',2)
        END IF
        CALL PUTCH(10,2)
        IF (IODERR.NE.-1) THEN
            IF (.NOT.ISWARN) CALL ZCHOUT('Error: ',IODERR)
            CALL ZCHOUT(STRING,IODERR)
            IF (STMTNO.NE.0) THEN
                CALL ZCHOUT(' at statement ',IODERR)
                CALL ZPTINT(SNUM,1,IODERR)
            END IF
            IF (PUNAMP.NE.0) THEN
                CALL ZCHOUT(' in ',IODERR)
                CALL PUTLIN(STRTXT(PUNAMP),IODERR)
            ELSE IF (SNUM.NE.1) THEN
                CALL ZCHOUT(' in $MAIN',IODERR)
            END IF
            CALL PUTCH(10,IODERR)
        END IF
        IF (STMTNO.NE.0) THEN
            IF (ISWARN) THEN
                CALL ZCHOUT('         ',2)
            ELSE
                CALL ZCHOUT('       ',2)
            END IF
            CALL ZCHOUT('detected at ',2)
            IF (LASTYP.EQ.0) THEN
                CALL ZMESS('beginning of file',2)
            ELSE
                IF (LASTYP.EQ.TZEOS) THEN
                    CALL ZCHOUT('<end-of-statement>',2)
                ELSE IF (LASTYP.EQ.TZEOF) THEN
                    CALL ZCHOUT('<end-of-file>',2)
                ELSEIF (ZTOKTX(LASTYP,LASLEN,STRTXT(LASTXT),TEXT).EQ.-2)
     +          THEN
                    CALL PUTLIN(TEXT,2)
                ELSE
                    CALL ZCHOUT('<illegal token>',2)
                END IF
                CALL ZCHOUT('@',2)
                IF (TOKTYP.EQ.TZEOS) THEN
                    CALL ZCHOUT('<end-of-statement>',2)
                ELSE IF (TOKTYP.EQ.TZEOF) THEN
                    CALL ZCHOUT('<end-of-file>',2)
                ELSE IF (ZTOKTX(TOKTYP,TOKLEN,TOKTXT,TEXT).EQ.-2) THEN
                    CALL PUTLIN(TEXT,2)
                ELSE
                    CALL ZCHOUT('<illegal token>',2)
                END IF
                CALL ZCHOUT(' (token numb'//'er ',2)
                CALL ZPTINT(TOKNUM,1,2)
                CALL ZMESS(')',2)
            END IF
        END IF
        IF (ISWARN) THEN
            NWARN=NWARN+1
        ELSE
            NERROR=NERROR+1
        END IF
 
        END
C ----------------------------------------------------------------------
C
C       E V A L I   -   Evaluate an integer constant
C
 
        INTEGER FUNCTION EVALI(NODE)
        INTEGER NODE
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
 
        INTEGER I
 
        INTEGER CTOI
        EXTERNAL CTOI
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        I=1
        EVALI=CTOI(STRTXT(-DOWN(NODE)),I)
        END
C ======================================================================
C
C       P A R T   T W O   -   S T R I N G   T A B L E
C
C ======================================================================
C
C ----------------------------------------------------------------------
C
C       I N I S T R   -   Initialise string table
C
 
        SUBROUTINE INISTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
 
        INTEGER I
 
        NSTRNG=0
        TXTTOP=1
        DO 100 I=1,7103
 100        STRTBL(I)=0
 
        END
C ----------------------------------------------------------------------
C
C       A D D S T R   -   Add a string to the string symbol table
C                         (This symbol table is entirely lexical)
C
 
C ********************                                        **********
C ******************** ALL MAINTAINERS/INSTALLERS PLEASE NOTE **********
C ********************                                        **********
C             \
C =============>      The macro "max_strings" *MUST* be prime
C             /       or the hash functions WILL NOT WORK!!!!
C
C                     The value should also be such that
C                     (R**K MOD max_strings) is NOT small (ie is large)
C                     for R=number of chars in char set, and
C                     K is a small integer (eg 1 to 12).
C
C                     The values listed in ypdefs are good ones.
C
 
        INTEGER FUNCTION ADDSTR(STRING)
        INTEGER STRING(*)
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
 
        INTEGER HASHV,INCR,L
 
        INTRINSIC MOD
 
        INTEGER HASHF,EQUAL,HASH2,LENGTH
        EXTERNAL HASHF,EQUAL,HASH2,LENGTH,ERROR,SCOPY
 
        L=LENGTH(STRING)
        HASHV=HASHF(STRING,L)
        INCR=0
C "+1" to include the eos at the end.
        L=L+1
        IF (L+TXTTOP+1.GT.46339)
     +      CALL ERROR('String storage area overflowed')
 
 100    IF (STRTBL(HASHV).EQ.0) THEN
            IF (NSTRNG.EQ.7103)
     +          CALL ERROR('String symbol table overflowed')
            CALL SCOPY(STRING,1,STRTXT,TXTTOP)
            STRTBL(HASHV)=TXTTOP
            ADDSTR=TXTTOP
            TXTTOP=TXTTOP+L
            NSTRNG=NSTRNG+1
        ELSE IF (EQUAL(STRTXT(STRTBL(HASHV)),STRING).EQ.-2) THEN
            ADDSTR=STRTBL(HASHV)
        ELSE
            IF (INCR.EQ.0) INCR=HASH2(STRING,L)
            HASHV=MOD(HASHV+INCR,7103)+1
            GOTO 100
        END IF
        END
C ----------------------------------------------------------------------
C
C       H A S H F   -   Hash function for IST strings in XCSTRI
C
 
        INTEGER FUNCTION HASHF(STRING,LENGTH)
        INTEGER STRING(*),LENGTH
 
        INTEGER L,I,V1,V2
 
        INTRINSIC MIN,MOD
 
        V1=0
        V2=0
        DO 100 I=1,MIN(LENGTH,12)
            IF (MOD(I,4).EQ.0) THEN
                V1=MOD(V1+V2,2**30)
                V2=0
            END IF
 100    V2=128*V2+STRING(I)
        HASHF=MOD(V1+V2,7103)+1
 
        END
C ----------------------------------------------------------------------
C
C       H A S H 2   -   Second hash function for "double hashing"
C                       Algorithm
C
 
        INTEGER FUNCTION HASH2(STRING,LENGTH)
        INTEGER STRING(*),LENGTH
 
        INTEGER L,I,V1,V2
 
        INTRINSIC MIN,MOD
 
        V1=0
        V2=0
        DO 100 I=1,MIN(LENGTH,12)
            IF (MOD(I,4).EQ.0) THEN
                V1=MOD(V1+V2,2**30)
                V2=0
            END IF
 100    V2=128*V2+STRING(I)
        HASH2=MOD(V1+V2,7103-2)+1
 
        END
C ======================================================================
C
C       P A R T     T H R E E   -   P A R S E   T R E E
C
C ======================================================================
C
C ----------------------------------------------------------------------
C
C       I N I T R E   -   Initialise parse tree
C
 
        SUBROUTINE INITRE
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
 
        TRETOP=0
 
        END
C ----------------------------------------------------------------------
C
C       C R N O D E   -   Create a new node in the parse tree
C
 
C
C Note: when a new node is created, it is back-linked to itself so that
C       our list procedures know what is going on.
C
 
        INTEGER FUNCTION CRNODE(TYPE,SON)
        INTEGER TYPE,SON
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
 
        EXTERNAL ERROR
 
        IF (TRETOP.EQ.46339) CALL ERROR('Parse tree overflowed')
        TRETOP=TRETOP+1
        TREE(1,TRETOP)=TYPE
C CALL SETD(TRETOP,SON)
        TREE(2,TRETOP)=SON
C CALL SETN(TRETOP,0); CALL SETP(TRETOP,TRETOP)
        TREE(3,TRETOP)=TRETOP*46340
C set NATTR(TRETOP) to zero (no attributes)
        TREE(4,TRETOP)=0
        CRNODE=TRETOP
 
        END
C ----------------------------------------------------------------------
C
C       NEXT, PREV, UP, DOWN   --   Access Functions for parse tree
C                                   (encoded as statement functions)
C
C       SETN, SETP, SETU, SETD  -   Access Routines for parse tree
C
C       Note: Not all parse tree node modification occurs via the access
C             functions - the access functions are there mainly for the
C             use of YYPARS (which is generated from F.GRAMMAR and we
C             therefore want it to be maximally readable) - other
C             routines in YYLIB (e.g. CRNODE) may do direct modification
C
        SUBROUTINE SETN(NODE,NEXTN)
        INTEGER NODE,NEXTN
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
 
        TREE(3,NODE)=46340*(TREE(3,NODE)/46340)+NEXTN
        END
        SUBROUTINE SETP(NODE,PREVN)
        INTEGER NODE,PREVN
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
 
        TREE(3,NODE)=MOD(TREE(3,NODE),46340)+PREVN*46340
        END
        SUBROUTINE SETU(NODE,UPN)
        INTEGER NODE,UPN
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
 
        TREE(1,NODE)=MOD(TREE(1,NODE),46340)+46340*UPN
        END
        SUBROUTINE SETD(NODE,DOWNN)
        INTEGER NODE,DOWNN
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
 
        TREE(2,NODE)=DOWNN
        END
C ----------------------------------------------------------------------
C
C       A D D S O N   -   Add a son to the head of the son list
C
 
        INTEGER FUNCTION ADDSON(NODE,SON)
        INTEGER NODE,SON
 
        INTEGER FIRSON
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        FIRSON=DOWN(NODE)
        IF (FIRSON.NE.0) THEN
C            CALL SETP(SON,PREV(FIRSON))
            TREE(3,SON)=MOD(TREE(3,SON),46340)+PREV(FIRSON)*46340
C            CALL SETN(SON,FIRSON)
            TREE(3,SON)=46340*(TREE(3,SON)/46340)+FIRSON
C            CALL SETP(FIRSON,SON)
            TREE(3,FIRSON)=MOD(TREE(3,FIRSON),46340)+SON*46340
        END IF
C        CALL SETD(NODE,SON)
        TREE(2,NODE)=SON
        ADDSON=NODE
 
        END
C ----------------------------------------------------------------------
C
C       A P P S O N   -   Append a son to the end of the son list
C
 
        INTEGER FUNCTION APPSON(NODE,SON)
        INTEGER NODE,SON
 
        INTEGER LAST,FIRST
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        FIRST=DOWN(NODE)
        IF (FIRST.EQ.0) THEN
C            CALL SETD(NODE,SON)
            TREE(2,NODE)=SON
        ELSE
            LAST=PREV(FIRST)
C            CALL SETP(SON,LAST)
            TREE(3,SON)=MOD(TREE(3,SON),46340)+LAST*46340
C            CALL SETN(LAST,SON)
            TREE(3,LAST)=46340*(TREE(3,LAST)/46340)+SON
C            CALL SETP(FIRST,SON)
            TREE(3,FIRST)=MOD(TREE(3,FIRST),46340)+SON*46340
        END IF
        APPSON=NODE
 
        END
C ----------------------------------------------------------------------
C
C       A N O T H R   -   Add a list to the end of a node
C
 
        INTEGER FUNCTION ANOTHR(NODE,LIST)
        INTEGER NODE,LIST
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
C        CALL SETP(NODE,PREV(LIST))
        TREE(3,NODE)=MOD(TREE(3,NODE),46340)+PREV(LIST)*46340
C        CALL SETN(NODE,LIST)
        TREE(3,NODE)=46340*(TREE(3,NODE)/46340)+LIST
C        CALL SETP(LIST,NODE)
        TREE(3,LIST)=MOD(TREE(3,LIST),46340)+NODE*46340
        ANOTHR=NODE
 
        END
C ----------------------------------------------------------------------
C
C       A P P E N D   -   Append a node to the end of a list
C
 
        INTEGER FUNCTION APPEND(LIST,NODE)
        INTEGER LIST,NODE
 
        INTEGER LAST
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        LAST=PREV(LIST)
C        CALL SETP(NODE,LAST)
        TREE(3,NODE)=MOD(TREE(3,NODE),46340)+LAST*46340
C        CALL SETN(LAST,NODE)
        TREE(3,LAST)=46340*(TREE(3,LAST)/46340)+NODE
C        CALL SETP(LIST,NODE)
        TREE(3,LIST)=MOD(TREE(3,LIST),46340)+NODE*46340
        APPEND=LIST
 
        END
C ======================================================================
C
C       P A R T     F O U R   -   S Y M B O L   T A B L E
C
C ======================================================================
C
C ----------------------------------------------------------------------
C
C       I N I S Y M   -   Initialise symbol table
C
 
        SUBROUTINE INISYM
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
 
        NSYMS=0
        NPUS=0
        MODFLG=.FALSE.
 
        END
C ----------------------------------------------------------------------
C
C       A D D S Y M   -   Add a symbol to the table
C
C                         Takes as arguments the leaf node pointing to
C                         string definition of the symbol and the type
C                         of the symbol, and returns the leaf node,
C                         having replaced the string pointer with the
C                         symbol table pointer, possibly inserting the
C                         symbol into the table or giving an error msg
C                         if it is incompatible with an earlier entry.
C
C                         Most of this is done by the NEWSYM routine at a
C                         lower level.
C
 
        INTEGER FUNCTION ADDSYM(LEAF,SYMTYP)
        INTEGER LEAF,SYMTYP
 
        INTEGER NEWSYM
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
C        CALL SETD(LEAF,-NEWSYM(-DOWN(LEAF),SYMTYP))
        TREE(2,LEAF)=-NEWSYM(-DOWN(LEAF),SYMTYP)
        ADDSYM=LEAF
 
        END
C ----------------------------------------------------------------------
C
C       S P E S Y M   -   This routine adds a special symbol.
C                         This is an unnamed main program or common or
C                         block data, and can only be accessed by
C                         stepping sequentially through the table.
C
 
        INTEGER FUNCTION SPESYM(CHRSTR,SYMTYP)
        CHARACTER*(*) CHRSTR
        INTEGER SYMTYP
 
        INTEGER TEXT(134),I,CLEN
 
        INTRINSIC LEN
 
        INTEGER NEWSYM,ADDSTR,ZCCTOI
        EXTERNAL ZCCTOI
 
        CLEN=LEN(CHRSTR)
        DO 100 I=1,CLEN
 100        TEXT(I)=ZCCTOI(CHRSTR(I:I),TEXT(I))
        TEXT(CLEN+1)=129
        SPESYM=NEWSYM(ADDSTR(TEXT),SYMTYP)
 
        END
C ----------------------------------------------------------------------
C
C       N E W S Y M   -   Add (maybe) a new symbol
C                         (return pointer to old symbol if any)
C                         This does things without leaves.
C
 
        INTEGER FUNCTION NEWSYM(STRPTR,SYMTYP)
        INTEGER SYMTYP,STRPTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
 
        COMMON/PUNUMB/PUN
        INTEGER PUN
 
        COMMON/YCONTX/PUNAMP,STMTNO
        INTEGER PUNAMP,STMTNO
 
        INTEGER I,HASHTB(5003),STEPV
        LOGICAL CBLK,NOTFND
 
        SAVE /PUNUMB/,/YCONTX/,HASHTB
 
        EXTERNAL ERROR
 
        IF (NSYMS.EQ.0) THEN
            DO 100 I=1,5003
                HASHTB(I)=0
 100        CONTINUE
        ELSE IF (NSYMS.EQ.5003) THEN
            CALL ERROR('Symbol table overflowed')
        END IF
 
        CBLK=SYMTYP.EQ.2
        NOTFND=.TRUE.
        NEWSYM=MOD((STRPTR+501)*(PUN+100),5003)+1
        STEPV=0
 
 200    IF (HASHTB(NEWSYM).NE.0) THEN
            IF (SYMBOL(2,HASHTB(NEWSYM)).EQ.STRPTR .AND.
     +          SYMBOL(3,HASHTB(NEWSYM)).EQ.PUN) THEN
                IF (CBLK .AND.
     +                  SYMBOL(1,HASHTB(NEWSYM)).EQ.2
     +          .OR. .NOT.CBLK .AND.
     +                  SYMBOL(1,HASHTB(NEWSYM)).NE.2)
     +          THEN
                    NOTFND=.FALSE.
                ELSE
                    IF (STEPV.EQ.0)
     +                  STEPV=MOD((STRPTR+10)*PUN,5003-2)+1
                    NEWSYM=MOD(NEWSYM+STEPV,5003)+1
                END IF
            ELSE
                IF (STEPV.EQ.0)
     +              STEPV=MOD((STRPTR+10)*PUN,5003-2)+1
                NEWSYM=MOD(NEWSYM+STEPV,5003)+1
            END IF
            IF (NOTFND) GOTO 200
        END IF
 
        IF (NOTFND) THEN
            IF (NSYMS.EQ.5003)
     +          CALL ERROR('Symbol table overflowed')
            NSYMS=NSYMS+1
            SYMBOL(1,NSYMS)=SYMTYP
            SYMBOL(2,NSYMS)=STRPTR
            SYMBOL(3,NSYMS)=PUN
            DO 300 I=4,8
 300            SYMBOL(I,NSYMS)=0
            HASHTB(NEWSYM)=NSYMS
            NEWSYM=NSYMS
            IF (PUN.GT.NPUS) THEN
                NPUS=PUN
                PUIDX(MIN(250,NPUS))=NSYMS
            END IF
        ELSE
            NEWSYM=HASHTB(NEWSYM)
            IF (SYMTYP.NE.3 .AND.
     +          SYMBOL(1,NEWSYM).NE.SYMTYP)
     +          CALL SYMERR('Inconsistent symbol types',NEWSYM)
        END IF
        IF (SYMTYP.EQ.4) PUNAMP=SYMBOL(2,NEWSYM)
 
        END
C ----------------------------------------------------------------------
C
C       S E T T Y P   -   Set (change) type of symbol
C
C       This specifies the exact type of a symbol.  An error message is
C       produced if the previous type is not equal to either the unknown
C       type "S_NAME" or the requested type.
C
 
        SUBROUTINE SETTYP(LEAF,SYMTYP)
        INTEGER LEAF,SYMTYP
 
        INTEGER SYMPTR
 
        COMMON/YCONTX/PUNAMP,STMTNO
        INTEGER PUNAMP,STMTNO
 
        SAVE /YCONTX/
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SYMPTR=-DOWN(LEAF)
        IF (SYMBOL(1,SYMPTR).NE.3 .AND.
     +      SYMBOL(1,SYMPTR).NE.SYMTYP .AND.
     +     (SYMBOL(1,SYMPTR).NE.4 .AND.
     +      SYMBOL(1,SYMPTR).NE.9 .OR. SYMTYP.NE.5))
     +          CALL SYMERR('Inconsistent symbol usage',SYMPTR)
        IF (SYMBOL(1,SYMPTR).NE.4 .AND.
     +      SYMBOL(1,SYMPTR).NE.9)
     +      SYMBOL(1,SYMPTR)=SYMTYP
        IF (SYMTYP.EQ.4) PUNAMP=SYMBOL(2,SYMPTR)
 
        END
C ----------------------------------------------------------------------
C
C       C H K A T T   -   Check attribute of symbol (set it if zero)
C                         (Error message if attribute has different val)
C
 
        SUBROUTINE CHKATT(LEAF,ATTNUM,VALUE)
        INTEGER LEAF,ATTNUM,VALUE
 
        INTEGER SYMPTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SYMPTR=-DOWN(LEAF)
        IF (SYMBOL(ATTNUM,SYMPTR).NE.0 .AND.
     +      SYMBOL(ATTNUM,SYMPTR).NE.VALUE)
     +      CALL SYMERR('Inconsistent symbol usage',SYMPTR)
        SYMBOL(ATTNUM,SYMPTR)=VALUE
 
        END
C ----------------------------------------------------------------------
C
C       S E T A T T   -   Set attribute of symbol
C                         (Error message if attribute already set)
C
 
        SUBROUTINE SETATT(LEAF,ATTNUM,VALUE)
        INTEGER LEAF,ATTNUM,VALUE
 
        INTEGER SYMPTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SYMPTR=-DOWN(LEAF)
        IF (SYMBOL(1,SYMPTR).EQ.1 .AND.
     +      ATTNUM.EQ.4 .AND. SYMBOL(ATTNUM,SYMPTR).EQ.-1)
     +      SYMBOL(ATTNUM,SYMPTR)=0
        IF (SYMBOL(ATTNUM,SYMPTR).NE.0)
     +      CALL SYMERR('Duplicate symbol usage',SYMPTR)
        SYMBOL(ATTNUM,SYMPTR)=VALUE
 
        END
C ----------------------------------------------------------------------
C
C       I N C A T T   -   Increment attribute of symbol (for a counter)
C                         (No checking, no error messages)
C
 
        SUBROUTINE INCATT(LEAF,ATTNUM)
        INTEGER LEAF,ATTNUM
 
        INTEGER SYMPTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SYMPTR=-DOWN(LEAF)
        SYMBOL(ATTNUM,SYMPTR)=SYMBOL(ATTNUM,SYMPTR)+1
 
        END
C ----------------------------------------------------------------------
C
C       A D D A T T   -   Add to attribute
C
 
        SUBROUTINE ADDATT(LEAF,ATTNUM,ADDVAL)
        INTEGER LEAF,ATTNUM,ADDVAL
 
        INTEGER SYMPTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SYMPTR=-DOWN(LEAF)
        SYMBOL(ATTNUM,SYMPTR)=SYMBOL(ATTNUM,SYMPTR)+ADDVAL
 
        END
C ----------------------------------------------------------------------
C
C       S E T A B   -   Set Attribute Bits
C                       Does an inclusive OR of the current setting and
C                       the value passed in.
C
 
        SUBROUTINE SETAB(LEAF,ATTNUM,BITS)
        INTEGER LEAF,ATTNUM,BITS
 
        INTEGER SYMPTR
 
        INTEGER ZIOR
        EXTERNAL ZIOR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SYMPTR=-DOWN(LEAF)
        SYMBOL(ATTNUM,SYMPTR)=ZIOR(SYMBOL(ATTNUM,SYMPTR),BITS)
 
        END
C ----------------------------------------------------------------------
C
C       S E T A B C   -   Set Attribute Bits with Check
C                         Same as SETAB with a checking facility added.
C
 
        SUBROUTINE SETABC(LEAF,ATTNUM,BITS,CHECK)
        INTEGER LEAF,ATTNUM,BITS,CHECK
 
        INTEGER SYMPTR
 
        INTEGER ZIOR,ZIAND
        EXTERNAL ZIOR,ZIAND
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SYMPTR=-DOWN(LEAF)
        IF (ZIAND(SYMBOL(ATTNUM,SYMPTR),CHECK).NE.0) THEN
            IF (ZIAND(SYMBOL(ATTNUM,SYMPTR),BITS).NE.0) THEN
                CALL SYMERR('Symbol declared twice',SYMPTR)
            ELSE
                CALL SYMERR('Inconsistent symbol declarations',SYMPTR)
            END IF
        END IF
        SYMBOL(ATTNUM,SYMPTR)=ZIOR(SYMBOL(ATTNUM,SYMPTR),BITS)
 
        END
C ----------------------------------------------------------------------
C
C       O P T A T T   -   Optionally set attribute of a symbol
C                         --Only sets attribute if currently zero
C
 
        SUBROUTINE OPTATT(SYMNUM,ATTNUM,VALUE)
        INTEGER SYMNUM,ATTNUM,VALUE
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
 
        IF (SYMBOL(ATTNUM,SYMNUM).EQ.0) SYMBOL(ATTNUM,SYMNUM)=VALUE
 
        END
C ----------------------------------------------------------------------
C
C       O V R A T T   -   Set attribute, overriding any current value
C
 
        SUBROUTINE OVRATT(LEAF,ATTNUM,VALUE)
 
        INTEGER LEAF,ATTNUM,VALUE
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SYMBOL(ATTNUM,-DOWN(LEAF))=VALUE
 
        END
C ----------------------------------------------------------------------
C
C       S E T S F P   -   Go through an argument list setting the
C                         attribute "stmt_fn_para".
C
 
        SUBROUTINE SETSFP(ARGLST)
        INTEGER ARGLST
 
        INTEGER POINTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        POINTR=ARGLST
 100    IF (NTYPE(POINTR).NE.108) THEN
            CALL YERROR('Invalid stmt function dummy argument')
        ELSE
            CALL SETAB(POINTR,6,256)
            POINTR=NEXT(POINTR)
            IF (POINTR.NE.0) GOTO 100
        END IF
 
        END
C ----------------------------------------------------------------------
C
C       S E T A R G   -   Go through an argument list setting the
C                         attribute "used_as_arg" (where appropriate).
C
 
        SUBROUTINE SETARG(ARGLST)
        INTEGER ARGLST
 
        INTEGER POINTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        POINTR=ARGLST
 100    IF (NTYPE(POINTR).EQ.108)
     +      CALL SETAB(POINTR,6,2048)
        POINTR=NEXT(POINTR)
        IF (POINTR.NE.0) GOTO 100
 
        END
C ----------------------------------------------------------------------
C
C       B E G P U   -   Beginning of program-unit processing
C
 
        SUBROUTINE BEGPU
 
        COMMON/IMPTPC/ITYPE,ICHLEN,ISET
        INTEGER ITYPE(65:90),ICHLEN(65:90)
        LOGICAL ISET(65:90)
 
        COMMON/YCONTX/PUNAMP,STMTNO
        INTEGER PUNAMP,STMTNO
 
        SAVE /IMPTPC/,/YCONTX/
 
        INTEGER I
 
        DO 100 I=65,90
            ITYPE(I)=2
            ISET(I)=.FALSE.
 100        ICHLEN(I)=0
        DO 200 I=73,78
 200        ITYPE(I)=1
        PUNAMP=0
        STMTNO=1
 
        END
C ----------------------------------------------------------------------
C
C       I M P T Y P   -   Implicit typing declaration
C
 
        SUBROUTINE IMPTYP(TYPNOD,CRNODE)
        INTEGER TYPNOD,CRNODE
 
        COMMON/IMPTPC/ITYPE,ICHLEN,ISET
        INTEGER ITYPE(65:90),ICHLEN(65:90)
        LOGICAL ISET(65:90)
 
        COMMON/YCONTX/PUNAMP,STMTNO
        INTEGER PUNAMP,STMTNO
 
        SAVE /IMPTPC/,/YCONTX/
 
        INTEGER PTR,TYPE,CHLEN,CH1,CH2,I
        CHARACTER C
 
        CHARACTER ZCITOC
        EXTERNAL ZCITOC
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        STMTNO=0
        CALL TYPER(TYPNOD,TYPE,CHLEN)
        PTR=CRNODE
 100    IF (PTR.NE.0) THEN
            CALL CHRRNG(PTR,CH1,CH2)
            DO 200 I=CH1,CH2
                IF (ISET(I)) THEN
                    C=ZCITOC(I,C)
                    CALL YERROR('Multiple IMPLICIT for '//C)
                END IF
                ISET(I)=.TRUE.
                ITYPE(I)=TYPE
 200            ICHLEN(I)=CHLEN
            PTR=NEXT(PTR)
            GOTO 100
        END IF
 
        END
C ----------------------------------------------------------------------
C
C       T Y P E R   -   Return the type-value for a datatype declaration
C
 
        SUBROUTINE TYPER(NODE,TYPE,CHRLEN)
        INTEGER NODE,TYPE,CHRLEN
 
        INTEGER NTYP
 
        INTEGER EVALI
 
        EXTERNAL ERROR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        NTYP=NTYPE(NODE)
        IF (NTYP.EQ.9) THEN
            TYPE=1
        ELSE IF (NTYP.EQ.10) THEN
            TYPE=2
        ELSE IF (NTYP.EQ.11) THEN
            TYPE=5
        ELSE IF (NTYP.EQ.12) THEN
            TYPE=4
        ELSE IF (NTYP.EQ.13) THEN
            TYPE=3
        ELSE IF (NTYP.EQ.14) THEN
            TYPE=6
        ELSE IF (NTYP.EQ.125) THEN
            TYPE=7
        ELSE
            CALL ERROR('Incorrect N_T'//'YPE node')
        END IF
        CHRLEN=DOWN(NODE)
        IF (CHRLEN.GT.0) THEN
            IF (NTYPE(CHRLEN).EQ.107) THEN
                CHRLEN=EVALI(CHRLEN)
            ELSE
                CHRLEN=-CHRLEN
            END IF
        END IF
 
        END
C ----------------------------------------------------------------------
C
C       C H R R N G   -   Return character range for an IMPLICIT decl.
C
 
        SUBROUTINE CHRRNG(NODE,CHR1,CHR2)
        INTEGER NODE,CHR1,CHR2
 
        INTEGER P
 
        INTEGER IMPCHR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        P=DOWN(NODE)
        CHR1=IMPCHR(P)
        P=NEXT(P)
        IF (P.EQ.0) THEN
            CHR2=CHR1
        ELSE
            CHR2=IMPCHR(P)
        ENDIF
        END
C ----------------------------------------------------------------------
C
C       I M P C H R   -   Return a character for part of an IMPLICIT rng
C
 
        INTEGER FUNCTION IMPCHR(NODE)
        INTEGER NODE
 
        INTEGER ZUPPER,LENGTH
        EXTERNAL ZUPPER,LENGTH,ERROR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        IF (NTYPE(NODE).NE.120)
     +     CALL ERROR('Internal Error (IMPCHR): Not an IMPCHAR node')
 
        IF (LENGTH(STRTXT(-DOWN(NODE))).NE.1)
     +      CALL SYMERR('Illegal IMPLICIT character length',-DOWN(NODE))
 
        IMPCHR=ZUPPER(STRTXT(-DOWN(NODE)))
        IF (IMPCHR.LT.65 .OR. IMPCHR.GT.90)
     +      CALL SYMERR('Illegal IMPLICIT character',-DOWN(NODE))
 
        END
C ----------------------------------------------------------------------
C
C       S E T I M P   -   Set implicit types of names
C
 
        SUBROUTINE SETIMP(PUN)
        INTEGER PUN
 
        COMMON/IMPTPC/ITYPE,ICHLEN,ISET
        INTEGER ITYPE(65:90),ICHLEN(65:90)
        LOGICAL ISET(65:90)
 
        COMMON/YCONTX/PUNAMP,STMTNO
        INTEGER PUNAMP,STMTNO
 
        SAVE /IMPTPC/,/YCONTX/
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
 
        LOGICAL IMPL
        INTEGER SYMPTR,ICH,PUDTYP
 
        LOGICAL CHKINT
 
        INTEGER ZIAND,ZUPPER,ZIOR,ZYGPUS
        EXTERNAL ZIAND,ZUPPER,ZIOR,ZYGPUS
 
        SYMPTR=0
        PUDTYP=0
        STMTNO=0
 
 100    SYMPTR=SYMPTR+1
        IF (SYMPTR.LT.NSYMS .AND.
     +      SYMBOL(3,SYMPTR).LT.PUN) GOTO 100
        IF (SYMBOL(3,SYMPTR).NE.PUN) RETURN
 
 200    IF (SYMBOL(1,SYMPTR).NE.1 .AND.
     +      SYMBOL(1,SYMPTR).NE.2 .AND.
     +      SYMBOL(4,SYMPTR).EQ.0) THEN
            IMPL=SYMBOL(1,SYMPTR).NE.7
            IF (.NOT.IMPL) THEN
 
C Symbol is some sort of routine -- enter big mess of tests....
                IMPL=ZIAND(SYMBOL(6,SYMPTR),1).NE.0
                IF (.NOT.IMPL) THEN
C Not declared EXTERNAL - check to see if it is an intrinsic
                    IF (CHKINT(SYMPTR)) THEN
C Yes - standard intrinsic
                        SYMBOL(6,SYMPTR)=
     +                      ZIOR(SYMBOL(6,SYMPTR),4096)
                        IMPL=.FALSE.
 
                    ELSE IF (ZIAND(SYMBOL(6,SYMPTR),2)
     +                       .NE.0) THEN
C No but declared as such: a non-standard intrinsic of unknown type
C ---so implicitly type it
                        CALL SYMWRN(
     +'Implicit type for non-standard intrinsic',SYMPTR)
                        IMPL=.TRUE.
 
C Not declared as intrinsic or external: can only be a proc if called
C as a function then, so implicitly type it (silently).
                    ELSE
                        IMPL=.TRUE.
                    END IF
 
                ELSE
C Declared as external: implicitly type it only if used as a function
                    IMPL=ZIAND(SYMBOL(6,SYMPTR),8192).NE.0
 
                    IF (.NOT. IMPL) THEN
C Declared external but not called as either subroutine or function:
C --- say that it is a subroutine
                        IMPL=.FALSE.
                        SYMBOL(4,SYMPTR)=-1
 
C   If it has been used as an actual parameter, or if it is a formal
C   parameter, say we are unsure about it
                        IF (ZIAND(SYMBOL(6,SYMPTR),4+
     +                      2048).NE.0) THEN
                            CALL SYMWRN(
     +'I assume this is a subroutine',SYMPTR)
 
                        ELSE
C   Not used as anything legal ever!  Better tell the user...
C   (and make it a subroutine).
                            CALL SYMWRN('Unused external reference',
     +                                  SYMPTR)
                        END IF
                    END IF
                END IF
            ELSE IF (SYMBOL(1,SYMPTR).EQ.9 .AND.
     +               PUDTYP.EQ.-1) THEN
                SYMBOL(4,SYMPTR)=-1
                IMPL=.FALSE.
            END IF
            IF (IMPL) THEN
                ICH=ZUPPER(STRTXT(SYMBOL(2,SYMPTR)))
                IF (ICH.LT.65 .OR. ICH.GT.90)
     +              CALL SYMERR('Illegal symbol',SYMPTR)
                SYMBOL(4,SYMPTR)=ITYPE(ICH)
                SYMBOL(5,SYMPTR)=ICHLEN(ICH)
            END IF
 
        ELSE IF (SYMBOL(1,SYMPTR).EQ.7) THEN
            IF (ZIAND(SYMBOL(6,SYMPTR),1).EQ.0) THEN
                IF (CHKINT(SYMPTR))
     +              SYMBOL(6,SYMPTR)=
     +                  ZIOR(SYMBOL(6,SYMPTR),4096)
            END IF
        ELSE IF (SYMBOL(1,SYMPTR).EQ.4) THEN
            PUDTYP=SYMBOL(4,SYMPTR)
        ELSE IF (SYMBOL(1,SYMPTR).EQ.9 .AND.
     +           SYMBOL(4,SYMPTR).GT.0 .AND.
     +           PUDTYP.EQ.-1) THEN
            CALL SYMERR('Subroutine ENTRY points cannot be typed',
     +                  SYMPTR)
        END IF
        IF (SYMPTR.LT.NSYMS) THEN
            SYMPTR=SYMPTR+1
            IF (SYMBOL(3,SYMPTR).EQ.PUN) GOTO 200
        END IF
 
        END
C ----------------------------------------------------------------------
C
C       C H K I N T   -   Check to see if a function is an intrinsic
C
 
        LOGICAL FUNCTION CHKINT(SYMPTR)
        INTEGER SYMPTR
 
        INTEGER NFUNS
        PARAMETER (NFUNS=89)
 
        INTEGER TEXT(134),SYMLEN,L,R,I,INTTYP(NFUNS)
        CHARACTER*6 SYMNAM,INTNAM(NFUNS)
 
        SAVE INTTYP,INTNAM
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
 
        INTRINSIC LLT
 
        INTEGER LENGTH
        EXTERNAL ZITOF,LENGTH,ZTOCAP,SCOPY,ERROR
 
        DATA (INTNAM(I),INTTYP(I),I=1,57)/
     +'ABS',8,'ACOS',8,'AIMAG',2,
     +'AINT',8,'ALOG',2,'ALOG10',2,
     +'AMAX0',2,'AMAX1',2,'AMIN0',2,
     +'AMIN1',2,'AMOD',2,'ANINT',8,
     +'ASIN',8,'ATAN',8,'ATAN2',8,
     +'CABS',2,'CCOS',4,'CDABS',5,
     +'CEXP',4,'CHAR',6,'CLOG',4,
     +'CMPLX',4,'CONJG',4,'COS',8,
     +'COSH',8,'CSIN',4,'CSQRT',4,
     +'DABS',5,'DACOS',5,'DASIN',5,
     +'DATAN',5,'DATAN2',5,'DBLE',5,
     +'DCMPLX',7,'DCONJG',7,'DCOS',5,
     +'DCOSH',5,'DDIM',5,'DEXP',5,
     +'DIM',8,'DIMAG',5,'DINT',5,
     +'DLOG',5,'DLOG10',5,'DMAX1',5,
     +'DMIN1',5,'DMOD',5,'DNINT',5,
     +'DPROD',5,'DSIGN',5,'DSIN',5,
     +'DSINH',5,'DSQRT',5,'DTAN',5,
     +'DTANH',5,'EXP',8,'FLOAT',2/
        DATA (INTNAM(I),INTTYP(I),I=58,NFUNS)/
     +'IABS',1,'ICHAR',1,'IDIM',1,
     +'IDINT',1,'IDNINT',1,'IFIX',1,
     +'INDEX',1,'INT',1,'ISIGN',1,
     +'LEN',1,'LGE',3,'LGT',3,
     +'LLE',3,'LLT',3,'LOG',8,
     +'LOG10',8,'MAX',8,'MAX0',1,
     +'MAX1',1,'MIN',8,'MIN0',1,
     +'MIN1',1,'MOD',8,'NINT',1,
     +'REAL',2,'SIGN',8,'SIN',8,
     +'SINH',8,'SNGL',2,'SQRT',8,
     +'TAN',8,'TANH',8/
 
        CHKINT=.FALSE.
        CALL SCOPY(STRTXT,SYMBOL(2,SYMPTR),TEXT,1)
        SYMLEN=LENGTH(TEXT)
        IF (SYMLEN.LT.1) THEN
            CALL ERROR('CHKINT:INTERNAL ERROR: Illegal symbol length')
            RETURN
        END IF
        IF (SYMLEN.GT.6) RETURN
        CALL ZTOCAP(TEXT)
        CALL ZITOF(TEXT,1,6,SYMNAM,.FALSE.)
        L=1
        R=NFUNS
 
 100    I=(L+R)/2
        IF (LLT(SYMNAM,INTNAM(I))) THEN
            R=I-1
        ELSE IF (SYMNAM.EQ.INTNAM(I)) THEN
            L=R+1
        ELSE
            L=I+1
        END IF
        IF (L.LE.R) GOTO 100
C
        IF (SYMNAM.EQ.INTNAM(I)) THEN
            IF (SYMBOL(4,SYMPTR).EQ.0) THEN
                SYMBOL(4,SYMPTR)=INTTYP(I)
            ELSE IF (SYMBOL(4,SYMPTR).EQ.INTTYP(I)) THEN
                CALL SYMWRN('Intrinsic function explicitly typed',
     +                      SYMPTR)
            ELSE IF (INTTYP(I).EQ.8) THEN
                CALL SYMWRN('Generic intrinsic explicitly typed',
     +                      SYMPTR)
            ELSE
                CALL SYMWRN('Intrinsic declared with wrong type',
     +                      SYMPTR)
            END IF
            CHKINT=.TRUE.
        END IF
 
        END
C ----------------------------------------------------------------------
C
C       S Y M T Y P   -   Return symbol type
C
 
        INTEGER FUNCTION SYMTYP(SYMPTR)
        INTEGER SYMPTR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
 
        SYMTYP=SYMBOL(1,SYMPTR)
        END
C ======================================================================
C
C       STACK HANDLER FOR DO-LOOPS AND BLOCK-IFS.
C
C       STACK FORMAT:
C           STACK(1,*)=DEFINING NODE NUMBER (SCOPE)
C           STACK(2,*)=LABEL SYMPTR (DO LOOP) OR ZERO (BLOCK-IF)
C           STACK(3,*)=-INDEX SYMPTR (DO LOOP)
C                      OR (BLOCK-IF) 0 = IN IF-THEN/ELSE-IF PART
C                                    1 = IN ELSE PART
C
 
C
C       I N I S T K   -   Initialise Stack Handler
C
        SUBROUTINE INISTK
 
        INTEGER NODE,PTR,LBLPTR,STACK(3,0:199),SP,I,J,SYMPTR
 
        COMMON/YCONTX/PUNAMP,STMTNO
        INTEGER PUNAMP,STMTNO
 
        SAVE /YCONTX/,STACK,SP
 
        EXTERNAL ERROR
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C
C Common block and access functions for YP parse tree
C
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCTREE/ROOT,TREE,TRETOP
        INTEGER ROOT,TREE(4,46339),TRETOP
 
        SAVE /XCTREE/
C Use "JABC12" to try to avoid conflicts with ordinary variables
        INTEGER NEXT,PREV,UP,DOWN,NATTR,NTYPE,JABC12
 
        NEXT(JABC12)=MOD(TREE(3,JABC12),46340)
        PREV(JABC12)=(TREE(3,JABC12)/46340)
        UP(JABC12)=(TREE(1,JABC12)/46340)
        DOWN(JABC12)=TREE(2,JABC12)
        NTYPE(JABC12)=MOD(TREE(1,JABC12),46340)
        NATTR(JABC12)=TREE(4,JABC12)
 
        SP=0
        STACK(1,0)=0
        STACK(2,0)=0
        STACK(3,0)=0
        RETURN
C ----------------------------------------------------------------------
C
C       B E G D O   -   Begin a DO loop
C
        ENTRY BEGDO(NODE)
 
        IF (SP.EQ.199) CALL ERROR('Nesting stack overflowed')
        SP=SP+1
        PTR=DOWN(NODE)
        IF (NTYPE(PTR).EQ.115) PTR=NEXT(PTR)
        STACK(1,SP)=NODE
        STACK(2,SP)=-DOWN(PTR)
        STACK(3,SP)=DOWN(DOWN(NEXT(PTR)))
        IF (SYMBOL(5,STACK(2,SP)).GT.0)
     +      CALL SYMERR('Branch into DO with label',STACK(2,SP))
        DO 2100 I=1,SP-1
            IF (STACK(3,I).EQ.STACK(3,SP))
     +          CALL SYMERR('Duplicated index variable',-STACK(3,I))
 2100   CONTINUE
        RETURN
C ----------------------------------------------------------------------
C
C       L A B E L   -   Process a label definition (maybe end one or
C                       more DO loops)
C
        ENTRY LABEL(LBLPTR)
 
        I=SYMBOL(8,LBLPTR)
        IF (I.GT.0 .AND. SP.GT.0 .AND. I.LT.STACK(1,SP))
     +      CALL SYMERR('Invalid fo'//'rward reference to',LBLPTR)
        SYMBOL(8,LBLPTR)=STACK(1,SP)
        SYMBOL(4,LBLPTR)=-1
 3100    IF (SP.GT.0 .AND. STACK(2,SP).EQ.LBLPTR) THEN
            SP=SP-1
            GOTO 3100
        END IF
        I=SP
 3200   IF (I.GT.0) THEN
            IF (STACK(2,I).EQ.LBLPTR) THEN
                CALL SYMERR('Overlapping DO/IF at label',LBLPTR)
                DO 3300 J=I+1,SP
                    STACK(1,J-1)=STACK(1,J)
                    STACK(2,J-1)=STACK(2,J)
                    STACK(3,J-1)=STACK(3,J)
 3300           CONTINUE
                SP=SP-1
            END IF
            I=I-1
            GOTO 3200
        END IF
        RETURN
C ----------------------------------------------------------------------
C
C       B E G I F   -   Begin an IF-THEN block
C
        ENTRY BEGIF(NODE)
 
        IF (SP.EQ.199)
     +      CALL ERROR('DO o'//'r IF too deeply nested')
        SP=SP+1
        STACK(1,SP)=NODE
        STACK(2,SP)=0
        STACK(3,SP)=0
        RETURN
C ----------------------------------------------------------------------
C
C       E L S I F   -   Begin an ELSEIF-THEN block
C
        ENTRY ELSIF(NODE)
 
        I=SP
 5100   IF (STACK(2,I).NE.0) THEN
            I=I-1
            IF (I.GT.0) GOTO 5100
        END IF
        IF (I.LE.0) THEN
            CALL YERROR('ELSEIF without IF-THEN')
        ELSE
            IF (I.NE.SP) CALL YERROR('Overlapping DO/IF')
            IF (STACK(3,I).NE.0) CALL YERROR('ELSEIF after ELSE')
            STACK(1,I)=NODE
        END IF
        RETURN
C ----------------------------------------------------------------------
C
C       E L S   -   Begin an ELSE block
C
        ENTRY ELS(NODE)
 
        I=SP
 6100   IF (STACK(2,I).NE.0) THEN
            I=I-1
            IF (I.GT.0) GOTO 6100
        END IF
        IF (I.LE.0) THEN
            CALL YERROR('ELSE without IF-THEN')
        ELSE
            IF (I.NE.SP) CALL YERROR('Overlapping DO/IF')
            IF (STACK(3,I).NE.0) CALL YERROR('ELSE after ELSE')
            STACK(1,I)=NODE
            STACK(3,I)=1
        END IF
        RETURN
C ----------------------------------------------------------------------
C
C       E N D I F F   -   End an IF-THEN/ELSEIF/ELSE block
        ENTRY ENDIFF
 
        I=SP
 7100   IF (STACK(2,I).NE.0) THEN
            I=I-1
            IF (I.GT.0) GOTO 7100
        END IF
        IF (I.LE.0) THEN
            CALL YERROR('ENDIF without IF-THEN')
        ELSE
            IF (I.NE.SP) CALL YERROR('Overlapping DO/IF')
            DO 7200 J=I+1,SP
                STACK(1,J-1)=STACK(1,J)
                STACK(2,J-1)=STACK(2,J)
                STACK(3,J-1)=STACK(3,J)
 7200       CONTINUE
            SP=SP-1
        END IF
        RETURN
C ----------------------------------------------------------------------
C
C       C H K G O   -   Process label control-flow reference (no jumps
C                       into DO-loops or block-IFs)
C
        ENTRY CHKGO(LBLPTR)
 
        IF (SYMBOL(4,LBLPTR).EQ.0 .AND.
     +      SYMBOL(8,LBLPTR).EQ.0) THEN
            SYMBOL(8,LBLPTR)=TRETOP
        ELSE IF (SYMBOL(4,LBLPTR).NE.0) THEN
            I=0
 8100       IF (STACK(1,I).NE.SYMBOL(8,LBLPTR)) THEN
                I=I+1
                IF (I.LE.SP) GOTO 8100
            END IF
            IF (I.GT.SP)
     +          CALL SYMERR('GOTO into DO-loop o'//'r IF-block, label',
     +                       LBLPTR)
        END IF
        RETURN
C ----------------------------------------------------------------------
C
C       E N D P U   -   Process end of program-unit (all blocks must
C                       have been terminated, reset stack)
C
        ENTRY ENDPU
 
        J=0
        DO 9100 I=1,SP
            IF (STACK(2,I).EQ.0) THEN
                J=J+1
            ELSE
                CALL SYMERR('Unterminated DO with label',STACK(2,I))
            END IF
 9100   CONTINUE
        IF (J.GT.0) CALL YERROR('Missing END-IF(s)')
        SP=0
        RETURN
C ----------------------------------------------------------------------
C
C       C H K A S G   -   Check assignment for legality
C
 
        ENTRY CHKASG(NODE)
 
        SYMPTR=DOWN(NODE)
        DO 10100 I=1,SP
            IF (SYMPTR.EQ.STACK(3,SP))
     +          CALL SYMERR('Assignment to DO variable',-SYMPTR)
10100   CONTINUE
C ======================================================================
C
C       End of Stack Handler
C
        END
C ----------------------------------------------------------------------
C
C       S Y M E R R   -   Display a symbol error message
C
 
        SUBROUTINE SYMERR(MSG,SYM)
        CHARACTER*(*) MSG
        INTEGER SYM
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
 
        INTEGER LENGTH
        CHARACTER*132 BUFFER,SYMNAM
 
        INTRINSIC LEN
 
        EXTERNAL ZITOF
 
        CALL ZITOF(STRTXT(SYMBOL(2,SYM)),1,132,SYMNAM,
     +             .TRUE.)
        LENGTH=0
 100    LENGTH=LENGTH+1
        IF (SYMNAM(LENGTH:).NE.' ' .AND. LENGTH.LT.132) GOTO 100
        BUFFER=MSG//' - '//SYMNAM
        LENGTH=MIN(132,LEN(MSG)+3+LENGTH)
        CALL YERROR(BUFFER(:LENGTH))
 
        END
C ----------------------------------------------------------------------
C
C       S Y M W R N   -   Display a symbol warning message
C
 
        SUBROUTINE SYMWRN(MSG,SYM)
        CHARACTER*(*) MSG
        INTEGER SYM
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSTRI/STRTXT,STRTBL,NSTRNG,TXTTOP
        INTEGER STRTXT(46339),STRTBL(7103),NSTRNG,TXTTOP
 
        SAVE /XCSTRI/
 
C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
        COMMON/XCSYMS/MODFLG,NSYMS,NPUS,PUIDX,SYMBOL
        INTEGER NSYMS,NPUS,PUIDX(250),
     +          SYMBOL(8,5003)
        LOGICAL MODFLG
 
        SAVE /XCSYMS/
 
        INTEGER LENGTH
        CHARACTER*132 BUFFER,SYMNAM
 
        INTRINSIC LEN
 
        EXTERNAL ZITOF
 
        CALL ZITOF(STRTXT(SYMBOL(2,SYM)),1,132,SYMNAM,
     +             .TRUE.)
        LENGTH=0
 100    LENGTH=LENGTH+1
        IF (SYMNAM(LENGTH:).NE.' ' .AND. LENGTH.LT.132) GOTO 100
        BUFFER='Warning: '//MSG//' - '//SYMNAM
        LENGTH=MIN(132,9+LEN(MSG)+3+LENGTH)
        CALL YERROR(BUFFER(:LENGTH))
 
        END
