/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_lf3.c */

#include "clos.h"

/* funzioni matematiche ************************************/
/* SIN    , COS    , TAN   , ASIN   , ACOS  , ATAN , SINH  */
/* COSH   , TANH   , EXP   , LOG    , LOG10 , SQRT         */
/* PLUS   , MINUS  , MULT  , DIV    , PLUSONE , MINUSONE   */
/* MAX    , MIN    , ABS   , FLOAT  , ROUND   , REM        */
/***********************************************************/

/* nota ***********************/
/* +   tradotto in PLUS      */
/* -      ,,        MINUS     */
/* *      ,,        MULT      */
/* /      ,,        DIV       */
/* 1+     ,,        PLUSONE   */
/* 1-     ,,        MINUSONE  */
/******************************/


#define M_SIN   0
#define M_COS   1
#define M_TAN   2
#define M_ASIN  3
#define M_ACOS  4
#define M_ATAN  5
#define M_SINH  6
#define M_COSH  7
#define M_TANH  8
#define M_EXP   9
#define M_LOG   10
#define M_LOG10 11
#define M_SQRT  12

#define MAX_M_FUNCS 13

void general_lf_math LF_PARAMSD;
int  math_ratcnvt();


n_real (*math_funcs[MAX_M_FUNCS])()={
 sin  ,cos  ,tan  ,
 asin ,acos ,atan ,
 sinh ,cosh ,tanh ,
 exp  ,log  ,log10,
 sqrt
};


void lf_sin LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_SIN);
}
void lf_cos LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_COS);
}
void lf_tan LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_TAN);
}
void lf_asin LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_ASIN);
}
void lf_acos LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_ACOS);
}
void lf_atan LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_ATAN);
}
void lf_sinh LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_SINH);
}
void lf_cosh LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_COSH);
}
void lf_tanh LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_TANH);
}
void lf_exp LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_EXP);
}
void lf_log LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_LOG);
}
void lf_log10 LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_LOG10);
}
void lf_sqrt LF_PARAMS
{
 general_lf_math(nin,nout,genv,lenv,M_SQRT);
}

void general_lf_math LF_PARAMS
{
 /* fl qui' e' usato come un indice per l'array di funzioni matematiche */

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=calc_pointer(nout);
   if( IS_VALUE_AND_NUMBER(nin) ){
     nout->node=node_make();
     nout->type=P_ALLNODE;
     switch(GET_VTYPE(nin)){
       case NT_INTEGER:
         INTEGER(nout->node)=(n_int)(*math_funcs[fl])((double)INTEGER(nin));
	 TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
         return;
       case NT_REAL:
         REAL(nout->node)=(n_real)(*math_funcs[fl])((double)REAL(nin));
         TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
         return;
       case NT_RATIO:
         REAL(nout->node)=(n_real)(*math_funcs[fl])
                        ((double)RATIO_NUM(nin)/(double)RATIO_DEN(nin));
         TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
         return;
     }
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}

int math_ratcnvt(num,den,integ)
n_int num;
n_int den;
n_int  *integ;
{
 double tmp;
 if(modf((double)num/(double)den,&tmp))return FALSE;
 *integ=(n_int)tmp; /*guardare se si puo' usare tmp */
 return TRUE;
}

#define TF_INT 0
#define TF_RAT 1
#define TF_FLO 2

void lf_plus LF_PARAMS
{
 int argcounter=0;
 int type_flag=TF_INT;
 n_int intval=0;/* el.neutro */
 n_real realval;
 n_int rval_num;
 n_int rval_den;
 node n,ni=nin;

 while(nin!=NIL){
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     n=calc_pointer(nout);
     if(IS_VALUE_AND_NUMBER(n)){
       switch(GET_VTYPE(n)){
         case NT_INTEGER:
           if(type_flag==TF_INT){
             intval+=INTEGER(n);
             break;
           }
           if(type_flag==TF_RAT){
             rval_num+=INTEGER(n)*rval_den;
             break;
           }
           realval+=(n_real)INTEGER(n);
           break;
         case NT_RATIO:
           if(type_flag==TF_INT){
             type_flag=TF_RAT;
             rval_den=RATIO_DEN(n);
             rval_num=RATIO_NUM(n)+intval*rval_den;
             break;
           }
           if(type_flag==TF_RAT){
             rval_num=rval_num*RATIO_DEN(n)+rval_den*RATIO_NUM(n);
             rval_den*=RATIO_DEN(n);
             break;
           }
           realval+=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
           break;
         case NT_REAL:
           if(type_flag==TF_INT){
             type_flag=TF_FLO;
             realval=(n_real)intval+REAL(n);
             break;
           }
           if(type_flag==TF_RAT){
             type_flag=TF_FLO;
             realval=(n_real)rval_num/(n_real)rval_den+REAL(n);
             break;
           }
           realval+=REAL(n);
           break;
       }/*switch*/
     }else{
       error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
     }/*isnumber*/
   }else{
       error(E_BADLIST,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
   }/*iscons*/
   nin=CONSRIGHT(nin);
   argcounter++;
 }
 if(argcounter<1)
   error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
 nout->node=node_make();
 nout->type=P_ALLNODE;
 if(type_flag==TF_INT){
    TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
    INTEGER(nout->node)=intval;
    return;
 }
 if(type_flag==TF_RAT){
    if(math_ratcnvt(rval_num,rval_den,&INTEGER(nout->node))){
        TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
        return;
    }
    TYPE(nout->node)|=NT_IS_VALUE+NT_RATIO;
    RATIO_NUM(nout->node)=rval_num;
    RATIO_DEN(nout->node)=rval_den;
    return;
 }
 TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
 REAL(nout->node)=realval;
}


void lf_minus LF_PARAMS
{
 int argcounter=0;
 int type_flag=TF_INT;
 n_int intval;
 n_real realval;
 n_int rval_num;
 n_int rval_den;
 node n,ni=nin;

 while(nin!=NIL){
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     n=calc_pointer(nout);
     if(IS_VALUE_AND_NUMBER(n)){
       switch(GET_VTYPE(n)){
         case NT_INTEGER:
           if(type_flag==TF_INT){
             if(argcounter){
	      intval-=INTEGER(n);
             }
             else{
              intval=INTEGER(n);
             }
             break;
           }
           if(type_flag==TF_RAT){
	     rval_num-=INTEGER(n)*rval_den;
             break;
           }
	   realval-=(n_real)INTEGER(n);
           break;
         case NT_RATIO:
           if(type_flag==TF_INT){
             type_flag=TF_RAT;
             if(argcounter){
               rval_den=RATIO_DEN(n);
               rval_num=RATIO_NUM(n)-intval*rval_den;
             }else{
               rval_num=RATIO_NUM(n);
               rval_den=RATIO_DEN(n);
             }
             break;
           }
           if(type_flag==TF_RAT){
             rval_num=rval_num*RATIO_DEN(n)-rval_den*RATIO_NUM(n);
             rval_den*=RATIO_DEN(n);
             break;
           }
	   realval-=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
           break;
         case NT_REAL:
           if(type_flag==TF_INT){
             type_flag=TF_FLO;
             if(argcounter){
              realval=(n_real)intval-REAL(n);
             }else{
              realval=REAL(n);
             }
             break;
           }
           if(type_flag==TF_RAT){
             type_flag=TF_FLO;
             realval=(n_real)rval_num/(n_real)rval_den-REAL(n);
             break;
           }
           realval-=REAL(n);
           break;
       }/*switch*/
     }else{
       error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
     }/*isnumber*/
   }else{
       error(E_BADLIST,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
   }/*iscons*/
   nin=CONSRIGHT(nin);
   argcounter++;
 }
 if(argcounter<1)
   error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
 if(argcounter==1){
   if(type_flag==TF_INT){
    intval*=-1;
   }
   else{
    if(type_flag==TF_RAT){
     rval_num*=-1;
    }
    else{
     realval*=-1;
    }
   }
 }
 nout->node=node_make();
 nout->type=P_ALLNODE;
 if(type_flag==TF_INT){
    TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
    INTEGER(nout->node)=intval;
    return;
 }
 if(type_flag==TF_RAT){
    if(math_ratcnvt(rval_num,rval_den,&INTEGER(nout->node))){
        TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
        return;
    }
    TYPE(nout->node)|=NT_IS_VALUE+NT_RATIO;
    RATIO_NUM(nout->node)=rval_num;
    RATIO_DEN(nout->node)=rval_den;
    return;
 }
 TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
 REAL(nout->node)=realval;
}


void lf_mult LF_PARAMS
{
 int argcounter=0;
 int type_flag=TF_INT;
 n_int intval=1; /*el.neutro*/
 n_real realval;
 n_int rval_num;
 n_int rval_den;
 node n,ni=nin;

 while(nin!=NIL){
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     n=calc_pointer(nout);
     if(IS_VALUE_AND_NUMBER(n)){
       switch(GET_VTYPE(n)){
         case NT_INTEGER:
           if(type_flag==TF_INT){
             intval*=INTEGER(n);
             break;
           }
           if(type_flag==TF_RAT){
	     rval_num*=INTEGER(n);
             break;
           }
	   realval*=(n_real)INTEGER(n);
           break;
         case NT_RATIO:
           if(type_flag==TF_INT){
             type_flag=TF_RAT;
             rval_den=RATIO_DEN(n);
             rval_num=RATIO_NUM(n)*intval;
             break;
           }
           if(type_flag==TF_RAT){
             rval_num*=RATIO_NUM(n);
             rval_den*=RATIO_DEN(n);
             break;
           }
	   realval*=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
           break;
         case NT_REAL:
           if(type_flag==TF_INT){
             type_flag=TF_FLO;
             realval=(n_real)intval*REAL(n);
             break;
           }
           if(type_flag==TF_RAT){
             type_flag=TF_FLO;
             realval=(n_real)rval_num/(n_real)rval_den*REAL(n);
             break;
           }
           realval*=REAL(n);
           break;
       }/*switch*/
     }else{
       error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
     }/*isnumber*/
   }else{
       error(E_BADLIST,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
   }/*iscons*/
   nin=CONSRIGHT(nin);
   argcounter++;
 }
 if(argcounter<2)
   error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
 nout->node=node_make();
 nout->type=P_ALLNODE;
 if(type_flag==TF_INT){
    TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
    INTEGER(nout->node)=intval;
    return;
 }
 if(type_flag==TF_RAT){
    if(math_ratcnvt(rval_num,rval_den,&INTEGER(nout->node))){
        TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
        return;
    }
    TYPE(nout->node)|=NT_IS_VALUE+NT_RATIO;
    RATIO_NUM(nout->node)=rval_num;
    RATIO_DEN(nout->node)=rval_den;
    return;
 }
 TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
 REAL(nout->node)=realval;
}


void lf_div LF_PARAMS
{
 int argcounter=0;
 int type_flag=TF_RAT;
 n_real realval;
 n_int rval_num;
 n_int rval_den;
 node n,ni=nin;

 while(nin!=NIL){
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     n=calc_pointer(nout);
     if(IS_VALUE_AND_NUMBER(n)){
       switch(GET_VTYPE(n)){
         case NT_INTEGER:
           if(argcounter && !INTEGER(n))
              error(E_DIVBYZERO,ERR_PVOID|ERR_MERROR|ERR_TBLVL,NULL);
           if(type_flag==TF_RAT){
             if(argcounter){
	      rval_den*=INTEGER(n);
             }
             else{
              rval_num=INTEGER(n);
              rval_den=1;
             }
             break;
           }
	   realval/=(n_real)INTEGER(n);
           break;
         case NT_RATIO:
           if(argcounter && !RATIO_NUM(n))
              error(E_DIVBYZERO,ERR_PVOID|ERR_MERROR|ERR_TBLVL,NULL);
           if(type_flag==TF_RAT){
            if(argcounter){
             rval_num*=RATIO_DEN(n);
             rval_den*=RATIO_NUM(n);
            }else{
             rval_num=RATIO_NUM(n);
             rval_den=RATIO_DEN(n);
            }
            break;
           }
	   realval*=(n_real)RATIO_DEN(n)/(n_real)RATIO_NUM(n);
           break;
         case NT_REAL:
           if(argcounter && !REAL(n))
              error(E_DIVBYZERO,ERR_PVOID|ERR_MERROR|ERR_TBLVL,NULL);
           if(type_flag==TF_RAT){
             type_flag=TF_FLO;
             if(argcounter){
              realval=(n_real)rval_num/(n_real)rval_den/REAL(n);
             }else{
              realval=REAL(n);
             }
             break;
           }
           realval/=REAL(n);
           break;
       }/*switch*/
     }else{
       error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
     }/*isnumber*/
   }else{
       error(E_BADLIST,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
   }/*iscons*/
   nin=CONSRIGHT(nin);
   argcounter++;
 }
 if(argcounter<2)
   error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
 nout->node=node_make();
 nout->type=P_ALLNODE;
 if(type_flag==TF_RAT){
    if(math_ratcnvt(rval_num,rval_den,&INTEGER(nout->node))){
        TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
        return;
    }
    TYPE(nout->node)|=NT_IS_VALUE+NT_RATIO;
    RATIO_NUM(nout->node)=rval_num;
    RATIO_DEN(nout->node)=rval_den;
    return;
 }
 TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
 REAL(nout->node)=realval;
}


void lf_plusone LF_PARAMS
{
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=calc_pointer(nout);
   if(IS_VALUE_AND_NUMBER(nin)){
     nout->type=P_ALLNODE;
     switch(GET_VTYPE(nin)){
       case NT_INTEGER:
	 TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_INTEGER;
         INTEGER(nout->node)=INTEGER(nin)+1;
         return;
       case NT_RATIO:
	 TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_RATIO;
         RATIO_NUM(nout->node)=RATIO_NUM(nin)+RATIO_DEN(nin);
         RATIO_DEN(nout->node)=RATIO_DEN(nin);
         return;
       case NT_REAL:
	 TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_REAL;
         REAL(nout->node)=REAL(nin)+1;
         return;
     }
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}


void lf_minusone LF_PARAMS
{
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=calc_pointer(nout);
   if(IS_VALUE_AND_NUMBER(nin)){
     nout->type=P_ALLNODE;
     switch(GET_VTYPE(nin)){
       case NT_INTEGER:
	 TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_INTEGER;
         INTEGER(nout->node)=INTEGER(nin)-1;
         return;
       case NT_RATIO:
	 TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_RATIO;
         RATIO_NUM(nout->node)=RATIO_NUM(nin)-RATIO_DEN(nin);
         RATIO_DEN(nout->node)=RATIO_DEN(nin);
         return;
       case NT_REAL:
	 TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_REAL;
         REAL(nout->node)=REAL(nin)-1;
         return;
     }
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}







#define TF_FIRST 1


void lf_max LF_PARAMS
{
 /* ritorna il massimo tra gli argomenti */

 REGISTER_MOD int    type_flag=TF_FIRST;
 REGISTER_MOD n_type t;
 n_int  last_int;
 n_real last_real;
 n_real tmp;
 node	n;
 node   max=NIL;

   while(IS_CONS(nin)){
      eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
      if( (t=TYPE(n=calc_pointer(nout)))&NT_IS_VALUE){
         switch(t&NT_MASK){
             case NT_INTEGER:
                switch(type_flag){
                   case TF_FIRST:
                      type_flag=TF_INT;
                      last_int=INTEGER(n);
                      max=n;
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
                      if(last_int<INTEGER(n)){
                        last_int=INTEGER(n);
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_FLO:
		      if(last_real<(n_real)INTEGER(n)){
                        last_real=(n_real)INTEGER(n);
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                }
             case NT_RATIO:
                switch(type_flag){
                   case TF_FIRST:
                      last_real=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      type_flag=TF_FLO;
                      max=n;
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
                      tmp=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      if((n_real)last_int<tmp){
                        last_real=tmp;
                        type_flag=TF_FLO;
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_FLO:
                      tmp=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      if(last_real<tmp){
                        last_real=tmp;
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                }
             case NT_REAL:
                switch(type_flag){
                   case TF_FIRST:
                      last_real=REAL(n);
                      type_flag=TF_FLO;
                      max=n;
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
                      if((n_real)last_int<REAL(n)){
                        last_real=REAL(n);
                        type_flag=TF_FLO;
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_FLO:
                      if(last_real<REAL(n)){
                        last_real=REAL(n);
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                }
             default:
               error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
         }/* switch */
      }/* if is-value */
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
   }/* while */
 nout->type=P_ALLNODE;
 nout->node=max;
}


void lf_min LF_PARAMS
{
 /* ritorna il minimo tra gli argomenti */

 REGISTER_MOD int    type_flag=TF_FIRST;
 REGISTER_MOD n_type t;
 n_int  last_int;
 n_real last_real;
 n_real tmp;
 node	n;
 node   max=NIL;

   while(IS_CONS(nin)){
      eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
      if( (t=TYPE(n=calc_pointer(nout)))&NT_IS_VALUE){
         switch(t&NT_MASK){
             case NT_INTEGER:
                switch(type_flag){
                   case TF_FIRST:
                      type_flag=TF_INT;
                      last_int=INTEGER(n);
                      max=n;
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
                      if(last_int>INTEGER(n)){
                        last_int=INTEGER(n);
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_FLO:
		      if(last_real>(n_real)INTEGER(n)){
                        last_real=(n_real)INTEGER(n);
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                }
             case NT_RATIO:
                switch(type_flag){
                   case TF_FIRST:
                      last_real=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      type_flag=TF_FLO;
                      max=n;
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
                      tmp=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      if((n_real)last_int>tmp){
                        last_real=tmp;
                        type_flag=TF_FLO;
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_FLO:
                      tmp=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      if(last_real>tmp){
                        last_real=tmp;
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                }
             case NT_REAL:
                switch(type_flag){
                   case TF_FIRST:
                      last_real=REAL(n);
                      type_flag=TF_FLO;
                      max=n;
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
                      if((n_real)last_int>REAL(n)){
                        last_real=REAL(n);
                        type_flag=TF_FLO;
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_FLO:
                      if(last_real>REAL(n)){
			last_real=REAL(n);
                        max=n;
                      }
                      nin=CONSRIGHT(nin);
                      continue;
                }
             default:
               error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
         }/* switch */
      }/* if is-value */
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
   }/* while */
 nout->type=P_ALLNODE;
 nout->node=max;
}


void lf_abs LF_PARAMS
{
 /* sintassi (abs numero) */

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=calc_pointer(nout);
   if( IS_VALUE_AND_NUMBER(nin) ){
     nout->node=node_make();
     nout->type=P_ALLNODE;
     switch(GET_VTYPE(nin)){
       case NT_INTEGER:
         INTEGER(nout->node)=INTEGER(nin)>0?INTEGER(nin):-INTEGER(nin);
         TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
         return;
       case NT_REAL:
         REAL(nout->node)=fabs(REAL(nin));
         TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
         return;
       case NT_RATIO:
         RATIO_NUM(nout->node)=RATIO_NUM(nin)>0?RATIO_NUM(nin):-RATIO_NUM(nin);
         RATIO_DEN(nout->node)=RATIO_DEN(nin)>0?RATIO_DEN(nin):-RATIO_DEN(nin);
         TYPE(nout->node)|=NT_IS_VALUE+NT_RATIO;
	 return;
     }
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}

void lf_float LF_PARAMS
{
 /* sintassi (float numero) */

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=calc_pointer(nout);
   if( IS_VALUE_AND_NUMBER(nin) ){
     nout->node=node_make();
     nout->type=P_ALLNODE;
     TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
     switch(GET_VTYPE(nin)){
       case NT_INTEGER:
         REAL(nout->node)=(n_real)INTEGER(nin);
         return;
       case NT_REAL:
         REAL(nout->node)=REAL(nin);
         return;
       case NT_RATIO:
         REAL(nout->node)=(n_real)RATIO_NUM(nin)/(n_real)RATIO_DEN(nin);
         return;
     }
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}

void lf_round LF_PARAMS
{
 /* sintassi (round numero) */

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=calc_pointer(nout);
   if( IS_VALUE_AND_NUMBER(nin) ){
     nout->node=node_make();
     nout->type=P_ALLNODE;
     TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
     switch(GET_VTYPE(nin)){
       case NT_INTEGER:
         INTEGER(nout->node)=INTEGER(nin);
         return;
       case NT_REAL:
         INTEGER(nout->node)=(n_int)REAL(nin);
         return;
       case NT_RATIO:
         INTEGER(nout->node)=RATIO_NUM(nin)/RATIO_DEN(nin);
         return;
     }
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}

void lf_rem LF_PARAMS
{
 /* sintassi (rem numero) */
 double tmp;

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=calc_pointer(nout);
   if( IS_VALUE_AND_NUMBER(nin) ){
     nout->node=node_make();
     nout->type=P_ALLNODE;
     switch(GET_VTYPE(nin)){
       case NT_INTEGER:
         INTEGER(nout->node)=(n_int)0;
         TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
         return;
       case NT_REAL:
         REAL(nout->node)=modf(REAL(nin),&tmp);
         TYPE(nout->node)|=NT_IS_VALUE+NT_REAL;
         return;
       case NT_RATIO:
         if(RATIO_NUM(nin)>RATIO_DEN(nin)){
           RATIO_NUM(nout->node)=RATIO_NUM(nin)-RATIO_DEN(nin);
         }else{
           RATIO_NUM(nout->node)=RATIO_NUM(nin);
         }
         RATIO_DEN(nout->node)=RATIO_DEN(nin);
         TYPE(nout->node)|=NT_IS_VALUE+NT_RATIO;
         return;
     }
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}

