/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/

#include "clos.h"

#define getinit()						\
  node n;                                                       \
  node ni=nin                                                   \

#define getint(v)						\
  if(!IS_CONS(nin))                                             \
    error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&ni);        \
  eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);			\
  n=calc_pointer(nout);						\
  if(!IS_VALUE(n) || !(GET_VTYPE(n)==NT_INTEGER) )              \
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);         \
  v=INTEGER(n);							\
  nin=CONSRIGHT(nin);

#define getstring(v)						\
  if(!IS_CONS(nin))                                             \
    error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&ni);        \
  eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);			\
  n=calc_pointer(nout);						\
  if(!IS_VALUE(n) || !(GET_VTYPE(n)==NT_STRING) )               \
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);         \
  v=STRING(n);							\
  nin=CONSRIGHT(nin);

#define getstream(v)						\
  if(!IS_CONS(nin))                                             \
    error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&ni);        \
  eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);			\
  n=calc_pointer(nout);						\
  if(!IS_VALUE(n) || !(GET_VTYPE(n)==NT_STREAM) )               \
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);         \
  v=STREAM(n);							\
  nin=CONSRIGHT(nin);

/* funzioni di File e Console I/O ***************************/
/* FOPEN      , FCLOSE     , FSEEK     , FTELL   	    */
/* FEOF       , FERROR     , FCLEARERR                      */
/* FREADBYTE  , FWRITEBYTE                                  */
/* FINPUT     , FPRINT     , FSCANF                         */
/* PRINT      , INPUT      , LOAD                      	    */
/* READLINE   , READCHAR   , CURPOS    , TEXTCOLOR          */
/* CLS 	  						    */
/************************************************************/


void lf_fopen LF_PARAMS
{
 /* sintassi (open nomefile string) */
 getinit();
 str_t s;
 FILE *f;

 getstring(s);string_get(s,buf1);
 getstring(s);string_get(s,buf2);
 f=fopen(buf1,buf2);
 if(f){
   TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_STREAM;
   STREAM(nout->node)=f;
 }else{
   nout->node=NIL;
 }
 nout->type=P_ALLNODE;
}

void lf_fclose LF_PARAMS
{
 /* sintassi (close stream) */
 getinit();
 FILE *f;

 getstream(f);
 nout->type=P_ALLNODE;
 if(f==stdin || f==stdout || f==stderr || f==stdaux || f==stdprn || !f){
   nout->node=NIL;
 }else{
   if(fclose(f)==EOF){
     nout->node=NIL;
   }else{
     nout->node=T;
     STREAM(n)=NULL;
   }
 }
}

void lf_fseek LF_PARAMS
{
 /* sintassi (fseek stream intero{offset} intero{whence} ) */
 getinit();
 FILE *f;
 n_int o,w;

 getstream(f);
 getint(o);
 getint(w);
 if(w<0 || w>2)
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
 if(f){
   fseek(f,o,(int)w);
   nout->node=T;
 }else{
   nout->node=NIL;
 }
 nout->type=P_ALLNODE;
}


void lf_ftell LF_PARAMS
{
 /* sintassi (ftell stream ) */
 getinit();
 FILE *f;
 long pos;

 getstream(f);
 nout->node=P_ALLNODE;
 if(f){
   pos=ftell(f);
   if(pos!=-1L){
     TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_INTEGER;
     INTEGER(nout->node)=pos;
     nout->type=P_ALLNODE;
     return;
   }
 }
 nout->node=NIL;
}

void lf_feof LF_PARAMS
{
 getinit();
 FILE *f;

 getstream(f);
 nout->type=P_ALLNODE;
 nout->node=f?(feof(f)?T:NIL):T;
}

void lf_ferror LF_PARAMS
{
 getinit();
 FILE *f;

 getstream(f);
 nout->type=P_ALLNODE;
 nout->node=f?(ferror(f)?T:NIL):T;
}

void lf_fclearerr LF_PARAMS
{
 getinit();
 FILE *f;

 getstream(f);
 if(f)clearerr(f);
 nout->type=P_ALLNODE;
 nout->node=f?T:NIL;
}

void lf_freadbyte LF_PARAMS
{
 /* (freadbyte stream) */
 node n;
 FILE *fin;
 if(IS_CONS(nin)){
  eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
  n=calc_pointer(nout);
  if(IS_VALUE(n)&&GET_VTYPE(n)==NT_STREAM){
    fin=STREAM(n);
    if(fin==stdout||fin==stderr||fin==stdprn||fin==stdaux||fin==NULL){
      nout->node=NIL;
      nout->type=P_ALLNODE;
      return;
    }
    TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_INTEGER;
    INTEGER(nout->node)=(n_int)lisp_get_char(STREAM(n));
    nout->type=P_ALLNODE;
    return;
  }
  error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}

void lf_fwritebyte LF_PARAMS
{
 /* (fwritebyte stream integer) */
 FILE *f;
 node n,nn=nin;

 if(IS_CONS(nin)){
  eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
  n=calc_pointer(nout);
  if(IS_VALUE(n)&&GET_VTYPE(n)==NT_STREAM){
    f=STREAM(n);
    nin=CONSRIGHT(nin);
    if(IS_CONS(nin)){
      eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
      n=calc_pointer(nout);
      if(IS_VALUE(n)&&GET_VTYPE(n)==NT_INTEGER){
	lisp_put_char((int)INTEGER(n),f);
	return;
      }
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
    }
    error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
  }
  error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
}



void lf_fprint LF_PARAMS
{
 /* sintassi (fprint stream {sx}* ) */
 /* serve per stampare le s-espressioni su un file */

 node n=nin;
 node np;
 node f;

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   f=calc_pointer(nout);
   if(IS_VALUE(f) && GET_VTYPE(f)==NT_STREAM){
     if(STREAM(f)==NULL){
       nout->node=NIL;
       nout->type=P_ALLNODE;
       return;
     }
     nout->node=NIL;
     nout->type=P_ALLNODE;
     nin=CONSRIGHT(nin);
     while(nin!=NIL){
       if(IS_CONS(nin)){
	 eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	 np=calc_pointer(nout);
	 if(IS_VALUE(np) && GET_VTYPE(np)==NT_STRING){
	   lisp_print_string(string_getconv(STRING(np),buf1),STREAM(f));
	 }else{
	   fprint_func(np,STREAM(f));
	 }
       }else{
	 error(E_BADLIST,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
       }
       nin=CONSRIGHT(nin);
     }
     return;
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}


void lf_finput LF_PARAMS
{
 /* (input streamin streamout{puo' essere nil o NULL} prompt) */

 FILE *fin,*fout;
 node n,nn=nin;

 if(IS_CONS(nin)){
  eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
  n=calc_pointer(nout);
  if(IS_VALUE(n)&&GET_VTYPE(n)==NT_STREAM){
    fin=STREAM(n);
    if(fin==stdout||fin==stderr||fin==stdprn||fin==stdaux||fin==NULL){
      nout->node=NIL;
      nout->type=P_ALLNODE;
      return;
    }
    nin=CONSRIGHT(nin);
    if(IS_CONS(nin)){
      eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
      n=calc_pointer(nout);
      if( (IS_VALUE(n)&&GET_VTYPE(n)==NT_STREAM) || n==NIL){
	fout=(n==NIL)?NULL:STREAM(n);
	nin=CONSRIGHT(nin);
	if(IS_CONS(nin)){
	  eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	  n=calc_pointer(nout);
	  if( IS_VALUE(n)&&GET_VTYPE(n)==NT_STRING ){
	    nout->node=input_func(fin,fout,string_get(STRING(n),buf3));
	    if(nout->node==VOID){
	      nout->node=node_alloc(PARSE_ERROR_ID);
	    }
	    nout->type=P_ALLNODE;
	    return;
	  }
	  error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
	}
	error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
      }
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
    }
    error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
  }
  error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
}



/*  fscanf:  interi, reali, stringhe */


void lf_fscanf LF_PARAMS
{

 /* (fscanf streamin type ) */
 /* ritorna *SYNTAX_ERROR* o il valore */

 FILE *fin;
 node n,nn=nin;
 double v;
 n_int i;
 int ret;

 if(IS_CONS(nin)){
  eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
  n=calc_pointer(nout);
  if(IS_VALUE(n)&&GET_VTYPE(n)==NT_STREAM){
    fin=STREAM(n);
    if(fin==stdin||fin==stdout||fin==stderr||fin==stdprn||fin==stdaux||fin==NULL){
      nout->node=NIL;
      nout->type=P_ALLNODE;
      return;
    }
    nin=CONSRIGHT(nin);
    if(IS_CONS(nin)){
      eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
      n=calc_pointer(nout);
      if( IS_VALUE(n)&&GET_VTYPE(n)==NT_INTEGER ){
	nout->type=P_ALLNODE;
	switch(INTEGER(n)){
	  case 0: /* integer */
	    ret=fscanf(fin,"%ld",&i);
	    if(ret==0){
	      nout->node=node_alloc( PARSE_ERROR_ID );
	      return;
	    }
	    TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_INTEGER;
	    INTEGER(nout->node)=(n_int)i;
	    return;
	  case 1: /* real */
	    ret=fscanf(fin,"%lf",&v);
	    if(ret==0){
	      nout->node=node_alloc( PARSE_ERROR_ID );
	      return;
	    }
	    TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_REAL;
	    REAL(nout->node)=v;
	    return;
	  case 2: /* string */
	    if(!fgets(buf1,MAX_ID_LENGHT+1,fin)){
	      *buf1=0;
	    }
	    nout->node=node_make();
	    STRING(nout->node)=string_put(buf1,nout->node);
	    TYPE(nout->node)|=NT_IS_VALUE+NT_STRING;
	    return;
	}
      }
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
    }
    error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
  }
  error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
}











void lf_input LF_PARAMS
{
 /* accetta una s-espressione da tastiera e la ritorna */
 if(nin==NIL){
   if( (nout->node=input_func(stdin,stdout,INPUT_PROMPT)) ==VOID){
     nout->node=node_alloc(PARSE_ERROR_ID);
   }
   nout->type=P_ALLNODE;
   return;
 }
 error(nin==NIL?E_FEWARGS:E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_print LF_PARAMS
{
 node n=nin;
 node np;

 nout->node=NIL;
 nout->type=P_ALLNODE;
 while(nin!=NIL){
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     np=calc_pointer(nout);
     if(IS_VALUE(np) && GET_VTYPE(np)==NT_STRING){
       lisp_print_string(string_getconv(STRING(np),buf1),stdout);
     }else{
       fprint_func(np,stdout);
     }
   }else{
     error(E_BADLIST,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
   }
   nin=CONSRIGHT(nin);
 }
}


void    lf_load LF_PARAMS
{
 node n=nin;

 while(nin!=NIL){
  if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    nout->node=calc_pointer(nout);
    if(IS_VALUE(nout->node)&&GET_VTYPE(nout->node)==NT_STRING){
      if(eval_lisp_file(string_get(STRING(nout->node),buf3),genv,lenv)==VOID){
	nout->node=NIL;
	nout->type=P_ALLNODE;
	return;
      }
    }
    else
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nout->node);
    nin=CONSRIGHT(nin);
  }
  else
    error(E_BADLIST,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
 }
 nout->node=T;
 nout->type=P_ALLNODE;
}







void lf_readline LF_PARAMS
{
 /* SINTASSI: (READLINE {INT}? {STRINGA}? */
 node n;
 int  len=MAX_ID_LENGHT;

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=CONSRIGHT(nin);
   n=calc_pointer(nout);
   if(IS_VALUE(n) && GET_VTYPE(n)==NT_INTEGER){
     len=(int)INTEGER(n);
   }else{
     error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
   }
 }
 buf1[0]=0;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=CONSRIGHT(nin);
   n=calc_pointer(nout);
   if(IS_VALUE(n) && GET_VTYPE(n)==NT_STRING){
     string_get(STRING(n),buf1);
   }else{
     error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
   }
 }
 if(nin==NIL){
   lisp_get_string(buf1,len,stdin);

   TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_STRING;
   STRING(nout->node)=string_put(buf1,nout->node);

   nout->type=P_ALLNODE;
   return;
 }
 error(E_TOOMANYARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}






/* 80x25 */

void lf_curpos LF_PARAMS
{
 node n,nn=nin;
 n_int x,y;

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   n=calc_pointer(nout);
   if( IS_VALUE(n) && GET_VTYPE(n)==NT_INTEGER ){
     x=INTEGER(n);
     nin=CONSRIGHT(nin);
     if(x>0 && x<81){
       if(IS_CONS(nin)){
	 eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	 n=calc_pointer(nout);
	 if( IS_VALUE(n) && GET_VTYPE(n)==NT_INTEGER ){
	   y=INTEGER(n);
	   if(y>0 && y<26){
	     lisp_curpos((unsigned)x,(unsigned)y);
	     return;
	   }
	 }
	 error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
       }
       error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
     }
   }
   error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
}


void lf_textcolor LF_PARAMS
{
 node n,nn=nin;
 n_int f=0,b=0,a=0;

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   n=calc_pointer(nout);
   if( IS_VALUE(n) && GET_VTYPE(n)==NT_INTEGER ){
     f=INTEGER(n);
   }else
     error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
   nin=CONSRIGHT(nin);
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     n=calc_pointer(nout);
     if( IS_VALUE(n) && GET_VTYPE(n)==NT_INTEGER ){
       b=INTEGER(n);
     }else
       error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
     nin=CONSRIGHT(nin);
     if(IS_CONS(nin)){
       eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
       n=calc_pointer(nout);
       if( IS_VALUE(n) && GET_VTYPE(n)==NT_INTEGER ){
	 a=INTEGER(n);
       }else
	 error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
     }
   }
   lisp_charcolor(f,b,a);
   return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nn);
}


void lf_cls LF_PARAMS
{
 if(!IS_CONS(nin)){
   lisp_cls();
   nout->node=T;
   nout->type=P_ALLNODE;
   return;
 }
 error(E_TOOMANYARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}

void lf_readchar LF_PARAMS
{
 TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_INTEGER;
 INTEGER(nout->node)=cl_getch();
 nout->type=P_ALLNODE;
}

/*
void lf_charready LF_PARAMS
{
 TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_INTEGER;
 nout->node=cl_kbhit()?T:NIL;
 nout->type=P_ALLNODE;
}
*/
