/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* File clos.h */

#ifdef CLOS_TC
#include "clostc.h"
#endif
#ifdef CLOS_WI
#include "closwin.h"
#endif
#ifdef CLOS_XE
#include "closxen.h"
#endif
#ifdef CLOS_UX
#include "closunix.h"
#endif
#ifdef  CLOS_BL
#include "bliswin.h"
#endif

#ifndef CONFIGFILE
#error Devi compilare definendo CLOS_TC o CLOS_WI o CLOS_XE o CLOS_UX o CLOS_BL
#endif


#include "closerr.h"
#include "closnans.h"

#define CLOS_H_INCLUDED
#define NO_LISPMEM_DEBUG /* definendo LISPMEM_DEBUG si stampano delle informazioni utili al debug */
#define YYDEBUG 0        /* defindendo YYDEBUG 1 si fa genereare a YACC un codice + lungo ma utile per il debug del parser */
#define REGISTER_MOD		register  /* keyword register */

#define CLOS_VERSION 		"2.7.6"
#define STANDARD_PROMPT		">"
#define INPUT_PROMPT		"*"
#define NIL_IDENTIFIER		"NIL"
#define TRUE_IDENTIFIER		"T"
#define FILE_ERROR_ID		"*FILE_ERROR*"
#define PARSE_ERROR_ID		"*SYNTAX_ERROR*"
#define WINDOWS_ID		"*WINDOWS*"
#define UNBOUND_ID		"*UNBOUND*"
#define MAX_ID_LENGHT   	130     /* lunghezza massima di un identificatore */
					/* senza lo zero finale */


#define MAX_STR_LENGHT (MAX_ID_LENGHT-2)      /* o di una stringa(-2) */
					      /* perche' in yytext entrano */
					      /* anche gli apici */

#ifdef YYLMAX                   /* quando si compila CLOSLEX lo si */
#undef  YYLMAX                 /* in modo da definire la lunghezza */
#define YYLMAX (MAX_ID_LENGHT+1)       /* massima di un identificatore */
#endif					/* con lo 0 finale */



#define EVAL_NORM       0       /* valutazione normale               */
#define EVAL_SETF       1       /* non da unbound error ma cerca gli */
				/* eventuali legami locali del nodo  */
#define DUP_LASTDUP	0	/* flags per list-dup */
#define DUP_LASTNIL	1

#define DELETED         ((node)0xfffffffeL) /* indica l'hash entry cancellata */

#define NIL		nilhandler	/* nodo NIL  sempre allocato */
#define T		truehandler	/* nodo T    sempre allocato */
#define VOID		voidhandler	/* nodo VOID sempre allocato */
/* e' usato per segnalare errore dalle funzioni che ritornano un nodo */
/* ed  usato per tenere il primo nodo della lista dei nodi */

#define TRUE		1
#define FALSE		0
#define	OK		0	/* usato dalle funzioni che ritornano un int */
#define ERROR		1	/* usato dalle funzioni che ritornano un int */



#define LF_PARAMSD ()
#define LF_PARAMS (nin,nout,genv,lenv,fl)\
		node nin;node_p*nout;node genv;node lenv;unsigned fl;

#ifdef LOGISCOPE	/* se si vuole usare il LOGISCOPE (su HP9000).... */
#define node_s struct node_str
#define node_p struct lf_dialog_type
typedef unsigned long int node;
#define lsiz_t unsigned long int
#define len_t  unsigned int
#define	hash_t unsigned long int
#define str_t  unsigned long int
#define n_int  long int
#define n_real double
#define n_type unsigned int
#define p_type unsigned int
#define n_func void*
#define n_char char
#else
typedef struct node_str		node_s; /* struttura di un nodo-lisp */
typedef struct lf_dialog_type	node_p;	/* struttura di un puntatore ad un nodo-lisp */
typedef unsigned long int	node;   /* tipo di dato di un nodo-lisp */
typedef unsigned long int	lsiz_t;	/* ampiezza aree di memoria e numero di nodo allocati allo start-up */
typedef unsigned int 		len_t;	/* lunghezza liste */
typedef	unsigned long int	hash_t;	/* hash type */
typedef unsigned long int	str_t;	/* lisp string type */
typedef long int		n_int;  /* lisp integer type */
typedef double			n_real; /* lisp real type */
typedef unsigned int		n_type;	/* tipo del valore di un nodo-lisp */
typedef unsigned int		p_type;	/* tipo di un puntatore ad un nodo */
typedef void                    (*n_func)LF_PARAMSD; /* funzione lisp */
typedef char			n_char;
#endif

#define P(x)	((node_s*)(x)) /* ritorna il puntatore (node_s*) associato all'handler x(node) */
#define Q(x)	((node)(x))    /* ritorna l'handler (node) associato al puntatore x(node_s*) */


struct node_str{
/* 2 */	n_type	type;	/* tipo del nodo (vedi sotto) */
/* 4 */	node	next;	/* prossimo nodo nella lista */
/* 4 */	node	nextlock; /* prossimo nodo bloccato */
/*---*/ union{
/* 10 */
		struct{                 /* nodo con nome */
/* 4 */			str_t	name;   /* nome */
/* 4 */			hash_t	hash;	/* hash del nome */
/* 4 */			node	value;	/* valore globale */
/* 4 */			node	plist;	/* property-list */
/* 4 */			node	func;	/* legame funzionale */
/* 4 */                 node    class;  /* legame classe */
/*---*/		}nname;
/*24 */
/*===*/
/*34 */
		struct{               	/* nodo cons */
			node	left;	/* car */
			node	right;	/* cdr */
		}ncons;

		union{                  /* nodo valore */
			n_real	real;  	/* nodo real */
			n_int	integer;/* nodo integer */
			str_t	string;	/* nodo string */
			n_func	sysfunc;/* nodo funzione di sistema */
			n_char  character; /* carattere */
			FILE	*stream;/* stream */
			node    node;   /* nodo accessorio */
				/* (: , & , method o istanza di classe ) */

			struct{
				n_int   num;
				n_int   den;
			}ratio;

			struct{
				n_real	real;
				n_real	img;
			}complex;


			struct{
/* 4 */                         node    params_type;
/* 4 */                         node    params;
/* 4 */                         node    optionals;
/* 4 */                         node    rest;
/* 4 */                         node    key;
/* 4 */                         node    aux;
/* 4 */                         node    sexprs;
/* 4 */                         node    environment;
/*---*/                 }userfunc;
/*32 */
/*===*/
/*42 */
			struct{
                                node    name;
				lsiz_t  field;
                        }accessor;
		}nvalue;
	}body;
};



/******************* NODE TYPE *********************************

 node type	16 bit
 il primo byte ha significati differenti a seconda del tipo del nodo
 il secondo byte e' uguale per tutti i tipi di nodo


	0	1	2	3	4	5	6	7
nname:  --------------name binds flags----------------
	name    value   plist   bind    func    class  xxx     xxx
	 *	  *       *    defvar     *      NA
nvalue: --------value-type--------------------------- -value flags-
	---ordinal type----------    numberp has-node xxxx istraced
0       0000 nodo appena allocato       0         0     0       0
1       1000 integer                    1         0     0       0
2       0100 real                       1         0     0       0
3       1100 string                     0         0     0       0
4       0010 ratio                      1         0     0       0
5       1010 sysfunc                    0         0     0       ?
6       0110 ufunc                      0         0     0       ?
7       1110 accessor                   0         0     0       ?
8       0001 method                     0         1     0       ?
9       1001 class                      0         1     0       0
10 a    0101 char  (non implementato)   0         0     0       0 NI
11 b    1101 &-node                     0         1     0       0
12 c    0011 :-node                     0         1     0       0
13 d    1011 complex (non impl.)        1         0     0       0 NI
14 e    0111 stream                     0         0     0       0
15 f    1111 macro                      0         0     0       ?

ncons: --------------------------non utilizzati--------------------
	xxx     xxx     xxx     xxx     xxx     xxx     xxx     xxx




8	9	10	11	12	13	14	15
-------type of cell-------      islock isrem  isfix  ismarked
0000 new-cell                    0       0      0       0
1000 name                        ?       ?      ?       ?
0100 value                       ?       ?      ?       ?
0010 cons                        ?       ?      ?       ?
0001 xxxxxxxx                    x       x      x       x

************************************************************************/


/* queste sono tutte le define corrispondenti al tipo-nodo */

#define NT_NEW_NODE_T           0x0000 /* nodo appena allocato */

/*===================================LOW  BYTE===========================*/
/* low-byte solo nodo con nome */
#define NT_HAS_NOTHING          0x0000
#define NT_HAS_NAME             0x0001
#define NT_HAS_VALUE            0x0002
#define NT_HAS_PLIST            0x0004
#define NT_HAS_BIND             0x0008
#define NT_HAS_FUNCTION         0x0010
#define NT_HAS_CLASS            0x0020

/* low-byte solo nodo valore */
#define NT_IS_NUMBER            0x0010

#define NT_IS_NODEBIND          0x0020

#define NT_IS_TRACE             0x0080
#define NT_UNTRACE              0xff7f

#define NT_INTEGER             (0x0001 + NT_IS_NUMBER)
#define NT_REAL                (0x0002 + NT_IS_NUMBER)
#define NT_STRING               0x0003
#define NT_RATIO               (0x0004 + NT_IS_NUMBER)
#define NT_SYSFUNC              0x0005
#define NT_UFUNC                0x0006
#define NT_ACCESSOR             0x0007
#define NT_METHOD              (0x0008 + NT_IS_NODEBIND)
#define NT_CLASS               (0x0009 + NT_IS_NODEBIND)
#define NT_CHAR                 0x000a
#define NT_ENAME               (0x000b + NT_IS_NODEBIND)
#define NT_CNAME               (0x000c + NT_IS_NODEBIND)
#define NT_COMPLEX             (0x000d + NT_IS_NUMBER)
#define NT_STREAM               0x000e
#define NT_MACRO		0x000f
#define NT_MASK                 0x003f
/*=======================================================================*/


/*===================================HIGH BYTE===========================*/
/* high-byte per tutti i nodi */
#define NT_IS_NEW               0x0000
#define NT_IS_NAME              0x0100
#define NT_IS_VALUE             0x0200
#define NT_IS_CONS              0x0400
#define NT_IS_MASK              0x0f00

#define	NT_IS_MARK		0x8000	/* marcatura del GC */
#define	NT_UNMARK		0x7fff

#define NT_IS_FIX               0x4000
#define NT_UNFIX                0xbfff

#define NT_IS_REM               0x2000
#define NT_UNREM                0xdfff

#define NT_IS_LOCK		0x1000
#define NT_UNLOCK		0xefff
/*=======================================================================*/


/*============================== TYPE MACRO =============================*/
/* macro per vedere di che tipo e' un nodo */
/* tutti i nodi */
#define IS_NAME(n)		( P((n))->type & NT_IS_NAME  )
#define IS_VALUE(n)		( P((n))->type & NT_IS_VALUE )
#define IS_CONS(n)		( P((n))->type & NT_IS_CONS  )
#define IS_VALUE_AND_NUMBER(n)\
( (P((n))->type & (NT_IS_VALUE+NT_IS_NUMBER))==(NT_IS_VALUE+NT_IS_NUMBER) )

#define GET_NTYPE(n)            ( P((n))->type & NT_IS_MASK  )

#define MARK(n)			( P((n))->type|=NT_IS_MARK   )
#define UNMARK(n)		( P((n))->type&=NT_UNMARK    )
#define IS_MARK(n)		( P((n))->type & NT_IS_MARK  )

#define FIX(n)                  ( P((n))->type|=NT_IS_FIX    )
#define UNFIX(n)                ( P((n))->type&=NT_UNFIX     )
#define IS_FIX(n)               ( P((n))->type & NT_IS_FIX   )

#define REM(n)                  ( P((n))->type|=NT_IS_REM    )
#define UNREM(n)                ( P((n))->type&=NT_UNREM     )
#define IS_REM(n)               ( P((n))->type & NT_IS_REM   )

#define LOCK(n)                  ( P((n))->type|=NT_IS_LOCK   )
#define UNLOCK(n)                ( P((n))->type&=NT_UNLOCK    )
#define IS_LOCK(n)               ( P((n))->type & NT_IS_LOCK  )

/* solo nodi con nome */
#define HAS_NAME(n)             ( P((n))->type & NT_HAS_NAME )
#define HAS_VALUE(n)            ( P((n))->type & NT_HAS_VALUE )
#define HAS_PLIST(n)            ( P((n))->type & NT_HAS_PLIST )
#define HAS_BIND(n)             ( P((n))->type & NT_HAS_BIND )
#define HAS_FUNCTION(n)         ( P((n))->type & NT_HAS_FUNCTION )
#define HAS_CLASS(n)            ( P((n))->type & NT_HAS_CLASS )
#define HAS_SOMETHING(n)        ( P((n))->type & (NT_HAS_VALUE+NT_HAS_PLIST+NT_HAS_BIND+NT_HAS_FUNCTION+NT_HAS_CLASS))

/* solo nodi valore */
#define TRACE(n)                ( P((n))->type|=NT_IS_TRACE  )
#define UNTRACE(n)              ( P((n))->type&=NT_UNTRACE   )
#define IS_TRACE(n)             ( P((n))->type & NT_IS_TRACE )

#define GET_VTYPE(n)            ( P((n))->type & NT_MASK     )

#define IS_NODEBIND(n)          ( P((n))->type & NT_IS_NODEBIND )

#define IS_NUMBER(n)            ( P((n))->type & NT_IS_NUMBER )
/*=======================================================================*/


/*======================= FIELD MACRO ===================================*/
/* macro per accedere ai campi di un nodo */
/* tutti i nodi */
#define TYPE(n)			( P((n))->type )
#define NEXT(n)			( P((n))->next )
#define NEXTLOCK(n)		( P((n))->nextlock)

/*nodo con nome */
#define NAME(n)                 ( P((n))->body.nname.name )
#define HASH(n)                 ( P((n))->body.nname.hash )
#define VALUE(n)                ( P((n))->body.nname.value )
#define FUNCTION(n)             ( P((n))->body.nname.func )
#define PLIST(n)                ( P((n))->body.nname.plist )
#define CLASS(n)                ( P((n))->body.nname.class )

/* nodo cons */
#define CONSLEFT(n)             ( P((n))->body.ncons.left )
#define CONSRIGHT(n)            ( P((n))->body.ncons.right )

/* nodo valore */
#define REAL(n)                 ( P((n))->body.nvalue.real )
#define INTEGER(n)              ( P((n))->body.nvalue.integer )
#define RATIO_NUM(n)            ( P((n))->body.nvalue.ratio.num )
#define RATIO_DEN(n)            ( P((n))->body.nvalue.ratio.den )
#define STRING(n)               ( P((n))->body.nvalue.string )
#define SYSFUNC(n)              ( P((n))->body.nvalue.sysfunc )
#define UFUNC_TYPE(n)           ( P((n))->body.nvalue.userfunc.params_type )
#define UFUNC_PAR(n)            ( P((n))->body.nvalue.userfunc.params )
#define UFUNC_SEX(n)            ( P((n))->body.nvalue.userfunc.sexprs )
#define UFUNC_ENV(n)            ( P((n))->body.nvalue.userfunc.environment )
#define UFUNC_OPT(n)            ( P((n))->body.nvalue.userfunc.optionals )
#define UFUNC_REST(n)           ( P((n))->body.nvalue.userfunc.rest )
#define UFUNC_KEY(n)            ( P((n))->body.nvalue.userfunc.key )
#define UFUNC_AUX(n)            ( P((n))->body.nvalue.userfunc.aux )
#define ENAME(n)                ( P((n))->body.nvalue.node )
#define CNAME(n)                ( P((n))->body.nvalue.node )
#define NODE(n)                 ( P((n))->body.nvalue.node )
#define METHOD(n)               ( P((n))->body.nvalue.node )
#define CLASS_INSTANCE(n)	 ( P((n))->body.nvalue.node )
#define ACCESSOR_NAME(n)        ( P((n))->body.nvalue.accessor.name )
#define ACCESSOR_FIELD(n)       ( P((n))->body.nvalue.accessor.field )
#define CHARACTER(n)            ( P((n))->body.nvalue.character )
#define STREAM(n)               ( P((n))->body.nvalue.stream )
#define COMPLEX_REAL(n)         ( P((n))->body.nvalue.complex.real )
#define COMPLEX_IMG(n)          ( P((n))->body.nvalue.complex.img )
/*=======================================================================*/







struct	lf_dialog_type{		/* struttura di un puntatore ad un nodo  */
	node	node;		/* il puntatore serve ad.es. se si fa	 */
	p_type	type;		/* un (setf (cdr l) 'atom) si capisce	 */
};				/* che e' necessario che cdr ritorni non */
				/* il nodo a destra di l ma tutto il cons */
				/* con il puntatore sul suo elemento a destra */

/* p-type ha 16 bit e indica a quale campo del nodo sta' puntando*/
/*      15      14      13      12      11      10      9       8       */


/*	 7	6	5	4	3	2	1	0 	*/
/*            cons   unb-name  name    --------ordinal type------	*/


#define P_ALLNODE		0x01	/* tutto il nodo */

#define P_VALUE			0x10 	/* puntano ai campi di un nodo nome */
#define P_PLIST			0x11
#define P_FUNC                  0x12
#define P_CLASS                 0x13

#define P_UNBOUNDFUNC		0x30
#define P_UNBOUNDVALUE		0x31
#define P_UNBOUNDPLIST          0x32
#define P_UNBOUNDCLASS          0x33

#define P_CONSLEFT              0x40    /* puntano ai campi di un nodo cons */
#define P_CONSRIGHT             0x41



struct config_s{			/* info di configurazione */
	unsigned long	nodes;
	unsigned long	strings;
	unsigned long	hashes;
	unsigned	bad_char_error;
	unsigned	max_id_lenght;
	unsigned	max_string_lenght;
	unsigned	case_sensitive;
	unsigned	gcbeep;
};


/************VARIABILI GLOBALI ISTANZIATE IN CLOSMAIN.C *********************/

extern struct config_s	config;		/* CLOS configuration */
extern node	nilhandler;		/* nodo NIL */
extern node	truehandler;            /* nodo T */
extern node	voidhandler;		/* nodo VOID */
extern FILE	*dribble_file;		/* capture-session file */
extern char	buf1[];			/* 3 scratch-pads */
extern char	buf2[];			/* di dimensione */
extern char	buf3[];			/* MAX_ID_LENGHT+1 */
extern jmp_buf  critical_jmp;		/* errori critici */
extern jmp_buf  break_jmp;		/* break-level */


/******************************** PROTOTIPI DELLE FUNZIONI *****************/

/* lispmain.c */
void	lisp_free();
void	lisp_main_loop();
node	eval_lisp_file();
int	skip_spaces_tabs_nwl();

/* closnode.c */
node    node_make_();
node	node_alloc();
node	node_scan();
int	node_malloc();
void	node_free();
node    node_getlastlock_();
void	node_signal();
void	node_gc();
node	node_lockreset();
void	node_count();
void	node_criticalgc();
node	node_scan_fix();

#ifdef __NOINLINE__
 node	node_make();
 node	node_lock();
 node	node_getlastlock();
#else
 extern node lastalloc_node;
 extern node lastlock_node;

#define node_make()							\
(									\
  P(NEXT(lastalloc_node))						\
  ?(									\
    lastalloc_node=NEXT(lastalloc_node),				\
    LOCK(lastalloc_node),                                               \
    NEXTLOCK(lastlock_node)=lastalloc_node,                             \
    lastlock_node=lastalloc_node                                        \
  )                                                                     \
  :(                                                                    \
    node_gc(),								\
    P(NEXT(lastalloc_node))						\
    ?(								        \
      lastalloc_node=NEXT(lastalloc_node),				\
      LOCK(lastalloc_node),                                             \
      NEXTLOCK(lastlock_node)=lastalloc_node,                           \
      lastlock_node=lastalloc_node                                      \
    )                                                                   \
    :(                                                                  \
      error(E_NOMEMNODES,ERR_MERROR|ERR_PVOID|ERR_TCRIT,NULL)		\
    )                                                                   \
  )                                                                     \
 )

#define node_lock(n)							\
 (                                                                      \
  FIX(n),                                                               \
  IS_LOCK(n)                                                            \
  ?(                                                                    \
    n                                                                   \
  ):                                                                    \
  (                                                                     \
   LOCK(n),                                                             \
   NEXTLOCK(lastlock_node)=n,                                           \
   lastlock_node=n                                                      \
  )                                                                     \
 )

#define node_getlastlock() lastlock_node
#endif


/* closstri.c */
char    *string_get();
char    *string_getconv();
str_t	string_put();
int	string_isallocable();
int	string_del();
int	string_gc();
int	string_malloc();
int	string_free();

/* closhash.c */
node	hash_search();
void    hash_put();
void	hash_del();
int	hash_malloc();
void	hash_free();
void	hash_stat();

/* closacc.c */
len_t   listlen_func();
node    list_dup();
node    calc_pointer();
int     find_in_alist();
node    put_in_alist();
int     chk_alist();
node	list_elt();
void 	internal_setf();
void 	internal_update_environment();

/* clos_lfl.c */
void    lambda_eval();
void    macro_eval();

/* clos_clm.c */
void    method_eval();
void    accessor_eval();

/* closfunc.c */
node 	fprint_func();
void	eval LF_PARAMSD;
node	eval_list();
node	eval_list_lc();
void    apply_func();

/* closyacc.c */
node	input_func();

/********************* PROTOTIPI DELLE FUNZIONI LISP ********************/

/* clos_lf1.c funzioni di sistema , di debug + funzioni varie OK*/
void lf_gc LF_PARAMSD;
void lf_exit LF_PARAMSD;
void lf_stacktrace LF_PARAMSD;
void lf_trace LF_PARAMSD;
void lf_untrace LF_PARAMSD;
void lf_gettime LF_PARAMSD;
void lf_oblist LF_PARAMSD;
void lf_fixlist LF_PARAMSD;
void lf_getlenv LF_PARAMSD;
void lf_getgenv LF_PARAMSD;
void lf_hashstat LF_PARAMSD;
void lf_break LF_PARAMSD;
void lf_continue LF_PARAMSD;
void lf_dribble LF_PARAMSD;

void lf_apply LF_PARAMSD;
void lf_funcall LF_PARAMSD;
void lf_mapcar LF_PARAMSD;
void lf_assoc LF_PARAMSD;
void lf_push LF_PARAMSD;
void lf_pop LF_PARAMSD;

/* clos_lf2.c funzioni principali OK*/
void lf_car LF_PARAMSD;
void lf_cdr LF_PARAMSD;
void lf_cons LF_PARAMSD;
void lf_quote LF_PARAMSD;
void lf_eval LF_PARAMSD;
void lf_cond LF_PARAMSD;
void lf_setf LF_PARAMSD;
void lf_set LF_PARAMSD;
void lf_append LF_PARAMSD;
void lf_nconc LF_PARAMSD;
void lf_list LF_PARAMSD;
void lf_last LF_PARAMSD;
void lf_elt LF_PARAMSD;
void lf_reverse LF_PARAMSD;
void lf_lenght LF_PARAMSD;
void lf_function LF_PARAMSD;
void lf_plist LF_PARAMSD;
void lf_defvar LF_PARAMSD;
void lf_defun LF_PARAMSD;
void lf_defmacro LF_PARAMSD;
void lf_backquote LF_PARAMSD;
void lf_name2str LF_PARAMSD;

/* clos_lf3 matematiche OK*/
void lf_sin LF_PARAMSD;
void lf_cos LF_PARAMSD;
void lf_tan LF_PARAMSD;
void lf_asin LF_PARAMSD;
void lf_acos LF_PARAMSD;
void lf_atan LF_PARAMSD;
void lf_sinh LF_PARAMSD;
void lf_cosh LF_PARAMSD;
void lf_tanh LF_PARAMSD;
void lf_exp LF_PARAMSD;
void lf_log LF_PARAMSD;
void lf_log10 LF_PARAMSD;
void lf_sqrt LF_PARAMSD;
void lf_plus LF_PARAMSD;
void lf_minus LF_PARAMSD;
void lf_mult LF_PARAMSD;
void lf_plusone LF_PARAMSD;
void lf_minusone LF_PARAMSD;
void lf_div LF_PARAMSD;
void lf_max LF_PARAMSD;
void lf_min LF_PARAMSD;
void lf_abs LF_PARAMSD;
void lf_rem LF_PARAMSD;
void lf_float LF_PARAMSD;
void lf_round LF_PARAMSD;

/* clos_lf4.c  manipolazione stringhe OK*/
void lf_str2name LF_PARAMSD;
void lf_str2real LF_PARAMSD;
void lf_str2int LF_PARAMSD;
void lf_str2ascii LF_PARAMSD;
void lf_strnum LF_PARAMSD;
void lf_strlen LF_PARAMSD;
void lf_strcat LF_PARAMSD;
void lf_strsub LF_PARAMSD;
void lf_stringeq LF_PARAMSD;
void lf_stringequal LF_PARAMSD;
void lf_stringp LF_PARAMSD;
void lf_strprintf LF_PARAMSD;

/* clos_lf5.c  predicati e funzioni logiche OK*/
void lf_less LF_PARAMSD;
void lf_great LF_PARAMSD;
void lf_not LF_PARAMSD;
void lf_atom LF_PARAMSD;
void lf_and LF_PARAMSD;
void lf_or LF_PARAMSD;
void lf_eq LF_PARAMSD;
void lf_endp LF_PARAMSD;
void lf_symbolp LF_PARAMSD;
void lf_numberp LF_PARAMSD;
void lf_consp LF_PARAMSD;
void lf_listp LF_PARAMSD;
void lf_iszero LF_PARAMSD;
void lf_s_less LF_PARAMSD;
void lf_minusp LF_PARAMSD;
void lf_plusp LF_PARAMSD;
void lf_oddp LF_PARAMSD;
void lf_evenp LF_PARAMSD;
void lf_numequal LF_PARAMSD;
void lf_functionp LF_PARAMSD;
void lf_equal LF_PARAMSD;
void lf_intp LF_PARAMSD;
void lf_realp LF_PARAMSD;
void lf_ratiop LF_PARAMSD;
void lf_cnamep LF_PARAMSD;
void lf_enamep LF_PARAMSD;
void lf_classp LF_PARAMSD;
void lf_sysfuncp LF_PARAMSD;
void lf_macrop LF_PARAMSD;
void lf_ufuncp LF_PARAMSD;
void lf_valuep LF_PARAMSD;
void lf_accessorp LF_PARAMSD;
void lf_methodp LF_PARAMSD;
void lf_streamp LF_PARAMSD;
void lf_if LF_PARAMSD;
void lf_when LF_PARAMSD;
void lf_unless LF_PARAMSD;

/* cls_lf6.c iteratori e modificatori di environment OK*/
void lf_return LF_PARAMSD;
void lf_loop LF_PARAMSD;
void lf_prog1 LF_PARAMSD;
void lf_progn LF_PARAMSD;
void lf_while LF_PARAMSD;
void lf_dotimes LF_PARAMSD;
void lf_dolist LF_PARAMSD;
void lf_let LF_PARAMSD;
void lf_letspecial LF_PARAMSD;
void lf_do LF_PARAMSD;
void lf_dospecial LF_PARAMSD;
void lf_prog LF_PARAMSD;
void lf_go LF_PARAMSD;

/* clos_lf7.c */
void    lf_lambda LF_PARAMSD;

/* clos_lf8.c */
void lf_graphpan LF_PARAMSD;
void lf_graphrot LF_PARAMSD;
void lf_graphzoom LF_PARAMSD;
void lf_rot3d LF_PARAMSD;
void lf_add3d LF_PARAMSD;
void lf_mul3d LF_PARAMSD;
void lf_sub3d LF_PARAMSD;
void lf_div3d LF_PARAMSD;

/* lisp_lf9.c File e Console I/O OK*/
void lf_fopen LF_PARAMSD;
void lf_fclose LF_PARAMSD;
void lf_fseek LF_PARAMSD;
void lf_ftell LF_PARAMSD;

void lf_feof LF_PARAMSD;
void lf_ferror LF_PARAMSD;
void lf_fclearerr LF_PARAMSD;

void lf_freadbyte LF_PARAMSD;
void lf_fwritebyte LF_PARAMSD;
void lf_fprint LF_PARAMSD;
void lf_finput LF_PARAMSD;
void lf_fscanf LF_PARAMSD;

void lf_print LF_PARAMSD;
void lf_input LF_PARAMSD;
void lf_load LF_PARAMSD;

void lf_readline LF_PARAMSD;
void lf_readchar LF_PARAMSD;
void lf_curpos LF_PARAMSD;
void lf_textcolor LF_PARAMSD;
void lf_cls LF_PARAMSD;


/* clos_lfg funzioni grafiche */
void lf_graphopen LF_PARAMSD;
void lf_graphclear LF_PARAMSD;
void lf_gpencolor LF_PARAMSD;
void lf_gpentick LF_PARAMSD;
void lf_gpentype LF_PARAMSD;
void lf_gbrushcolor LF_PARAMSD;
void lf_gbrushtype LF_PARAMSD;
void lf_gputpixel LF_PARAMSD;
void lf_ggetpixel LF_PARAMSD;
void lf_gmoveto LF_PARAMSD;
void lf_glineto LF_PARAMSD;
void lf_gfillpoly LF_PARAMSD;
void lf_gfillellipse LF_PARAMSD;
void lf_gfillsector LF_PARAMSD;
void lf_gouttext LF_PARAMSD;

/* clos_cl1.c */
void lf_defclass LF_PARAMSD;

/* clos_cl2.c */
void lf_defmethod LF_PARAMSD;
void lf_mkinstance LF_PARAMSD;





















