/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_lf6.c */

#include "clos.h"

#define LONGJMP_LOOP    1
#define LONGJMP_GO	2
void internal_update_environment();
void internal_setf();
void general_lf_let();
void general_lf_do();


/* iteratori e modificatori di environment ************************************/
/* RETURN , LOOP , PROG1 , PROGN , WHILE , LET , LET* , DO , DO* , PROG , GO  */
/******************************************************************************/


/************************************************************************/
/*         Variabili che campionano lo stato dell' interprete           */
/* all' ingresso di una funzione che ammette RETURN per uscire          */
jmp_buf  loop_jmp;		/* indirizzo di ritorno + stack-pointer */
int      loop_jmp_valid=FALSE;  /* l'indirizzo di ritorno  valido?     */
/* NB: deve venire azzerato quando si ritorna al top-level perche'      */
/*altrimenti una return salterebbe chissa'dove se e' chiamata  dopo     */
/*un errore in un loop o in un do 					*/
unsigned loop_jmp_flags;	/* flags di valutazione			*/
node_p   loop_jmp_nout;		/* valore specificato nella RETURN	*/
/************************************************************************/

jmp_buf	go_jmp;
int	go_jmp_valid=FALSE;
node	go_jmp_label;




void lf_return LF_PARAMS
{
 if(loop_jmp_valid){
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),&loop_jmp_nout,genv,lenv,loop_jmp_flags);
     longjmp(loop_jmp,LONGJMP_LOOP);
   }
   loop_jmp_nout.node=NIL;
   loop_jmp_nout.type=P_ALLNODE;
   longjmp(loop_jmp,LONGJMP_LOOP);
 }
 error(E_BADRETURN,ERR_MERROR|ERR_TBLVL|ERR_PVOID,NULL);
}

void lf_loop LF_PARAMS
{
 node k;

 node n=nin;
 jmp_buf  save_jmp;
 unsigned save_valid=loop_jmp_valid;
 unsigned save_flags=loop_jmp_flags;

 loop_jmp_valid=TRUE;
 loop_jmp_flags=fl;
 memcpy(save_jmp,loop_jmp,sizeof(jmp_buf));

 switch(setjmp(loop_jmp)){
     case LONGJMP_LOOP:
	 memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	 loop_jmp_valid=save_valid;
	 loop_jmp_flags=save_flags;
	 nout->node=loop_jmp_nout.node;
	 nout->type=loop_jmp_nout.type;
	 return;
 }
 k=node_getlastlock();
 for(;;){
   if(IS_CONS(n)){
     eval(CONSLEFT(n),nout,genv,lenv,EVAL_NORM);
     n=CONSRIGHT(n);
     continue;
   }
   n=nin;
   node_signal(k);    /* con questa chiamata si dice al gc che pu      */
		      /* distruggere tutti i nodi allocati dall' inizio */
		      /* del ciclo in poi */
 }
}

void lf_prog1 LF_PARAMS
{
 node_p ntrash;
 jmp_buf  save_jmp;
 unsigned save_valid=loop_jmp_valid;
 unsigned save_flags=loop_jmp_flags;

 loop_jmp_valid=TRUE;
 loop_jmp_flags=fl;
 memcpy(save_jmp,loop_jmp,sizeof(jmp_buf));

 switch(setjmp(loop_jmp)){
     case LONGJMP_LOOP:
	 memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	 loop_jmp_valid=save_valid;
	 loop_jmp_flags=save_flags;
	 nout->node=loop_jmp_nout.node;
	 nout->type=loop_jmp_nout.type;
	 return;
 }
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,fl);
   while(IS_CONS(nin=CONSRIGHT(nin))){
     eval(CONSLEFT(nin),&ntrash,genv,lenv,EVAL_NORM);
   }
   memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
   loop_jmp_valid=save_valid;
   loop_jmp_flags=save_flags;
   return;
 }

}

void lf_progn LF_PARAMS
{
 jmp_buf  save_jmp;
 unsigned save_valid=loop_jmp_valid;
 unsigned save_flags=loop_jmp_flags;

 loop_jmp_valid=TRUE;
 loop_jmp_flags=fl;
 memcpy(save_jmp,loop_jmp,sizeof(jmp_buf));

 switch(setjmp(loop_jmp)){
     case LONGJMP_LOOP:
	 memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	 loop_jmp_valid=save_valid;
	 loop_jmp_flags=save_flags;
	 nout->node=loop_jmp_nout.node;
	 nout->type=loop_jmp_nout.type;
	 return;
 }
 while(IS_CONS(CONSRIGHT(nin))){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=CONSRIGHT(nin);
 }
 eval(CONSLEFT(nin),nout,genv,lenv,fl);
 memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
 loop_jmp_valid=save_valid;
 loop_jmp_flags=save_flags;
}

void lf_while LF_PARAMS
{
 /* sintassi (while (test ret?) sx*) */
 /* valuta le sx finch test  non-NIL,ritorna ret (se non c' ritorna NIL)*/

 node test;
 node ret;
 node sx;
 node k;
 node n=nin;

 /* nin= ((test ret?) sx*) */
 if(IS_CONS(nin)){
   nin=CONSLEFT(nin);	/* nin=(test ret?) */
   if(IS_CONS(nin)){
     test=CONSLEFT(nin);
     nin=CONSRIGHT(nin); /* nin=(ret?) */
     if(IS_CONS(nin)){
       ret=CONSLEFT(nin);
     }else{
       ret=NIL;
     }
     k=node_getlastlock();
     for(;;){
       eval(test,nout,genv,lenv,EVAL_NORM);
       if(calc_pointer(nout)==NIL)break;
       sx=CONSRIGHT(n);
       while(IS_CONS(sx)){
	 eval(CONSLEFT(sx),nout,genv,lenv,EVAL_NORM);
	 sx=CONSRIGHT(sx); /* sx=(sx*) , n= ((test ret?) sx*) */
       }
       node_signal(k);
     }
     eval(ret,nout,genv,lenv,fl);
     return;
   }
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
}


void lf_dolist LF_PARAMS
{
 /* syntax (dolist  (counter intiform  sx?  )   sx*    )   */
 /*                                   zero    nonzero      */

 node zero_sx;
 node nonzero_sx;
 node name;
 node value;
 node l,k;
 node new_lenv=lenv;
 node new_genv=genv;

 jmp_buf  save_jmp;
 unsigned save_valid=loop_jmp_valid;
 unsigned save_flags=loop_jmp_flags;

 memcpy(save_jmp,loop_jmp,sizeof(jmp_buf));
 loop_jmp_valid=TRUE;
 loop_jmp_flags=fl;
 switch(setjmp(loop_jmp)){
     case LONGJMP_LOOP:
	 memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	 loop_jmp_valid=save_valid;
         loop_jmp_flags=save_flags;
	 nout->node=loop_jmp_nout.node;
	 nout->type=loop_jmp_nout.type;
	 return;
 }
 k=node_getlastlock();

 /* nin= ( (counter-name initform   sx*   ) {sx}* ) */
 /*                                 zero   nonzero  */

 if(IS_CONS(nin)){
   if(IS_CONS(l=CONSLEFT(nin))){ /* l=(counter initform sx*) */
     name=CONSLEFT(l);
     if(IS_NAME(name)&&HAS_NAME(name)){
       if(IS_CONS(l=CONSRIGHT(l))){           /* l=(initform sx*)  */
	 eval(CONSLEFT(l),nout,genv,lenv,EVAL_NORM);
	 value=calc_pointer(nout);
	 if(IS_CONS(value) || value==NIL){
	   if(IS_CONS(l=CONSRIGHT(l))){ /* l=(sx*) */
	     zero_sx=CONSLEFT(l);
	   }else{
	     zero_sx=NIL;
	   }
	   internal_update_environment(name,NIL,&new_genv,&new_lenv);
	   k=node_getlastlock();
	   while(IS_CONS(value)){
	     internal_setf(name,CONSLEFT(value),new_genv,new_lenv);
	     nonzero_sx=CONSRIGHT(nin);
	     while(IS_CONS(nonzero_sx)){
	       eval(CONSLEFT(nonzero_sx),nout,new_genv,new_lenv,EVAL_NORM);
	       nonzero_sx=CONSRIGHT(nonzero_sx);
	     }
	     value=CONSRIGHT(value);
	     node_signal(k);
	   }
	   internal_setf(name,value,new_genv,new_lenv);
	   eval(zero_sx,nout,new_genv,new_lenv,fl);

	   loop_jmp_valid=save_valid;
	   loop_jmp_flags=save_flags;
	   memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	   return;
	 }
	 error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&value);
       }
       error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&CONSLEFT(nin));
     }
     error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&name);
   }
   error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}


void lf_dotimes LF_PARAMS
{
 /* syntax (dotimes (counter intiform  sx?  )   sx*    )   */
 /*                                   zero    nonzero      */
 /* Conta da 0 a initform-1 */

 node zero_sx;
 node nonzero_sx;
 node name;
 node value;
 node l,k;
 node new_genv=genv;
 node new_lenv=lenv;
 n_int limit;

 jmp_buf  save_jmp;
 unsigned save_valid=loop_jmp_valid;
 unsigned save_flags=loop_jmp_flags;

 memcpy(save_jmp,loop_jmp,sizeof(jmp_buf));
 loop_jmp_valid=TRUE;
 loop_jmp_flags=fl;
 switch(setjmp(loop_jmp)){
     case LONGJMP_LOOP:
	 memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	 loop_jmp_valid=save_valid;
	 loop_jmp_flags=save_flags;
	 nout->node=loop_jmp_nout.node;
	 nout->type=loop_jmp_nout.type;
	 return;
 }

 /* nin= ( (counter-name initform   sx*   ) {sx}* ) */
 /*                                 zero   nonzero  */

 if(IS_CONS(nin)){
   if(IS_CONS(l=CONSLEFT(nin))){ /* l=(counter initform sx*) */
     name=CONSLEFT(l);
     if(IS_NAME(name)&&HAS_NAME(name)){
       if(IS_CONS(l=CONSRIGHT(l))){           /* l=(initform sx*)  */
	 eval(CONSLEFT(l),nout,genv,lenv,EVAL_NORM);
	 value=calc_pointer(nout);
	 if(IS_VALUE(value) && GET_VTYPE(value)==NT_INTEGER && INTEGER(value)>=0){
	   limit=INTEGER(value);
	   value=node_make();
	   TYPE(value)|=NT_IS_VALUE+NT_INTEGER;
	   INTEGER(value)=0;
	   if(IS_CONS(l=CONSRIGHT(l))){ /* l=(sx*) */
	     zero_sx=CONSLEFT(l);
	   }else{
	     zero_sx=NIL;
	   }
	   internal_update_environment(name,value,&new_genv,&new_lenv);

	   k=node_getlastlock();
	   while(INTEGER(value)!=limit){
	     nonzero_sx=CONSRIGHT(nin);
	     while(IS_CONS(nonzero_sx)){
	       eval(CONSLEFT(nonzero_sx),nout,new_genv,new_lenv,EVAL_NORM);
	       nonzero_sx=CONSRIGHT(nonzero_sx);
	     }
	     INTEGER(value)++;
	     internal_setf(name,value,new_genv,new_lenv);
	     /* perche' si potrebbe modificare il valore di 'name' */
	     /* nelle espressioni valutate */
	     node_signal(k);
	   }
	   eval(zero_sx,nout,new_genv,new_lenv,fl);

	   loop_jmp_valid=save_valid;
	   loop_jmp_flags=save_flags;
	   memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	   return;
	 }
	 error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&value);
       }
       error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&CONSLEFT(nin));
     }
     error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&name);
   }
   error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}




#define LET_NORMAL  1
#define LET_SPECIAL 0

void lf_let LF_PARAMS
{
 general_lf_let(nin,nout,genv,lenv,fl,LET_NORMAL);
}

void lf_letspecial LF_PARAMS
{
 general_lf_let(nin,nout,genv,lenv,fl,LET_SPECIAL);
}

void general_lf_let (nin,nout,genv,lenv,fl,let_flag)
node nin;
node_p *nout;
node genv;
node lenv;
unsigned fl;
unsigned let_flag;
{
 /* sintassi (LET [ ( {(p v) | p}* ) ] sx+  ) */
 /* NB: se si ha (LET () sx+) l'atomo () cioe' NIL viene valutato */
 /* come una s-espressione ma cio' non causa problemi */

 node new_genv=genv;
 node new_lenv=lenv;
 node parl,name,value;

 if(IS_CONS(nin)){
   if(IS_CONS(parl=CONSLEFT(nin))){
     if(IS_CONS(CONSRIGHT(nin))){
       nin=CONSRIGHT(nin);
       while(IS_CONS(parl)){
	 value=CONSLEFT(parl);
	 if(IS_CONS(value)){
	   name=CONSLEFT(value);
	   value=CONSRIGHT(value);
	   if(IS_CONS(value)){
	     value=CONSLEFT(value);
	   }
	   if(let_flag)
	     eval(value,nout,genv,lenv,EVAL_NORM);
	   else{
	     eval(value,nout,new_genv,new_lenv,EVAL_NORM);
	   }
	   value=calc_pointer(nout);
	 }else{
	   name=value;
	   value=NIL;
	 }
	 if(IS_NAME(name)&&HAS_NAME(name))
	   internal_update_environment(name,value,&new_genv,&new_lenv);
	 else
	   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&name);
	 parl=CONSRIGHT(parl);
       }
     }else{
       error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
     }
   }
   /* nin e' sicuramente un cons */
   while(IS_CONS(CONSRIGHT(nin))){
     eval(CONSLEFT(nin),nout,new_genv,new_lenv,EVAL_NORM);
     nin=CONSRIGHT(nin);
   }
   eval(CONSLEFT(nin),nout,new_genv,new_lenv,fl);
   return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}



#define DO_NORMAL  1
#define DO_SPECIAL 0

void lf_do LF_PARAMS
{
 general_lf_do(nin,nout,genv,lenv,fl,DO_NORMAL);
}

void lf_dospecial LF_PARAMS
{
 general_lf_do(nin,nout,genv,lenv,fl,DO_SPECIAL);
}

void general_lf_do(nin,nout,genv,lenv,fl,do_flag)
node nin;
node_p *nout;
node genv;
node lenv;
unsigned fl;
unsigned do_flag;
{
 node name,value;
 node new_lenv,new_genv;
 node parlist,parl;
 node curr,test;
 node zero_sx,nonzero_sx;
 node k;

 jmp_buf  save_jmp;
 unsigned save_valid=loop_jmp_valid;
 unsigned save_flags=loop_jmp_flags;

 memcpy(save_jmp,loop_jmp,sizeof(jmp_buf));
 loop_jmp_valid=TRUE;
 loop_jmp_flags=fl;
 switch(setjmp(loop_jmp)){
     case LONGJMP_LOOP:
	 memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	 loop_jmp_valid=save_valid;
	 loop_jmp_flags=save_flags;
	 nout->node=loop_jmp_nout.node;
	 nout->type=loop_jmp_nout.type;
	 return;
 }

 new_lenv=lenv;
 new_genv=genv;

 /* sintassi (do ( (varname initvalue step)* ) (endtest sx*) sx*) */
 if(IS_CONS(nin)){
   parlist=parl=CONSLEFT(nin);
   if(IS_CONS(nin=CONSRIGHT(nin))){   /*nin=( (endtest sx*) sx*)*/
     if(IS_CONS(test=CONSLEFT(nin))){
       nonzero_sx=CONSRIGHT(nin);
       zero_sx=CONSRIGHT(test);
       test=CONSLEFT(test);
       /* creazione dell' environment */
       while(IS_CONS(parl)){
	 if(IS_CONS(curr=CONSLEFT(parl))){
	   name=CONSLEFT(curr);
	   if(IS_CONS(curr=CONSRIGHT(curr))){
	     if(do_flag==DO_NORMAL)
	       eval(CONSLEFT(curr),nout,genv,lenv,EVAL_NORM);
	     else{
	       eval(CONSLEFT(curr),nout,new_genv,new_lenv,EVAL_NORM);
	     }
	     value=calc_pointer(nout);
	     if(IS_CONS(CONSRIGHT(curr))){
	       if(IS_NAME(name)&&HAS_NAME(name)){
		 internal_update_environment(name,value,&new_genv,&new_lenv);
		 parl=CONSRIGHT(parl);
		 continue;
	       }
	       error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&name);
	     }
	   }
	 }
	 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&curr);
       }

       k=node_getlastlock();
       /* main-loop */
       for(;;){
	 lenv=new_lenv;
	 genv=new_genv;

	 node_lock(new_genv);
	 node_lock(new_lenv);

	 eval(test,nout,genv,lenv,EVAL_NORM);
	 if(calc_pointer(nout)!=NIL)
	   break;
	 curr=nonzero_sx;
	 while(IS_CONS(curr)){
	   eval(CONSLEFT(curr),nout,genv,lenv,EVAL_NORM);
	   curr=CONSRIGHT(curr);
	 }
	 /* update-environment */
	 parl=parlist;
	 while(IS_CONS(parl)){
	   if(do_flag==DO_NORMAL){
	     eval
		( CONSLEFT(CONSRIGHT(CONSRIGHT(curr=CONSLEFT(parl))))
		,nout,genv,lenv,EVAL_NORM);
	   }else{
	     eval
		( CONSLEFT(CONSRIGHT(CONSRIGHT(curr=CONSLEFT(parl))))
		,nout,new_genv,new_lenv,EVAL_NORM);
	   }
	   internal_update_environment
	     (CONSLEFT(curr),calc_pointer(nout),&new_genv,&new_lenv);

	   parl=CONSRIGHT(parl);
	 }
	 /* si dice al garbage collector che puo' distruggere tutti i nodi */
	 /* fin qui' allocati (tranne l'environment) */
	 node_signal(k);

       }
       /* exit */
       if(IS_CONS(zero_sx)){
	 while(IS_CONS(CONSRIGHT(zero_sx))){
	   eval(CONSLEFT(zero_sx),nout,new_genv,new_lenv,EVAL_NORM);
	   zero_sx=CONSRIGHT(zero_sx);
	 }
	 eval(CONSLEFT(zero_sx),nout,new_genv,new_lenv,fl);
       }else{
	 nout->node=NIL;
	 nout->type=P_ALLNODE;
       }
       loop_jmp_valid=save_valid;
       loop_jmp_flags=save_flags;
       memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
       return;
     }
   }
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}









/* Sintassi (PROG ( (Nome Valore) ) s-espressioni ) */

void lf_prog LF_PARAMS
{
 node new_genv=genv;
 node new_lenv=lenv;
 node parl,name,value;

 node sxs,k;
 BOOL found;

 jmp_buf  save_jmp;
 unsigned save_valid=loop_jmp_valid;
 unsigned save_flags=loop_jmp_flags;

 jmp_buf  save_go_jmp;
 unsigned save_go_valid=go_jmp_valid;

 loop_jmp_valid=TRUE;
 loop_jmp_flags=fl;
 memcpy(save_jmp,loop_jmp,sizeof(jmp_buf));

 switch(setjmp(loop_jmp)){
     case LONGJMP_LOOP:
	 memcpy(loop_jmp,save_jmp,sizeof(jmp_buf));
	 loop_jmp_valid=save_valid;
	 loop_jmp_flags=save_flags;
	 nout->node=loop_jmp_nout.node;
	 nout->type=loop_jmp_nout.type;

	 memcpy(go_jmp,save_go_jmp,sizeof(jmp_buf));
	 go_jmp_valid=save_go_valid;

	 return;
 }

 if(IS_CONS(nin)){
   parl=CONSLEFT(nin);
   if(IS_CONS(parl)){
     nin=CONSRIGHT(nin);
     while(IS_CONS(parl)){
       value=CONSLEFT(parl);
       if(IS_CONS(value)){
	 name=CONSLEFT(value);
	 value=CONSRIGHT(value);
	 if(IS_CONS(value)){
	   value=CONSLEFT(value);
	 }
	 eval(value,nout,genv,lenv,EVAL_NORM);
	 value=calc_pointer(nout);
       }else{
	 name=value;
	 value=NIL;
       }
       if(IS_NAME(name)&&HAS_NAME(name))
	 internal_update_environment(name,value,&new_genv,&new_lenv);
       else
	 error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&name);
       parl=CONSRIGHT(parl);
     }
   }
   go_jmp_valid=TRUE;
   memcpy(save_go_jmp,go_jmp,sizeof(jmp_buf));

   k=node_getlastlock();

   switch(setjmp(go_jmp)){
     case LONGJMP_GO:
	 /* Cerca le sxs con go_jmp_label */
	 sxs=nin;
	 found=FALSE;
	 while(IS_CONS(sxs) && !found){
	   found=(CONSLEFT(sxs)==go_jmp_label);
	   sxs=CONSRIGHT(sxs);
	 }
	 if(!found)
	   error(E_BADLABEL,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&go_jmp_label);
	 break;
     default:
	 sxs=nin;
   }
   node_signal(k);
   nout->node=NIL;
   nout->type=P_ALLNODE;
   while(IS_CONS(sxs)){
     /* non valuta i nomi dato che sono delle label */
     if(!IS_NAME(CONSLEFT(sxs)))
       eval(CONSLEFT(sxs),nout,new_genv,new_lenv,EVAL_NORM);
     sxs=CONSRIGHT(sxs);
   }
   memcpy(go_jmp,save_go_jmp,sizeof(jmp_buf));
   go_jmp_valid=save_go_valid;
   return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}


void lf_go LF_PARAMS
{
 if(go_jmp_valid){
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_SETF);
     go_jmp_label=nout->node;
     if(IS_NAME(go_jmp_label)){
       longjmp(go_jmp,LONGJMP_GO);
     }
     go_jmp_label=calc_pointer(nout);
     if(IS_NAME(go_jmp_label)){
       longjmp(go_jmp,LONGJMP_GO);
     }
     error(E_BADLABEL,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&go_jmp_label);
   }
 }
 error(E_BADGO,ERR_MERROR|ERR_TBLVL|ERR_PVOID,NULL);
}
