
(defun listn(n)
        (if(not(=0 n))
                (cons n (listn(1- n)))
		nil
        )
)

(defvar l18 (listn 18))
(defvar l12 (listn 12))
(defvar l6  (listn  6))

(defun mas (x y z)
        (if (not (shorterp y x))
		z	
                (mas (mas (cdr x) y z)
                     (mas (cdr y) z x)
                     (mas (cdr z) x y)
		)
	)
)

(defun shorterp (x y)
        (and y (or (null x)
                (shorterp (cdr x) (cdr y]

(defun takl (x y z)
  (setf l18 (listn x))
  (setf l12 (listn y))
  (setf l6  (listn z))
  (mas l18 l12 l6)
)

(defun test-takl(&optional (x 18)(y 12)(z 6) &aux time taklr)
	(setf time (get-time))
	(setf taklr (takl x y z))
	(print 
                "TAKL ha ritornato " taklr
                " Con :\nx="x"\ny="y"\nz="z
		"\nTempo impiegato (in millisecondi) <" (- (get-time) time) ">\n"
	)
	'ok
)
(print "TAKL test\n")
(print "Uso: (test-takl n3 n2 n1)\n")
(print "     usare per n1,n2,n3 dei numeri crescenti\n")
(print "     secondo un certo fattore ,di solito 5 o 6\n")
(print " es: (test-takl 15 10 5)\n")
(print " (test-takl) senza parametri e' equivalente a\n")
(print "   (test-takl 18 12 6)\n")

