(******************************************************************************)
(* Copyright (c) 1988 by GMD Karlruhe, Germany				      *)
(* Gesellschaft fuer Mathematik und Datenverarbeitung			      *)
(* (German National Research Center for Computer Science)		      *)
(* Forschungsstelle fuer Programmstrukturen an Universitaet Karlsruhe	      *)
(* All rights reserved.							      *)
(* Don't modify this file under any circumstances			      *)
(******************************************************************************)

FOREIGN MODULE ErrNumbers;

   PROCEDURE ErrNo () : SHORTCARD;
      (* Returnes the error number set by system calls *)

   CONST
      ePERM    = 1;         (* Not super-user *)
      eNOENT   = 2;         (* No such file or directory *)
      eSRCH    = 3;         (* No such process *)
      eINTR    = 4;         (* interrupted system call *)
      eIO      = 5;         (* I/O error *)
      eNXIO    = 6;         (* No such device or address *)
      e2BIG    = 7;         (* Arg list too long *)
      eNOEXEC  = 8;         (* Exec format error *)
      eBADF    = 9;         (* Bad file number *)
      eCHILD   = 10;        (* No children *)
      eAGAIN   = 11;        (* No more processes *)
      eNOMEM   = 12;        (* Not enough core *)
      eACCES   = 13;        (* Permission denied *)
      eFAULT   = 14;        (* Bad address *)
      eNOTBLK  = 15;        (* Block device required *)
      eBUSY    = 16;        (* Mount device busy *)
      eEXIST   = 17;        (* File exists *)
      eXDEV    = 18;        (* Cross-device link *)
      eNODEV   = 19;        (* No such device *)
      eNOTDIR  = 20;        (* Not a directory *)
      eISDIR   = 21;        (* Is a directory *)
      eINVAL   = 22;        (* Invalid argument *)
      eNFILE   = 23;        (* File table overflow *)
      eMFILE   = 24;        (* Too many open files *)
      eNOTTY   = 25;        (* Not a typewriter *)
      eTXTBSY  = 26;        (* Text file busy *)
      eFBIG    = 27;        (* File too large *)
      eNOSPC   = 28;        (* No space left on device *)
      eSPIPE   = 29;        (* Illegal seek *)
      eROFS    = 30;        (* Read only file system *)
      eMLINK   = 31;        (* Too many links *)
      ePIPE    = 32;        (* Broken pipe *)
      eDOM     = 33;        (* Math arg out of domain of func *)
      eRANGE   = 34;        (* Math result not representable *)
      eNOMSG   = 35;        (* No message of desired type *)
      eIDRM    = 36;        (* Identifier removed *)
      eCHRNG   = 37;        (* Channel number out of range *)
      eL2NSYNC = 38;        (* Level 2 not synchronized *)
      eL3HLT   = 39;        (* Level 3 halted *)
      eL3RST   = 40;        (* Level 3 reset *)
      eLNRNG   = 41;        (* Link number out of range *)
      eUNATCH  = 42;        (* Protocol driver not attached *)
      eNOCSI   = 43;        (* No CSI structure available *)
      eL2HLT   = 44;        (* Level 2 halted *)
      eNOSWP   = 45;        (* Out of swap space *)
      eXPATH   = 46;        (* Path continues onto another machine *)
      eXREDO   = 47;        (* Unison request for a retry *)
      eDEADLK  = 48;        (* Record locking deadlock *)
      eNOUARP  = 49;        (* Could not resolve IP addr, host down *)
      eNOUGW   = 50;        (* No available gateway in route table *)
      eLOOP    = 51;        (* symbolic links form endless loop *)

END ErrNumbers.
