MODULE ImagesBundle;
(* Generated by m3bundle; see its manpage. *)

IMPORT Bundle, BundleRep, Text;
IMPORT Thread, Wr, TextWr;

TYPE T = Bundle.T OBJECT OVERRIDES get := LookUp END;

VAR bundle: T := NIL;

PROCEDURE Get(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE LookUp (<*UNUSED*> self: T;  element: TEXT): TEXT = 
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        IF Elements[i] = NIL THEN Elements[i] := GetElt (i) END;
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..1] OF TEXT {
  "sendImage.ps",
  NIL
};

VAR Elements := ARRAY [0..1] OF TEXT {
  NIL (* E0 .. E0_1 *),
  NIL
};

PROCEDURE GetElt (n: INTEGER): TEXT =
  <*FATAL Thread.Alerted, Wr.Failure *>
  VAR wr := TextWr.New ();
  BEGIN
    CASE n OF
    | 0 =>
        Wr.PutText (wr, E0);
        Wr.PutText (wr, E0_0);
        Wr.PutText (wr, E0_1);
    ELSE (*skip*)
    END;
    RETURN TextWr.ToText (wr);
  END GetElt;

CONST E0 = 
   "% *************************************************\n% Lectern: sendIma"
 & "ge.ps\n% Andrew D. Birrell\n% Copyright 1994, Digital Equipment Corpora"
 & "tion.  All rights reserved.\n% ****************************************"
 & "*********\n\n% *************************************************\n% Thi"
 & "s is library code to render an image; use it by appending a line such a"
 & "s:\n%\n%\011100 850 1100 false raw\n%\n% or:\n%\n%\011300 2550 3300 fal"
 & "se 1 lgm\n%\n% followed by the data for the image in appropriate format"
 & ".\n%\n% The image data will be rendered with its bottom-left at (0,0), "
 & "scaled as if\n% user coordinates are the default, 1 unit = 1/72 inch.  "
 & "The image data should\n% be a sequence of left-to-right scan lines, in "
 & "top-to-bottom order.\n% ***********************************************"
 & "**\n\n40 dict begin % matching \"end\" is within \"raw\" or \"lgm\"\n\n"
 & "/level2 % true iff interpreter supports level 2 PostScript\n\011systemd"
 & "ict /languagelevel known { languagelevel 2 ge } { false } ifelse\n\011d"
 & "ef\n\n/line % buffer for reading the data\n\0111024 string def % length"
 & " is known by application, for padding data\n\n/hexSource % source proce"
 & "dure for data encoded as hexadecimal\n\011{ currentfile line readhexstr"
 & "ing pop } def\n\n/binarySource % source procedure for data in raw binar"
 & "y\n\011{ currentfile line readstring pop } def\n\n\n% *****************"
 & "********************************\n% Uncompressed images\n% ************"
 & "*************************************\n\n/raw { % dpi width height bina"
 & "ry\n\011/source exch { /binarySource } { /hexSource } ifelse load def\n"
 & "\011/h exch def\n\011/w exch def\n\011/ratio exch 72 div def\n\011w h 1"
 & " [ratio 0 0 ratio neg 0 h] /source load\n\011image\n\011end\n\011} def\n"
 & "\n\n% *************************************************\n% LGM compress"
 & "ed gray-scale or black & white images (Lectern Gray Map)\n% Note: this "
 & "image format is Digital Equipment Corporation proprietary\n% **********"
 & "***************************************\n\n%\n% Action procedures for p"
 & "ixelsPerGroup=8. On entry stack has: h byte.\n%\n/zero8\011\011{ 159 su"
 & "b pixels h zero 0 4 index getinterval putinterval\n\011\011h add ";

CONST E0_0 = 
   "/h exch def } bind def\n/zeroEsc8\011{ pop nextByte 174 add zero8 } bin"
 & "d def\n/prev8\011\011{ 174 sub h add /h exch def } bind def\n/prevEsc8\011"
 & "{ pop nextByte 189 add prev8 } bind def\n/literal8\011{ pixels h 255 4 "
 & "-1 roll sub put /h h 1 add def } bind def\n/literalEsc8\011{ pop nextBy"
 & "te literal8 } bind def\n/actions8 256 array def\011\011\011\011% indexe"
 & "d by data byte\n\0110 1 159\011\011{ actions8 exch /literal8 load put }"
 & " for\n\011160 1 173\011{ actions8 exch /zero8 load put } for\n\011174\011"
 & "\011actions8 exch /zeroEsc8 load put\n\011175 1 188\011{ actions8 exch "
 & "/prev8 load put } for\n\011189\011\011actions8 exch /prevEsc8 load put\n"
 & "\011190\011\011actions8 exch/literalEsc8 load put\n\011191\011\011actio"
 & "ns8 exch { h 3 0 div } put\n\011192 1 255\011{ actions8 exch /literal8 "
 & "load put } for\n\n%\n% Action procedures for pixelsPerGroup # 8. On ent"
 & "ry stack has data byte.\n%\n/zeroX\011\011{ 159 sub pixels h zero 0 4 i"
 & "ndex\n\011\011pixelsPerGroup mul getinterval putinterval\n\011\011pixel"
 & "sPerGroup mul h add /h exch def } bind def\n/zeroEscX\011{ pop nextByte"
 & " 174 add zeroX } bind def\n/prevX\011\011{ 174 sub pixelsPerGroup mul h"
 & " add /h exch def } bind def\n/prevEscX\011{ pop nextByte 189 add prevX "
 & "} bind def\n/literalX\011{ pixels h 255 c levels mod 255 mul maxVal idi"
 & "v sub put\n\011\011/h h 1 add def\n\011\011pixels h 255 c levels idiv 2"
 & "55 mul maxVal idiv sub put\n\011\011/h h 1 add def } bind def\n/literal"
 & "EscX\011{ pop nextByte literalX } bind def\n/actionsX 256 array def\011"
 & "\011\011\011% indexed by data byte\n\0110 1 159\011\011{ actionsX exch "
 & "/literalX load put } for\n\011160 1 173\011{ actionsX exch /zeroX load "
 & "put } for\n\011174\011\011actionsX exch /zeroEscX load put\n\011175 1 1"
 & "88\011{ actionsX exch /prevX load put } for\n\011189\011\011actionsX ex"
 & "ch /prevEscX load put\n\011190\011\011actionsX exch /literalEscX load p"
 & "ut\n\011191\011\011actionsX exch { h 2 0 div } put\n\011192 1 255\011{ "
 & "actionsX exch /literalX load put } for\n\n%\n% Image source that decomp"
 & "resses LGM format data, one scan-line per call.\n%\n\n/decompress {\n\011"
 & "/h 0 def\n\011/nextByte { %stack: data dataPos\n\011\0112 copy exch len"
 & "gth ge { pop pop source 0 } if\n\011\0111 add\n\011\0112 copy 1 sub get"
 & "\n\011\011} def\n\011data dataPos\n\011pixelsPerGroup 8 eq {\n\011\011{"
 & "\n\011\011\011h pixelsLength ge { exit } if\n\011\011\011";

CONST E0_1 = 
   "nextByte actions8 1 index get exec\n\011\011\011} loop\n\011\011} {\n\011"
 & "\011{\011h pixelsLength ge { exit } if\n\011\011\011nextByte actionsX 1"
 & " index get exec\n\011\011\011} loop\n\011\011} ifelse\n\011/dataPos exc"
 & "h def\n\011/data exch def\n\011pixels\n\011} bind def\n\n%\n% Main cont"
 & "rol for imaging from LGM data\n%\n/lgm {\011% dpi width height binary m"
 & "axVal\n\011/maxVal exch def\n\011/source exch { /binarySource } { /hexS"
 & "ource } ifelse load def\n\011/levels maxVal 1 add def\n\011/pixelsPerGr"
 & "oup maxVal dup 1 le {\n\011\011pop 8\n\011\011} {\n\011\011dup 2 le {\n"
 & "\011\011\011pop 5\n\011\011\011} {\n\011\011\011dup 3 le {\n\011\011\011"
 & "\011pop 4\n\011\011\011\011} {\n\011\011\011\011dup 5 le {\n\011\011\011"
 & "\011\011pop 3\n\011\011\011\011\011} {\n\011\011\011\011\01115 le { 2 }"
 & " { 1 } ifelse\n\011\011\011\011\011} ifelse\n\011\011\011\011} ifelse\n"
 & "\011\011\011} ifelse\n\011\011} ifelse def\n\011/bitsPerPixel pixelsPer"
 & "Group 8 eq { 1 } { 8 } ifelse def\n\011/height exch def\n\011/width exc"
 & "h def\n\011/ratio exch 72 div def\n\011/pixelsLength width bitsPerPixel"
 & " mul 8 idiv def\n\011/pixels pixelsLength string def\n\011/zero pixelsL"
 & "ength string def\n\011\0110 1 zero length 1 sub { zero exch 255 put } f"
 & "or\n\011/dataPos 0 def\n\011/data 0 string def\n\011width height bitsPe"
 & "rPixel [ratio 0 0 ratio neg 0 height]\n\011/decompress load\n\011image\n"
 & "\011end\n\011} def\n\n";


BEGIN
END ImagesBundle.
