(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)
(*                                                             *)
(* Last modified on Fri Nov 18 17:40:10 PST 1994 by kalsow     *)
(*      modified on Mon Mar 11 23:31:37 1991 by muller         *)

UNSAFE INTERFACE RTException;

(* This interface provides access to the runtime machinery that
   raises exceptions.  The values of the types defined in this
   interface are generated by the compiler.  Changing any of the
   types below is dangerous. *)

TYPE
  ExceptionName = UNTRACED REF UNTRACED REF (*ARRAY OF*) CHAR;
  ExceptionList = UNTRACED REF (*ARRAY OF*) ExceptionName;
  ExceptionArg  = ADDRESS; (* actually, it's an untyped 4-byte field *)

PROCEDURE Raise (ex: ExceptionName;  arg: ExceptionArg) RAISES ANY;
(* raise the exception ex passing arg as the associated value *)

PROCEDURE ResumeRaise (ex: ExceptionName;  arg: ExceptionArg) RAISES ANY;
(* after a TRY-FINALLY handler has been executed, restart the processing
   of the execption. It is known that there is a handler for this exception *)

PROCEDURE DumpStack ();
(* If possible, produce a diagnostic stack dump on stderr *)

END RTException.

