MODULE MetaSynBdl;
(* Generated by m3bundle; see its manpage. *)

IMPORT Bundle, BundleRep, Text;

TYPE T = Bundle.T OBJECT OVERRIDES get := LookUp END;

VAR bundle: T := NIL;

PROCEDURE Get(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE LookUp (<*UNUSED*> self: T;  element: TEXT): TEXT = 
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..2] OF TEXT {
  "ExtendGram",
  "MetaGram",
  NIL
};

CONST Elements = ARRAY [0..2] OF TEXT {
  E0,
  E1,
  NIL
};

CONST E0 = 
   "(* Grammar file for extensible grammars, using MPTreeSubst as their\n  "
 & " substitution\011routine *)\n\ngrammar ::=\n     clauseSeq\nclauseSeq :"
 & ":=\n     [ \011gramExpIde _1\n        paramList_5\n\011\"::=\" \n\011cl"
 & "auseExtends_2 \n\011gramExp_3\n\011clauseRest_4 \n\011] :: ClauseList\n"
 & "clauseRest ::=\n     { clauseSeq [] }\nclauseExtends ::=\n     { [ \".\""
 & " \".\" \".\" \n        { [ \"*\" { [ \"_\" int_3 ] :: ClauseExtendsIter"
 & "Pos \n\011          []            :: ClauseExtendsIterNoPos \n         "
 & "       }_2 ]  :: ClauseExtendsIter \n          []           :: ClauseEx"
 & "tendsChoice\n        }_1 \n       ]   :: ClauseExtendsYes\n       []  :"
 & ": ClauseExtendsNo\n     }\n\n\n\nparamList ::= { [ \"<\" paramList2_1 \""
 & ">\" ]::select1 [] }\nparamList2 ::= { [ \"_\" int_1 { [ \",\" paramList"
 & "2_2 ]::select2 [] }_2 ]::cons [] }\n\n\n(*34567890123456789012345678901"
 & "23456789012345678901234567890*)\n(*       1         2         3        "
 & " 4         5          *)\n\ngramExp ::=\n     [ gramExpBase_1 \n\011{ ["
 & " \"_\" int_3 ]::Storage \n          [ ExtendAction<_1>_2 ] :: select2\n"
 & "          []::select1 }_2 \n     ]::select2\n\n\ngramExpBase ::=\n     "
 & "{ [ ide_1 paramList_2 ] :: GramIde\n       string_1              :: Gra"
 & "mString\n       \"ide\"                 :: GramKeyIde\n       \"int\"  "
 & "               :: GramKeyInt\n       \"EOF\"                 :: GramKey"
 & "Eof\n       \"real\"                :: GramKeyReal\n       \"char\"    "
 & "            :: GramKeyChar\n       \"string\"              :: GramKeySt"
 & "ring \n       gramExpSequence \n       gramExpChoice   \n       gramExp"
 & "Parens \n     }\n\ngramExpIde ::=\n     ide_1 :: Ide\n\n\ngramExpSequen"
 & "ce ::=\n     [ \"[\" gramExpList_1 \"]\" ]   :: GramExpSequence\n  \ngr"
 & "amExpChoice ::=\n     [ \"{\" gramExpList_1 \"}\" ] :: GramExpChoice\n "
 & " \ngramExpParens ::=\n     [ \"(\" gramExp_1\n     { [ \"*\" { [ \"_\" "
 & "int_4 gramExp_3  ] :: GramExpIterPos\n               gramExp_3         "
 & "       :: GramExpIterNoPos  \n             }_5 ]  :: GramExpIter\n     "
 & "  []           :: GramExpBase   }_6\n     \")\" ]  :: GramExpParens\n  "
 & "\ngramExpList ::=\n     { [ gramExp_1 gramExpList_2 ]::GramList [] }\n\n"
 & "\n\n\n\n\n\n";

CONST E1 = 
   "grammar ::=\n     clauseSeq\nclauseSeq ::=\n     [ \011gramExpIde _1\n\011"
 & "\"::=\" \n\011clauseExtends_2 \n\011gramExp_3\n\011clauseRest_4 \n\011]"
 & " :: ClauseList\nclauseRest ::=\n     { \"EOF\" clauseSeq  }\nclauseExte"
 & "nds ::=\n     { [ \".\" \".\" \".\" \n        { [ \"*\" { [ \"_\" int_3"
 & " ] :: ClauseExtendsIterPos \n\011          []            :: ClauseExten"
 & "dIterNoPos \n                }_2 ]  :: ClauseExtendsIter \n          []"
 & "           :: ClauseExtendsChoice\n        }_1 \n       ]   :: ClauseEx"
 & "tendsYes\n       []  :: ClauseExtendsNo\n     }_1\n\ngramExpIde ::=\n  "
 & "   ide\n\ngramExp ::=\n     [ gramExpBase_1 \n\011{ [ \"_\" int_3 ]::St"
 & "orage [ \"::\" sum_3 ]::caction []::select1 }_2 \n     ]::select2\n\n\n"
 & "gramExpBase ::=\n     { ide_1    :: GramIde\n       string_1 :: GramStr"
 & "ing\n       \"ide\"    :: GramKeyIde\n       \"int\"    :: GramKeyInt\n"
 & "       \"EOF\"    :: GramKeyEof\n       \"real\"   :: GramKeyReal\n    "
 & "   \"char\"   :: GramKeyChar\n       \"string\" :: GramKeyString \n    "
 & "   gramExpSequence \n       gramExpChoice   \n       gramExpParens \n  "
 & "   }\n\ngramExpSequence ::=\n     [ \"[\" gramExpList \"]\" ]   :: Gram"
 & "ExpSequence\n  \ngramExpChoice ::=\n     [ \"{\" gramExpList_1 \"}\" ] "
 & ":: GramExpChoice\n  \ngramExpParens ::=\n     [ \"(\" gramExp_1\n     {"
 & " [ \"*\" { [ \"_\" int_4 gramExp_3  ] :: GramExpIterPos\n              "
 & " gramExp_3                :: GramExpIterNoPos  \n             }_5 ]  ::"
 & " GramExpIter\n       []           :: GramExpBase   }_6\n     \")\" ]  :"
 & ": GramExpParens\n  \ngramExpList ::=\n     { [ gramExp_1 gramExpList_2 "
 & "]::GramList [] }\n  \n  \n\n\n";


BEGIN
END MetaSynBdl.
