MODULE ObliqBdl2;
(* Generated by m3bundle; see its manpage. *)

IMPORT Bundle, BundleRep, Text;
IMPORT Thread, Wr, TextWr;

TYPE T = Bundle.T OBJECT OVERRIDES get := LookUp END;

VAR bundle: T := NIL;

PROCEDURE Get(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE LookUp (<*UNUSED*> self: T;  element: TEXT): TEXT = 
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        IF Elements[i] = NIL THEN Elements[i] := GetElt (i) END;
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..24] OF TEXT {
  "ObliqHelpZeus",
  "ObliqHelpArray",
  "ObliqHelpGraph",
  "ObliqHelpColor",
  "ObliqHelpThread",
  "ObliqHelpChar",
  "ObliqHelpMath",
  "ObliqHelpProcess",
  "ObliqHelpLex",
  "ObliqHelpSys",
  "ObliqHelpOnline",
  "ObliqHelpFmt",
  "ObliqSyntax",
  "ObliqLexicon",
  "ObliqHelpNet",
  "ObliqHelpRd",
  "ObliqHelpPickle",
  "ObliqHelpText",
  "ObliqHelpBool",
  "ObliqHelpForm",
  "ObliqHelpRects",
  "ObliqHelpReal",
  "ObliqHelpInt",
  "ObliqHelpWr",
  NIL
};

VAR Elements := ARRAY [0..24] OF TEXT {
  E0,
  E1,
  NIL (* E2 .. E2_1 *),
  E3,
  E4,
  E5,
  E6,
  E7,
  E8,
  E9,
  E10,
  E11,
  NIL (* E12 .. E12_0 *),
  E13,
  E14,
  E15,
  E16,
  NIL (* E17 .. E17_0 *),
  E18,
  NIL (* E19 .. E19_1 *),
  E20,
  NIL (* E21 .. E21_0 *),
  E22,
  E23,
  NIL
};

PROCEDURE GetElt (n: INTEGER): TEXT =
  <*FATAL Thread.Alerted, Wr.Failure *>
  VAR wr := TextWr.New ();
  BEGIN
    CASE n OF
    | 2 =>
        Wr.PutText (wr, E2);
        Wr.PutText (wr, E2_0);
        Wr.PutText (wr, E2_1);
    | 12 =>
        Wr.PutText (wr, E12);
        Wr.PutText (wr, E12_0);
    | 17 =>
        Wr.PutText (wr, E17);
        Wr.PutText (wr, E17_0);
    | 19 =>
        Wr.PutText (wr, E19);
        Wr.PutText (wr, E19_0);
        Wr.PutText (wr, E19_1);
    | 21 =>
        Wr.PutText (wr, E21);
        Wr.PutText (wr, E21_0);
    ELSE (*skip*)
    END;
    RETURN TextWr.ToText (wr);
  END GetElt;

CONST E0 = 
   "  zeus_failure: Exception\n  zeus_animate(g: Graph, t0: Real, t1: Real)"
 & ": Ok\n";

CONST E1 = 
   "  [e1, ..., en]: [T]\n    (for e1...en: T)\n  All(T) array_new(size: In"
 & "t, init: T): [T]\n    An array of size \'size\', all filled with \'init"
 & "\'.\n  All(T) array_gen(size: Int, proc: (Int)->T): [T]\n    An array o"
 & "f size \'size\', filled with \'proc(i)\' for \'i\' between \'0\' and \n"
 & "    \'size-1\'.\n  All(T) array_#(a: [T]): Int ! net_failure\n    (also"
 & " \'#(a)\') Size of an array.\n  All(T) array_get(a: [T], i: Int): T ! n"
 & "et_failure\n    (also \'a[i]\') The i-th element (if it exists), zero-b"
 & "ased.\n  All(T) array_set(a: [T], i: Int, b: T): Ok ! net_failure\n    "
 & "(also \'a[i]:=b\') Update the i-th element (if it exists).\n  All(T) ar"
 & "ray_sub(a: [T], i: Int, n: Int): [T] ! net_failure\n    (also \'a[i for"
 & " n]\') A new array, filled with the elements of \'a\' beginning \n    a"
 & "t \'i\', and of size \'n\' (if it exists).\n  All(T) array_upd(a: [T], "
 & "i: Int, n: Int, b: [T]): Ok ! net_failure\011\n    (also \'a[i for n]:="
 & "b\') Same as \'a[n+i]:=b[n]; ... ; a[i]:=b[0]\'. \n    I.e. \'a[i for n"
 & "]\' gets \'b[0 for n]\'.\n  All(T) array_@(a1: [T], a2: [T]): [T] ! net"
 & "_failure\n    (also infix \'@\') A new array, filled with the concatena"
 & "tion of the elements \n    of \'a1\' and \'a2\'.\n";

CONST E2 = 
   "  graph_failure: Exception \n  graph_new(): Graph \n  graph_redisplay(g"
 & ": Graph): Ok \n  graph_animate(g: Graph, t0:Real, t1: Real): Ok \n  gra"
 & "ph_clear(g: Graph): Ok \n  graph_setWorld(g: Graph, w: Real, e: Real, n"
 & ": Real, s: Real): Ok \n  graph_setMargin(g: Graph, margin: Real): Ok \n"
 & "  graph_setAspect(g: Graph, aspect: Real): Ok \n  graph_setPreferredSiz"
 & "e(g: Graph, h: Real, v: Real): Ok \n  graph_setPixelSizeDivisor(g: Grap"
 & "h, h: Real, v: Int): Ok \n  graph_verticesAt(g: Graph, w: Real, e: Real"
 & ", n: Real, s: Real): [Vertex] \n  graph_vertexHiLisAt(g: Graph, w: Real"
 & ", e: Real, n: Real, s: Real): [VertexHiLi]\n  graph_edgesAt(g: Graph, w"
 & ": Real, e: Real, n: Real, s: Real): [Edge] \n  graph_polygonsAt(g: Grap"
 & "h, w: Real, e: Real, n: Real, s: Real): [Polygon] \n  graph_setClickAct"
 & "ion(g: Graph, p: (Graph,Real,Real)->Ok): Ok \n    set the procedure to "
 & "be invoked on single AND double down mouse transitions\n  graph_setClic"
 & "kReleaseAction(g: Graph, p: (Graph,Real,Real)->Ok): Ok \n    set the pr"
 & "ocedure to be invoked on up mouse transitions\n  graph_setDoubleClickAc"
 & "tion(g: Graph, p: (Graph,Real,Real)->Ok): Ok \n    set the procedure to"
 & " be invoked on double down mouse transitions\n  \n  graph_newVertex(g: "
 & "Graph): Vertex \n  graph_moveVertex(v: Vertex, x: Real, y: Real, animat"
 & "e: Bool): Ok \n  graph_moveVertexOnPath(v: Vertex, path: (Real)->[2*Rea"
 & "l]): Ok \n  graph_removeVertex(v: Vertex): Ok \n  graph_vertexToFront(v"
 & ": Vertex): Ok \n  graph_vertexToBack(v: Vertex): Ok \n  graph_setVertex"
 & "Size(v: Vertex, h: Real, v: Real): Ok \n  graph_setVertexShape(v: Verte"
 & "x, shape: Text): Ok \n     (shape is \"rectangle\" or \"ellipse\") \n  "
 & "graph_setVertexColor(v: Vertex, c: Color): Ok \n  graph_setVertexFont(v"
 & ": Vertex, f: Font): Ok \n  graph_setVertexLabel(v: Vertex, label: Text)"
 & ": Ok \n  graph_setVertexLabelColor(v: Vertex, c: Color}): Ok \n  graph_"
 & "setVertexBorder(v: Vertex, border: Real): Ok \n  graph_setVertexBorderC"
 & "olor(v: Vertex, c: Color): Ok \n  graph_getVertexPosition(v: Vertex): ["
 & "2*Real] \n  \n  graph_newVertexHiLi(v: Vertex): Vertex";

CONST E2_0 = 
   "HiLi \n  graph_moveVertexHiLi(vh: VertexHiLi, v: Vertex, animate: Bool)"
 & ": Ok \n  graph_removeVertexHiLi(vh: VertexHiLi): Ok \n  graph_vertexHiL"
 & "iToFront(vh: VertexHiLi): Ok \n  graph_vertexHiLiToBack(vh: VertexHiLi)"
 & ": Ok \n  graph_setVertexHiLiColor(vh: VertexHiLi, c: Color): Ok \n  gra"
 & "ph_setVertexHiLiBorder(vh: VertexHiLi, h v: Real): Ok \n  graph_getVert"
 & "exHiLiVertex(vh: VertexHiLi): Vertex \n  \n  graph_newEdge(v1:Vertex, v"
 & "2: Vertex): Edge \n  graph_moveEdge(e: Edge, v1: Vertex, v2: Vertex, an"
 & "imate: Bool): Ok \n  graph_moveEdgeBezier(e: Edge, v1: Vertex, v2: Vert"
 & "ex, c1: Vertex, c2: Vertex,\n    animate: Bool): Ok \n  graph_removeEdg"
 & "e(e: Edge): Ok \n  graph_edgeToFront(e: Edge): Ok \n  graph_edgeToBack("
 & "e: Edge): Ok \n  graph_setEdgeWidth(e: Edge, width: Real): Ok \n  graph"
 & "_setEdgeColor(e: Edge, c: Color): Ok \n  graph_setEdgeArrows(e: Edge, a"
 & "rrowAtV1: Bool, arrowAtV2: Bool): Ok \n  graph_getEdgeVertices(e: Edge)"
 & ": [2*Vertex] \n  graph_getEdgeControls(e: Edge): [Vertex]\n    (returns"
 & " 0 or 2 vertices) \n  \n  graph_newPolygon(vs: [Vertex]): Polygon \n  g"
 & "raph_movePolygon(p: Polygon, vs: [Vertex], animate: Bool): Ok \n  graph"
 & "_removePolygon(p: Polygon): Ok \n  graph_polygonToFront(p: Polygon): Ok"
 & " \n  graph_polygonToBack(p: Polygon): Ok \n  graph_setPolygonColor(p: P"
 & "olygon, c: Color): Ok \n  \n  graph_newFont(g: Graph, family: Text, siz"
 & "e: Real, \n                slant: Text, weight: Text, foundry: Text): F"
 & "ont \n    (family is \"Helvetica\"...; normal size is 0.0353; slant is "
 & "\"Roman\",\n    \"Italic\", \"Oblique\", \"ReverseItalic\", \"ReverseOb"
 & "lique\", \"Other\", \"Any\"; \n     weight is \"bold\"...; foundry is \""
 & "*\"... \n  graph_defaultFont: Font \n  \n  graph_newSpectrum(g: Graph):"
 & " Spectrum \n    a spectrum is an animatable color; it is a legal color "
 & "\n  graph_setSpectrumColor(s: Spectrum, c: Color): Ok \n    set the vis"
 & "ible-right-now color of the spectrum \n  graph_setSpectrumRange(s: Spec"
 & "trum, range: (Real)->Color): Ok \n    set the color range for future an"
 & "imations; domain in 0.0..1.0 \n  \n  graph_show(g: Graph): Ok \n  graph"
 & "_hide";

CONST E2_1 = 
   "(g: Graph): Ok \n  \n  Some(T<:{}) graph_setObjectLayer(o: T, layer: In"
 & "t): Ok \n    Don\'t use this call! layer= 0(fore), 1(normal), 2(back) \n"
;

CONST E3 = 
   "  color_named(name: Text): Color\n    Get a color from its name (see th"
 & "e ColorName M3 interface).\n  color_rgb(r: Real, g: Real, b: Real): Col"
 & "or\n    Get a color from rgb (each 0.0 .. 1.0).\n  color_hsv(hr: Real, "
 & "sr: Real, v: Real): Color\n    Get a color from hsv (each 0.0 .. 1.0).\n"
 & "  color_r(c: Color): Real\n    The red color component.\n  color_g(c: C"
 & "olor): Real\n    The green color component.\n  color_b(c: Color): Real\n"
 & "    The blue color component.\n  color_h(c: Color): Real\n    The hue c"
 & "olor component.\n  color_s(c: Color): Real\n    The saturation color co"
 & "mponent.\n  color_v(c: Color): Real\n    The value color component.\n  "
 & "color_brightness(c: Color): Real\n    The total brightness (0.0 .. 1.0)"
 & ".\n";

CONST E4 = 
   "  thread_mutex(): Mutex\n    (also \'mutex()\') A new mutex.\n  thread_"
 & "condition(): Condition\n    (also \'condition()\') A new condition.\n  "
 & "Some(T) thread_self(): Thread(T)\n    The current thread.\n  All(T) thr"
 & "ead_fork(f: ()->T, stackSize: Int): Thread(T)\n    (also \'fork(f,n)\')"
 & " Fork a new thread executing f. If stackSize is zero, a \n    small def"
 & "ault size is used.\n  All(T) thread_join(th: Thread(T)): T\n    (also \'"
 & "join(th)\') Wait for a thread to complete, and return the result of \n "
 & "   its procedure.\n  thread_wait(mx: Mutex, cd: Condition): Ok\n    (al"
 & "so \'wait(mx,cd)\') Wait on a mutex and a condition.\n  thread_acquire("
 & "mx: Mutex): Ok\n    Acquire a mutex (use lock ... end instead).\n  thre"
 & "ad_release(mx: Mutex): Ok\n    Release a mutex (use lock ... end instea"
 & "d)\n  thread_broadcast(cd: Condition): Ok\n    (also \'broadcast(cd)\')"
 & " Wake-up to all threads waiting on a condition. \n  thread_signal(cd: C"
 & "ondition): Ok\n    (also \'signal(cd)\') Wake-up at least one thread wa"
 & "iting on a condition.\n  thread_pause(r: Real): Ok\n    (also \'pause(r"
 & ")\') Pause the current thread for r seconds.\n  All(T) thread_lock(m: M"
 & "utex, body: ()->T): T\n    Execute under a locked mutex (use lock ... e"
 & "nd instead).\n  thread_alerted: Exception\n    (See the threads spec.)\n"
 & "  All(T) thread_alert(t: Thread(T)): Ok\n    (See the threads spec.)\n "
 & " thread_testAlert(): Bool\n    (See the threads spec.)\n  thread_alertW"
 & "ait(mx: Mutex, cd: Condition): Ok ! thread_alerted\n    (See the thread"
 & "s spec.)\n  All(T) thread_alertJoin(th: Thread(T)): Ok ! thread_alerted"
 & "\n    (See the threads spec.)\n  thread_alertPause(r: Real): Ok ! threa"
 & "d_alerted\n    (See the threads spec.)\n";

CONST E5 = 
   "  c: Char\n    A character in single quotes.\n  ascii_char(n: Int): Cha"
 & "r\n    The ascii character of integer code \'n\'.\n  ascii_val(c: Char)"
 & ": Int\011\n    The integer code of the ascii character \'c\'.\n";

CONST E6 = 
   "  math_pi: Real\n    3.1415926535897932384626433833.\n  math_e: Real\n "
 & "   2.7182818284590452353602874714.\n  math_degree: Real\n    0.01745329"
 & "2519943295769236907684; 1 degree in radiants.\n  math_exp(n: Real): Rea"
 & "l\n    e to the n-th power.\n  math_log(n: Real): Real\n    log base e."
 & "\n  math_sqrt(n: Real): Real\n    Square root.\n  math_hypot(n: Real, m"
 & ": Real): Real\n    sqrt((n*n)+(m*m)).\n  math_pow(n: Real, m: Real): Re"
 & "al\n    n to the m-th power.\n  math_cos(n: Real): Real\n    Cosine in "
 & "radians.\n  math_sin(n: Real): Real\n    Sine in radians.\n  math_tan(n"
 & ": Real): Real\n    Tangent in radians.\n  math_acos(n: Real): Real\n   "
 & " Arc cosine in radians.\n  math_asin(n: Real): Real\n    Arc sine in ra"
 & "dians.\n  math_atan(n: Real): Real\n    Arc tangent in radians.\n  math"
 & "_atan2(n: Real, m: Real): Real\n    Arc tangent of n/m in radians.\n";

CONST E7 = 
   "  process_new(pr: Processor, nameAndArgs: [Text], mergeOut: Bool): Proc"
 & "ess\n    Create a process from a processor and the given process name a"
 & "nd arguments.\n    The local processor is available as the lexically sc"
 & "oped identifier \n    \"processor\". If mergeOut is true, use a single "
 & "pipe for stdout and stderr.\n  process_in(p: Process): Wr\n    The stdi"
 & "n pipe of a process.\n  process_out(p: Process): Rd\n    The stdout pip"
 & "e of a process.\n  process_err(p: Process): Rd\n    The stderr pipe of "
 & "a process.\n  process_complete(p: Process): Int\n    Wait for the proce"
 & "ss to exit, close all its pipes, and return the exit code.\n  process_f"
 & "ilter(pr: Processor, nameAndArgs: [Text], input: Text): Text \n    ! ne"
 & "t_failure\n    Create a process from a processor and the given process "
 & "name and arguments.\n    The local processor is available as the lexica"
 & "lly scoped identifier \n    \"processor\". The stderr output is merged "
 & "to stdout.\n    Usage: feed the input to its stdin pipe and close it; r"
 & "ead all the output\n    from its stdout pipe and close it; return the o"
 & "utput.\n";

CONST E8 = 
   "  lex_failure: Exception\n  lex_scan(r: Rd, t: Text): Text ! rd_failure"
 & " thread_alerted\n    Read from r the longest prefix formed of character"
 & "s listed in t, and return \n    it.\n  lex_skip(r: Rd, t: Text): Ok ! r"
 & "d_failure thread_alerted\n    Read from r the longest prefix formed of "
 & "characters listed in t, and discard \n    it.\n  lex_match(r: Rd, t: Te"
 & "xt): Ok ! lex_failure rd_failure thread_alerted\n    Read from r the st"
 & "ring t and discard it; raise failure if not found.\n  lex_bool(r: Rd): "
 & "Bool ! lex_failure rd_failure thread_alerted\n    Skip blanks, and atte"
 & "mpt to read a boolean from r.\n  lex_int(r: Rd): Int ! lex_failure rd_f"
 & "ailure thread_alerted\n    Skip blanks, and attempt to read an integer "
 & "from r.\n  lex_real(r: Rd): Real ! lex_failure rd_failure thread_alerte"
 & "d\n    Skip blanks, and attempt to read a real from r.\n";

CONST E9 = 
   "  All(T) sys_copy(x: T): T ! net_failure\n    (also \'copy(x)\') Make a"
 & " local copy of a value, including most distributed \n    values.\n  sys"
 & "_getEnvVar(t: Text): Text\n    Return the value of the env variable who"
 & "se name is t, or \"\" if there is no \n    such variable.\n  sys_paramC"
 & "ount: Int\n    The number of program parameters.\n  sys_getParam(n: Int"
 & "): Text\n    Return the n-th program parameter (indexed from 0).\n  sys"
 & "_callFailure: Exception\n    Can be raised by Modula-3 code during a sy"
 & "s_call.\n  Some(T)Some(U) sys_call(name: Text, args: [T]): U ! sys_call"
 & "Failure\n    Call a pre-registered Modula-3 procedure.\n";

CONST E10 = 
   "  All(T) sys_print(x: T, depth: Int): Ok\n    Print an arbitrary value "
 & "to stdout, up to some print depth. (Only available \n    on-line.)\n  s"
 & "ys_printText(t: Text): Ok\n    Print a text to stdout. (Only available "
 & "on-line.)\n  sys_printFlush(): Ok\n    Flush stdout. (Only available on"
 & "-line.)\n  sys_pushSilence(): Ok\n    Push the silence stack; when non-"
 & "empty nothing is printed. (Only available \n    on-line.)\n  sys_popSil"
 & "ence(): Ok\n    Pop the silence stack (no-op on empty stack). (Only ava"
 & "ilable on-line.)\n  sys_setPrompt(first: Text, next: Text): Ok\n    Set"
 & " the interactive prompts (defaults: first=\"- \", next=\"  \"). (Only \n"
 & "    available on-line.)\n  sys_getSearchPath(): Text\n    Get the curre"
 & "nt search path for \'load\' and such. (Only available on-line.)\n  sys_"
 & "setSearchPath(t: Text): Ok\n    Set the current search path for \'load\'"
 & " and such. (Only available on-line.)\n";

CONST E11 = 
   "  fmt_padLft(t: Text, length: Int): Text\n    If t is shorted then leng"
 & "th, pad t with blanks on the left so that it has \n    the given length"
 & ".\n  fmt_padRht(t: Text, length: Int): Text\n    If t is shorted then l"
 & "ength, pad t with blanks on the right so that it has \n    the given le"
 & "ngth.\n  fmt_bool(b: Bool): Text\n    Convert a boolean to its printabl"
 & "e form.\n  fmt_int(n: Int): Text\n    Convert an integer to its printab"
 & "le form.\n  fmt_real(r: Real): Text\n    Convert a real to its printabl"
 & "e form.\n";

CONST E12 = 
   "TOP-LEVEL PHRASES                    \011any term or definition ended b"
 & "y \";\"\n  a;                                 \011\n\nDEFINITIONS (iden"
 & "tifiers are denoted by \"x\", terms are denoted by \"a\")\n  let x1=a1,"
 & "...,xn=an                \011definition of constant identifiers\n  let "
 & "rec x1=a1,...,xn=an            \011definition of recursive procedures\n"
 & "  var x1=a1,...,xn=an                \011definition of updatable identi"
 & "fiers\n\nSEQUENCES (denoted by \"s\")           \011each \"ai\" (a term"
 & " or a definition) is\n  a1;...;an                          \011executed"
 & "; yields \"an\" (or \"ok\" if n=0)\n\nTERMS (denoted by \"a\",\"b\",\"c"
 & "\"; identifiers are denoted by \"x\",\"l\"; modules are denoted by \"m\""
 & ")\n  x\011m_x                      \011identifiers\n  x:=a             "
 & "                  \011assignment\n\n  ok  true  false  \'a\'  \"abc\"  "
 & "3  1.5\011constants\n\n  [a1,...,an]                     \011arrays\n  "
 & "a[b]\011a[b]:=c               \011        array selection, array update"
 & "\n  a[b for b\']\011a[b for b\']:=c        \011subarray selection, suba"
 & "rray update\n\n  option l => s end              \011term \"s\" tagged b"
 & "y \"l\"\n\n  proc(x1,...,xn) s end              \011procedures\n  a(b1,"
 & "...,bn)                       \011procedure invocation\n  m_x(a1,...,an"
 & ")                     \011invocation of \"x\" from module \"m\"\n  a b "
 & "c                              \011infix (right-ass.) version of \"b(a,"
 & "c)\"\n\n  meth(x,x1,...,xn) s end            \011method with self \"x\""
 & "\n  {l1=>a1,...,ln=>an}                \011object with fields named \"l"
 & "1\"...\"ln\"\n  {protected, serialized, ...}           \011protected an"
 & "d serialized object\n  {l1=>alias l2 of a2 end,...}        \011object w"
 & "ith delegated fields\n  a.l    a.l(a1, ..., an)            \011field se"
 & "lection / method invocation\n  a.l:=b                             \011f"
 & "ield update / method override\n  clone(a1,...,an)                      "
 & "object cloning\n  a1.l1:=alias l2 of a2 end             field delegatio"
 & "n\n  delegate a1 to a2 end \011        object delegation\n\n  d        "
 & "                          \011definition\n  if s1 then s2              "
 & "        \011conditional\n    elsif s3 then s4..";

CONST E12_0 = 
   ". else sn end  \011  (\"elsif\", \"else\" optional)\n  a andif b\011a o"
 & "rif b             \011conditional conjunction/disjunction\n  case s of "
 & "l1(x1)=>s1,...,               case over the tag \"li\" of an option\n  "
 & "  ln(xn)=>sn else s0 end     \011          binding \"xi\" in \"si\" (\""
 & "else\" optional)\n  loop s end                         \011loop\n  for "
 & "i=a to b do s end              \011iteration through successive integer"
 & "s\n  foreach i in a do s end            \011iteration through an array\n"
 & "  foreach i in a map s end           \011yielding an array of the resul"
 & "ts\n  exit                               \011exit the innermost loop, f"
 & "or, foreach\n\n  exception(\"exc\")                   \011new exception"
 & " value named \"exc\"\n  raise(a)                           \011raise an"
 & " exception\n  try s except                       \011exception capture\n"
 & "    a1=>s1,...,an=>sn else s0 end     \011  (\"else\" optional)\n  try "
 & "s1 finally s2 end                \011finalization\n\n  condition()  sig"
 & "nal(a)  broadcast(a)\011creating and signaling a condition\n  watch s1 "
 & "until s2 end                \011waiting for a signal and a boolean guar"
 & "d\n  fork(a1,a2)    join(a)\011        forking and joining a thread\n  "
 & "pause(a)\011                        pausing the current thread \n\n  mu"
 & "tex()\011                        creating a mutex\n  lock s1 do s2 end "
 & "               \011locking a mutex in a scope\n  wait(a1,a2)           "
 & "     \011        waiting on a mutex for a condition\n\n  (s)           "
 & "                     \011block structure / precedence group\n";

CONST E13 = 
   "The ASCII characters are divided into the following classes:\n\n  Blank"
 & "         HT LF FF CR SP\n  Reserved      \" \' ~\n  Delimiter     ( ) ,"
 & " . ; [ ] _ { } ? !\n  Special       # $ % & * + - / : < = > @ \\ ^ |\n "
 & " Digit         0 ... 9\n  Letter        A ... Z ` a ... z\n  Illegal   "
 & "    all the others\n\nMoreover:\n\n  a StringChar is either\n  - any si"
 & "ngle character that is not an Illegal character or one of \', \", \\.\n"
 & "  - any of the pairs of characters \\\', \\\", \\\\.\n\n  a Comment is,"
 & " recursively, a sequence of non-Illegal characters and comments, \n  en"
 & "closed between \"(*\" and \"*)\".\n\nFrom these, the following lexemes "
 & "are formed:\n\n  Space     a sequence of Blanks and Comments.\n  AlphaN"
 & "um  a sequence of Letters and Digits starting with a Letter.\n  Symbol "
 & "   a sequence of Specials.\n  Char      a single StringChar enclosed be"
 & "tween two \'.\n  String    a sequence of StringChars enclosed between t"
 & "wo \".\n  Int       a sequence of Digits, possibly preceded by a single"
 & " minus sign ~.\n  Real      two Ints separated by ., possibly preceded "
 & "by ~.\n  Delimiter a single Delimiter character.\n\nA stream of charact"
 & "ers is split into lexemes by always extracting the longest \nprefix tha"
 & "t is a lexeme. Note that Delimiters do not stick to each other or to\no"
 & "ther tokens even when they are not separated by Space, but some care mu"
 & "st be \ntaken so that Symbols are not inadvertently merged.\n\nA token "
 & "is either a Char, String, Int, Real, Delimiter, Identifier, or Keyword."
 & "\nOnce a stream of characters has been split into lexemes, tokens are e"
 & "xtracted\nas follows. \n\n  Space lexemes do not produce tokens.\n  Cha"
 & "r, String, Int, Real, and Delimiter lexemes are also tokens.\n  AlphaNu"
 & "m and Symbol lexemes are Identifier tokens, except when they have been\n"
 & "    explicitly declared to be keywords, in which case they are Keyword "
 & "tokens.\n";

CONST E14 = 
   "  net_failure: Exception\n  All(T)  net_who(o: T): Text ! net_failure t"
 & "hread_alerted\n    Return a text indicating where a network object or e"
 & "ngine is registered, or \n    the empty text if the argument is an obje"
 & "ct that has not been registered \n    with a name server.\n  All(T<:{})"
 & " net_export(name: Text, server: Text, o: T): T \n    ! net_failure thre"
 & "ad_alerted\n    Export an object under name \'name\', to the name serve"
 & "r at IP address \n    \'server\'. The empty text denotes the local IP a"
 & "ddress.\n  Some(T<:{}) net_import(name: Text, server: Text): T \n    ! "
 & "net_failure thread_alerted\n    Import the object of name \'name\', fro"
 & "m the name server at IP address \n    \'server\'. The empty text denote"
 & "s the local IP address.\n  All(T) net_exportEngine(name: Text, server: "
 & "Text, arg: T): Ok \n    ! net_failure thread_alerted\n    Export an eng"
 & "ine under name \'name\', to the name server at IP address \n    \'serve"
 & "r\'. The empty text denotes the local IP address. The \'arg\' is given "
 & "\n    as an argument to all procedures received by the engine to execut"
 & "e.\n  Some(T)All(U) net_importEngine(name: Text, server: Text): ((T)->U"
 & ")->U \n    ! net_failure thread_alerted\n    Import the object of name "
 & "\'name\', from the name server at IP \n    address \'server\'. The empt"
 & "y text denotes the local IP address.\n";

CONST E15 = 
   "  rd_failure: Exception\n  rd_eofFailure: Exception\n  rd_new(t: Text):"
 & " Rd\n    A reader on a text (a Modula-3 TextRd).\n  rd_stdin: Rd\n    T"
 & "he standard input (the Modula-3 Stdio.Stdin).\n  rd_open(fs: FileSystem"
 & ", t: Text): Rd ! rd_failure\n    Given a file system and a file name, r"
 & "eturns a reader on a file \n    (a Modula-3 FileRd, open for read). The"
 & " local file system is available\n    through the predefined lexically s"
 & "coped identifier \"fileSys\".\n    Moreover, \"fileSysReader\" is a rea"
 & "d-only local file system.\n  rd_getChar(r: Rd): Char ! rd_failure rd_eo"
 & "fFailure thread_alerted\n    Get the next character from a reader.\n  r"
 & "d_eof(r: Rd): Bool ! rd_failure thread_alerted\n    Test for the end-of"
 & "-stream on a reader.\n  rd_unGetChar(r: Rd): Ok\n    Put the last chara"
 & "cter obtained by getChar back into the reader \n    (unfortunately, it "
 & "may crash if misused!).\n  rd_charsReady(r: Rd): Int ! rd_failure\n    "
 & "The number of characters that can be read without blocking. \n  rd_getT"
 & "ext(r: Rd, n: Int): Text ! rd_failure thread_alerted\n    Read the next"
 & " n characters, or at most n on end-of-file.\n  rd_getLine(r: Rd): Text "
 & "! rd_failure rd_eofFailure thread_alerted\n    Read the next line and r"
 & "eturn it without including the end-of-line \n    character.\n  rd_index"
 & "(r: Rd): Int\n    The current reader position.\n  rd_length(r: Rd): Int"
 & " ! rd_failure thread_alerted\n    Length of a reader (including read pa"
 & "rt).\n  rd_seek(r: Rd, n: Int): Ok ! rd_failure thread_alerted\n    Rep"
 & "osition a reader.\n  rd_close(r: Rd): Ok ! rd_failure thread_alerted\n "
 & "   Close a reader.\n  rd_intermittent(r: Rd): Bool\n    Whether the rea"
 & "der is stream-like (not file-like).\n  rd_seekable(r: Rd): Bool\n    Wh"
 & "ether the reader can be repositioned.\n  rd_closed(r: Rd): Bool\n    Wh"
 & "ether the reader is closed.\n";

CONST E16 = 
   "  pickle_failure: Exception\n  All(T) pickle_write(w: Wr, v: T): Ok \n "
 & "   ! pickle_failure wr_failure thread_alerted\n    Copy a value to a wr"
 & "iter, similarly to sys_copy.\n  Some(T) pickle_read(r: Rd): T \n    ! p"
 & "ickle_failure rd_failure rd_eofFailure thread_alerted\n    Copy a value"
 & " from a reader, similarly to sys_copy.\n";

CONST E17 = 
   "  t: Text\n    A string in double quotes.\n  text_new(size: Int, init: "
 & "Char): Text\n    A text of size \'size\', all filled with \'init\'.\n  "
 & "text_empty(t: Text): Bool\n    Test for empty text.\n  text_length(t: T"
 & "ext): Int\n    Length of a text.\n  text_equal(t1: Text, t2: Text): Boo"
 & "l\n    Text equality (case sensitive).\n  text_char(t: Text, i: Int): C"
 & "har\n    The i-th character of a text (if it exists); zero-indexed.\n  "
 & "text_sub(t: Text, start: Int, size: Int): Text\n    The subtext beginni"
 & "ng at \'start\', and of size \'size\' (if it exists).\n  text_&(t1: Tex"
 & "t, t2: Text): Text\n    (also infix \'&\') The concatenation of two tex"
 & "ts.\n  text_precedes(t1: Text, t2: Text): Bool\n    Whether \'t1\' prec"
 & "edes \'t2\' in lexicographic (ascii) order.\n  text_decode(t: Text): Te"
 & "xt\n    Every occurrence of an escape sequence is replaced by the corre"
 & "sponding \n    non-printing formatting character:  \\\\ = \\;  \\\' = \'"
 & ";  \\\" = \";  \\n = LF; \n    \\r = CR;  \\t = HT;  \\f = FF;  \\t = H"
 & "T;  \\xxx = xxx (octals 000..177);  \n    \\c = c (otherwise).\n  text_"
 & "encode(t: Text): Text\n    Every occurrence of a non-printing formattin"
 & "g character is replaced by an \n    escape sequence.\n  text_explode(se"
 & "ps: Text, t: Text): [Text]\n    Splits an input text into a similarly o"
 & "rdered array of texts, each a maximal \n    subsequence of the input te"
 & "xt not containing sep chars. The empty text is \n    exploded as a sing"
 & "leton array of the empty text. Each sep char in the input \n    produce"
 & "s a break, so the size of the result is 1 + the number of sep chars \n "
 & "   in the text. implode(explode( \"c\",text),\'c\') is the identity.\n "
 & " text_implode(sep: Char, a: [Text]): Text ! net_failure\n    Concatenat"
 & "e an array of texts into a single text, separating the pieces by a \n  "
 & "  single sep char. A zero-length array is imploded as the empty text. \n"
 & "    explode(\"c\",implode( \'c\',text)) is the identity provided that t"
 & "he array has \n    positive size and sep does not occur in the array el"
 & "ements.\n  text_hash(t: Text): Int\n    A hash function.\n  text_toInt("
 & "t: Text): Int\n  ";

CONST E17_0 = 
   "  Convert a text to an integer (see also fmt_).\n  text_fromInt(n: Int)"
 & ": Text\n    Convert an integer to a text (see also lex_).\n  text_findF"
 & "irstChar(c: Char, t: Text, n: Int): Int\011\n    The index of the first"
 & " occurrence of \'c\' in \'t\', past \'n\'. -1 if not found.\n  text_fin"
 & "dLastChar(c: Char, t: Text, n: Int): Int\n    The index of the last occ"
 & "urrence of \'c\' in \'t\', before \'n\'. -1 if not found.\n  text_findF"
 & "irst(p: Text, t: Text, n: Int): Int\n    The index of the first char of"
 & " the first occurrence of \'p\' in \'t\', past \'n\'. \n    -1 if not fo"
 & "und.\n  text_findLast(p: Text, t: Text, n: Int): Int\n    The index of "
 & "the first char of the last occurrence of \'p\' in \'t\', before \n    \'"
 & "n\'. -1 if not found.\n  text_replaceAll(old: Text, new: Text, t: Text)"
 & ": Text\n    Replace all occurrences of \'old\' by \'new\' in \'t\', as "
 & "found by iterating \n    \'findFirst\'.\n";

CONST E18 = 
   "  true: Bool\n    The constant true.\n  false: Bool\n    The constant f"
 & "alse.\n  All(T)All(U) bool_is(x: T, y: U): Bool\n    (also infix \'is\'"
 & ") Identity predicate: value equality for \n    Ok, Bool, Int, Real, Cha"
 & "r, Text, Exception; pointer equality otherwise.\n  All(T)All(U) bool_is"
 & "not(x: T, y: U): Bool\n    (also infix \'isnot\') Negation of \'is\'.\n"
 & "  bool_not(b: Bool): Bool\n    (also \'not(b)\')\n  bool_and(b1: Bool, "
 & "b2: Bool): Bool\n    (also infix \'and\')\n  bool_or(b1: Bool, b2: Bool"
 & "): Bool\n    (also infix \'or\')\n";

CONST E19 = 
   "  form_failure: Exception\n  form_new(t: Text): Form ! form_failure\n  "
 & "  Read a form description from a text.\n  form_fromFile(file: Text): Fo"
 & "rm ! form_failure thread_alerted\n    Read a form description from a fi"
 & "le.\n  form_attach(fv: Form, name: Text, f: (Form)->Ok): Ok ! form_fail"
 & "ure\n    Attach a procedure to an event, under a form. The procedure is"
 & " passed \n    back the form when the event happens.\n  form_getBool(fv:"
 & " Form, name: Text, property: Text): Bool ! form_failure\n    Get the bo"
 & "olean value of the property of the named interactor.\n    (Do not confu"
 & "se with form_getBoolean.)\n  form_putBool(fv: Form, name: Text, propert"
 & "y: Text, b: Bool): Ok \n    ! form_failure\n    Set the boolean value o"
 & "f the named property of the named interactor.\n    (Do not confuse with"
 & " form_putBoolean.)\n  form_getInt(fv: Form, name: Text, property: Text)"
 & ": Int ! form_failure\n    Get the integer value of the named property o"
 & "f the named interactor. If \n    property is the empty text, get the \322"
 & "value\323 property.\n  form_putInt(fv: Form, name: Text, property: Text"
 & ", n: Int): Ok \n    ! form_failure\n    Set the integer value of the na"
 & "med property of the named interactor. If \n    property is the empty te"
 & "xt, set the \322value\323 property.\n  form_getText(fv: Form, name: Tex"
 & "t, property: Text): Text ! form_failure\n    Get the text value of the "
 & "named property of the named interactor. If \n    property is the empty "
 & "text, get the \322value\323 property.\n  form_putText(fv: Form, name: T"
 & "ext, property: Text, t: Text, append: Bool)\n   : Ok ! form_failure\n  "
 & "  Set the text value of the named property of the named interactor. If "
 & "\n    property is the empty text, set the \322value\323 property.\n  fo"
 & "rm_getBoolean(fv: Form, name: Text): Bool ! form_failure\n    Get the b"
 & "oolean value of the named boolean-choice interactor.\n  form_putBoolean"
 & "(fv: Form, name: Text, b: Bool): Ok ! form_failure\n    Set the boolean"
 & " value of the named boolean-choice interactor.\n  form_getChoice(fv: Fo"
 & "rm, radioName: Text): Text ! form_failure\n    Get the choice value ";

CONST E19_0 = 
   "of the named radio interactor.\n  form_putChoice(fv: Form, radioName: T"
 & "ext, choiceName: Text): Ok \n    ! form_failure\n    Set the choice val"
 & "ue of the named radio interactor.\n  form_getReactivity(fv: Form, name:"
 & " Text): Text ! form_failure\n    Get the reactivity of the named intera"
 & "ctor. It can be \"active\", \n    \"passive\", \"dormant\", or \"vanish"
 & "ed\".\n  form_putReactivity(fv: Form, name: Text, r: Text): Ok ! form_f"
 & "ailure\n    Set the reactivity of the named interactor. It can be \"act"
 & "ive\", \n    \"passive\", \"dormant\", or \"vanished\".\n  form_popUp(f"
 & "v: Form, name: Text): Ok ! form_failure\n    Pop up the named interacto"
 & "r.\n  form_popDown(fv: Form, name: Text): Ok ! form_failure\n    Pop do"
 & "wn the named interactor.\n  form_numOfChildren(fv: Form, parent: Text):"
 & " Int ! form_failure\n    Return the number of children of parent.\n  fo"
 & "rm_child(fv: Form, parent: Text, n: Int): Text ! form_failure\n    Retu"
 & "rn the n-th child of parent.\n  form_childIndex(fv: Form, parent: Text,"
 & " child: Text): Int ! form_failure\n    Return the index of the given ch"
 & "ild of parent.\n  form_insert(fv: Form, parent: Text, t: Text, n: Int):"
 & " Ok ! form_failure\n    Insert the form described by t as child n of pa"
 & "rent.\n  form_move(fv: Form, parent: Text, child: Text, toChild: Text, "
 & "before: Bool)\n    : Ok ! form_failure\n    Move child before or after "
 & "toChild of parent; after \"\" means first,\n    before \"\" means last."
 & "\n  form_delete(fv: Form, parent: Text, child: Text): Ok ! form_failure"
 & "\n    Delete the named child of parent.\n  form_deleteRange(fv: Form, p"
 & "arent: Text, n: Int, count: Int): Ok \n    ! form_failure\n    Delete c"
 & "ount children of parent, from child n.\n  form_takeFocus(fv: Form, name"
 & ": Text, select: Bool): Ok ! form_failure\n    Make the named interactor"
 & " acquire the keyboard focus, and optionally \n    select its entire tex"
 & "t contents.\n  form_show(fv: Form): Ok ! form_failure\n    Show a windo"
 & "w containing the form on the default display.\n  form_showAt(fv: Form, "
 & "at: Text, title: Text): Ok ! form_failure\n    Show a window containi";

CONST E19_1 = 
   "ng the form on a display. For an X display,\n    at=<machine name>(\':\'"
 & "|\'::\')<num>(\'\'|\'.\'<num>); at=\"\" is the default \n    display. T"
 & "he title is shown in the window header.\n  form_hide(fv: Form): Ok ! fo"
 & "rm_failure\n    Hide the window containing the form.\n";

CONST E20 = 
   "  rects_failure: Exception \n  rects_new(): Rects \n    An empty displa"
 & "y list of rectangles.\n  rects_setWorld(r: Rects, w: Real, e: Real, n: "
 & "Real, s: Real): Ok\n    Set the world coordinates.\n  rects_setMargin(r"
 & ": Rects, w: Real, e: Real, n: Real, s: Real): Ok\n    Set the window ma"
 & "rgin in points.\n  rects_setMins(r: Rects, wd: Real, ht: Real): Ok\n   "
 & " Set the minimum size for displaying an item, in points.\n  rects_setBg"
 & "(r: Rects, c: Color): Ok\n    Set the window background color.\n  rects"
 & "_setN(r: Rects, n: Int, redisplay: Bool): Ok\n    Set the number of rec"
 & "tangles in the display list; they do not exist yet.\n  rects_setPositio"
 & "n(r: Rects, n: Int, w: Real, e: Real, n: Real, s: Real,\n      redispla"
 & "y: Bool): Ok\n    Set the position of the nth rectangle, then it exists"
 & ".\n  rects_getPosition(r: Rects, n: Int): [4*Real]\n    Get the positio"
 & "n of the nth rectangle; w,e,n,s.\n  rects_setColor(r: Rects, n: Int, c:"
 & " Color, redisplay: Bool): Ok\n    Set the color of the nth rectangle, t"
 & "hen it exists.\n  rects_delete(r: Rects, n: Int, redisplay: Bool): Ok\n"
 & "    Delete the nth rectangle; then it does not exist.\n  rects_exists(r"
 & ": Rects, n: Int): Ok\n    Does the nth rectangle exist.\n  rects_draw(r"
 & ": Rects, n: Int): Ok\n    Draw the nth rectangle.\n  rects_erase(r: Rec"
 & "ts, n: Int): Ok\n    Erase the nth rectangle.\n  rects_show(r: Rects): "
 & "Ok \n    Show the window.\n  rects_hide(r: Rects): Ok \n    Hide the wi"
 & "ndow.\n";

CONST E21 = 
   "  n.m: Int\n    Positive real constants; m is optional.\n  ~n.m: Int\n "
 & "   Negative real constants; m is optional.\n  real_minus(n: Real): Real"
 & "\n    (also \'-n\') Real negation.\n  real_minus(n: Int): Int\n    (als"
 & "o \'-n\') Overloaded integer negation.\n  real_+(n1: Real, n2: Real): R"
 & "eal\n    (also infix \'+\') Real addition.\n  real_+(n1: Int, n2: Int):"
 & " Int\n    (also infix \'+\') Overloaded integer addition.\n  real_-(n1:"
 & " Real, n2: Real): Real\n    (also infix \'-\') Real difference.\n  real"
 & "_-(n1: Int, n2: Int): Int\n    (also infix \'-\') Overloaded integer di"
 & "fference.\n  real_*(n1: Real, n2: Real): Real\n    (also infix \'*\') R"
 & "eal multiplication.\n  real_*(n1: Int, n2: Int): Int\n    (also infix \'"
 & "*\') Overloaded integer multiplication.\n  real_/(n1: Real, n2: Real): "
 & "Real\n    (also infix \'/\') Real division.\n  real_/(n1: Int, n2: Int)"
 & ": Int\n    (also infix \'/\') Overloaded integer division.\n  real_<(n1"
 & ": Real, n2: Real): Bool\n    (also infix \'<\') Real less-than predicat"
 & "e\n  real_<(n1: Int, n2: Int): Bool\n    (also infix \'<\') Overloaded "
 & "integer less-than predicate\n  real_>(n1: Real, n2: Real): Bool\n    (a"
 & "lso infix \'>\') Real greater-than predicate\n  real_>(n1: Int, n2: Int"
 & "): Bool\n    (also infix \'>\') Overloaded integer greater-than predica"
 & "te\n  real_<=(n1: Real, n2: Real): Bool\n    (also infix \'<=\') Real n"
 & "o-greater-than predicate\n  real_<=(n1: Int, n2: Int): Bool\n    (also "
 & "infix \'<=\') Overloaded integer no-greater-than pred.\n  real_>=(n1: R"
 & "eal, n2: Real): Bool\n    (also infix \'>=\') Real no-less-than predica"
 & "te.\n  real_>=(n1: Int, n2: Int): Bool\n    (also infix \'>=\') Overloa"
 & "ded integer no-less-than pred.\n  real_float(n: Int): Real\n    (also \'"
 & "float(n)\') Integer-to-real conversion.\n  real_float(n: Real): Real\n "
 & "   (also \'float(n)\') Overloaded; identity on reals.\n  real_round(n: "
 & "Real): Int\n    (also \'round(n)\') Real-to-integer rounding.\n  real_r"
 & "ound(n: Int): Int\n    (also \'round(n)\') Overloaded; identity on inte"
 & "gers.\n  real_floor(n: Real): Int\n    Greatest integers no greater tha"
 & "n n.\n  real_floor(n: Int): Int\n ";

CONST E21_0 = 
   "   Overloaded; identity on integers.\n  real_ceiling(n: Real): Int\n   "
 & " Least integers no less than n.\n  real_ceiling(n: Int): Int\n    Overl"
 & "oaded; identity on integers.\n";

CONST E22 = 
   "  n: Int\n    Positive integer constants.\n  ~n: Int\n    Negative inte"
 & "ger constants.\n  int_minus(n: Int): Int\n      Integer negation.\n  in"
 & "t_+(n1: Int, n2: Int): Int\n    Integer addition.\n  int_-(n1: Int, n2:"
 & " Int): Int\n    Integer difference.\n  int_*(n1: Int, n2: Int): Int\n  "
 & "  Integer multiplication.\n  int_/(n1: Int, n2: Int): Int\n    Integer "
 & "division.\n  int_%(n1: Int, n2: Int): Int\n    (also infix \'%\') Integ"
 & "er modulo.\n  int_<(n1: Int, n2: Int): Bool\n    Integer less-than pred"
 & "icate.\n  int_>(n1: Int, n2: Int): Bool\n    Integer greater-than predi"
 & "cate.\n  int_<=(n1: Int, n2: Int): Bool\n    Integer no-greater-than pr"
 & "edicate.\n  int_>=(n1: Int, n2: Int): Bool\n    Integer no-less-than pr"
 & "edicate.\n";

CONST E23 = 
   "  wr_failure: Exception\n  wr_new(): Wr\n    A writer to a text (a Modu"
 & "la-3 TextWr).\n  wr_toText(w: Wr): Text\n    Emptying a writer to a tex"
 & "t..\n  wr_stdout: Wr\n    The standard output (the Modula-3 Stdio.Stdou"
 & "t).\n  wr_stderr: Wr\n    The standard error (the Modula-3 Stdio.Stderr"
 & ").\n  wr_open(fs: FileSystem, t: Text): Wr ! wr_failure\n    Given a fi"
 & "le system and a file name, returns a writer to the beginning of \n    a"
 & " file (a Modula-3 FileWr, open for write). The local file system is \n "
 & "   available through the predefined lexically scoped identifier \"fileS"
 & "ys\".\n  wr_openAppend(fs: FileSystem, t: Text): Wr ! wr_failure\n    G"
 & "iven a file system and a file name, returns a writer to the end of file"
 & " \n    (a Modula-3 FileWr, open for append). The local file system is a"
 & "vailable\n    through the predefined lexically scoped identifier \"file"
 & "Sys\".\n  wr_putChar(w: Wr, c: Char): Ok ! wr_failure thread_alerted\n "
 & "   Put a character to a writer .\n  wr_putText(w: Wr, t: Text): Ok ! wr"
 & "_failure thread_alerted\n    Put a text to a writer .\n  wr_flush(w: Wr"
 & "): Ok ! wr_failure thread_alerted\n    Flush a writer: all buffered wri"
 & "tes to their final destination.\n  wr_index(w: Wr): Int\n    The curren"
 & "t writer position\n  wr_length(w: Wr): Int ! wr_failure thread_alerted\n"
 & "    Length of a writer.\n  wr_seek(w: Wr, n: Int): Ok ! wr_failure thre"
 & "ad_alerted\n    Reposition a writer.\n  wr_close(w: Wr): Ok ! wr_failur"
 & "e thread_alerted\n    Close a writer.\n  wr_buffered(w: Wr): Bool\n    "
 & "Whether the writer is buffered.\n  wr_seekable(w: Wr): Bool\n    Whethe"
 & "r the writer can be repositioned.\n  wr_closed(w: Wr): Bool\n    Whethe"
 & "r the writer is closed.\n";


BEGIN
END ObliqBdl2.
