MODULE PackageObj_Monitor_v1 EXPORTS PackageObj, PackageObj_Monitor_v1;

IMPORT Thread, NetObj, StubLib, Rd, Wr, PackageObj;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {report};
      ReturnCodes = {OK};

  PROCEDURE Surrogate_report(self: PackageObj.Monitor; arg_arg: REFANY)
       RAISES {NetObj.Error, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; <* NOWARN *>

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.report));
          StubLib.OutRef(c, arg_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =>
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) => StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) => StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_report;

PROCEDURE Invoke(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, PackageObj.Monitor);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.report) => Stub_report(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    END;
  END Invoke;

PROCEDURE Stub_report(
    self: PackageObj.Monitor;
    c: StubLib.Conn;
    <* NOWARN *> rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR arg_arg: REFANY;
      dataPresent: BOOLEAN <* NOWARN *>;

  BEGIN
    arg_arg := StubLib.InRef(c, rep, -1);
    self.report(arg_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_report;

BEGIN
  StubLib.Register(TYPECODE(PackageObj.Monitor), 1, TYPECODE(Surrogate_PackageObj_Monitor), Invoke);
END PackageObj_Monitor_v1.
