########################################################################
##
##  File test library for Perl  (FILE-TEST-LIB.PL v1.0)
##  Copyright (C) 1995, Bitgate Software
##
##  Please read the "USAGE" file for more information on how to use this
##  library.  Check the example source files for learning by example.
##
##  Created by Ken "Jigen" Hollis
##
##  Update log:
##	01/20/95: Created the library
##
########################################################################

## Maybe these should test first...  Ohwell, this will work for the time
## being...  :-)
$true = 1;
$false = 0;

## Although this section of the code is a bit sloppy, it still does the
## trick for what you need.  Basically, this would be SO much easier if
## this were an array.  I think Perl 5 can assign arrays like C (as in
## a typedef-type thing) but I don't know.  But, I'll soon find out.
##
## If it does, you can guarantee that this library will be updated to
## match it!  Never-the-less, enjoy the library.

## Test if a file is readable
sub is_read {
    (-r $_[0]) ? $true : $false;
}

## Test if a file is writable
sub is_write {
    (-w $_[0]) ? $true : $false;
}

## Test if a file is executable
sub is_exec {
    (-x $_[0]) ? $true : $false;
}

## Test if a file is owned by the current user
sub is_user_own {
    (-o $_[0]) ? $true : $false;
}

## Test if a file can be read by a real user
sub is_real_read {
    (-R $_[0]) ? $true : $false;
}

## Test if a file can be written to by a real user
sub is_real_write {
    (-W $_[0]) ? $true : $false;
}

## Test if a file can be executed by a real user
sub is_real_exec {
    (-X $_[0]) ? $true : $false;
}

## Test if a file is owned by a real user
sub is_real_own {
    (-O $_[0]) ? $true : $false;
}

## Test if a file exists
sub is_exist {
    (-e $_[0]) ? $true : $false;
}

## Test if a file exists, and has a zero byte length
sub is_exist_zero {
    (-z $_[0]) ? $true : $false;
}

## Test if a file exists, and has a non-zero byte length
sub is_exist_nonzero {
    (-s $_[0]) ? $true : $false;
}

## Test if a file is a plain file
sub is_plain {
    (-f $_[0]) ? $true : $false;
}

## Test if a file is a directory
sub is_directory {
    (-d $_[0]) ? $true : $false;
}

## Test if a file is a symbolic link
sub is_link {
    (-l $_[0]) ? $true : $false;
}

## Test if a file is a Socket file
sub is_socket {
    (-S $_[0]) ? $true : $false;
}

## Test if a file is a named pipe (fifo)
sub is_pipe {
    (-p $_[0]) ? $true : $false;
}

## Test if a file is a block-special file
sub is_block_special {
    (-b $_[0]) ? $true : $false;
}

## Test if a file is a character-special file
sub is_char_special {
    (-c $_[0]) ? $true :$false;
}

## Test if a file is setuid
sub is_setuid {
    (-u $_[0]) ? $true : $false;
}

## Test if a file is setgid
sub is_setgid {
    (-g $_[0]) ? $true : $false;
}

## Test if a file has the sticky-bit
sub is_sticky_bit {
    (-k $_[0]) ? $true : $false;
}

## Test if a file has isatty set on the file
sub is_isatty {
    (-t $_[0]) ? $true : $false;
}

## Test if a file is a Text file
sub is_text {
    (-T $_[0]) ? $true : $false;
}

## Test if a file is a Binary file
sub is_binary {
    (-B $_[0]) ? $true : $false;
}

## Test if a file has a modification age in days
sub is_modification_age {
    (-M $_[0]) ? $true : $false;
}

## Test if a file has an access age in days
sub is_access_age {
    (-A $_[0]) ? $true : $false;
}

## Test if a file has inode modification in days
sub is_inode_modification {
    (-C $_[0]) ? $true : $false;
}

1;
