require 5.000;

# PerlVision - A class library to do ANSI graphics and textmode GUI
# By Ashish Gulhati (hash@well.sf.ca.us)
# V.0.1.0
#
# (C) Ashish Gulhati, 1995. All Rights Reserved.
#
# Free electronic distribution permitted. You are free to use
# PerlVision in your own code so long as this copyright message stays
# intact. PerlVision or derived code may not be used in any commercial
# product without my prior written or PGP-signed consent. Please e-mail 
# me if you make significant changes, or just want to let me know what 
# you're using PerlVision for.

package pv;

sub initvision {
    my $mode = shift;
    system "stty", '-icanon', '-echo', '-ignbrk', '-isig', '-brkint';
    $|=1;
    ($mode) && (print ("\e[0;11m"));
    ($mode) || (print ("\e[0;10m"));
    $TL=(".","\xDA")[$mode];
    $TR=(".","\xBF")[$mode];
    $HZ=("-","\xC4")[$mode];
    $VT=("|","\xB3")[$mode];
    $BL=("`","\xC0")[$mode];
    $BR=("'","\xD9")[$mode];
    $LB=(" ","\xDD")[$mode];
    $RB=(" ","\xDE")[$mode];
    $TICK=("X","\xFB")[$mode];
    $MARK=("*","\x04")[$mode];
    $RS = &screen;
}

sub exitvision {
    system "stty sane";
    print ("\e[0;10m"); 
    print ("\e[?25h");
    print ("\e[40;37m");
    print ("\e[2J");
    print ("\e[1;1H");
}

sub screen {
    my ($i, @qq, @xx);
    for ($i=1; $i<25; $i++) {
	$qq[$i] = &line;
    }
    for ($i=1; $i<25; $i++) {
	$xx[$i] = " " x 81;
    }
    $i = [1,1,0,\@qq,\@xx];
}

sub line {
    my ($i, @qq);
    my $param=shift;
    for ($i=1; $i<81; $i++) {
	$qq[$i] = 0;
    }
    $i = \@qq;
}

sub pvprint {
    my $input = shift;
    $input=~s/\n.*//;
    print $input;
    my $qq=length($input);
    my $i;
    ($qq+$RS[1] >80) && ($qq=80-$RS[1]);
    for ($i=0; $i<$qq; $i++) {
	$RS[3][$RS[0]][$RS[1]+$i]=$RS[2];
    }
    substr($RS[4][$RS[0]],$RS[1],$qq)=substr($input,0,$qq);
    $RS[1]+=$qq;
}

sub refresh {
    print ("\e[?25l");	    
}

sub redraw {
}

sub pv_tellregion {
    my ($x1, $y1, $x2, $y2) = @_;
    my ($i, $j, $region);
    my @yy=(); my @qq=(); my @xx=();
    for ($i=$y1; $i<=$y2; $i++) {
	for ($j=$x1; $j<=$x2; $j++) {
	    $qq[$i-$y1][$j-$x1]=$RS[3][$i][$j];
	}
	$xx[$i-$y1] = substr($RS[4][$i], $x1, $x2-$x1);
    }
    $region = [\@qq,\@xx];
    return ($region);
}

sub pv_putregion {
    my ($x1, $y1, $x2, $y2, $region) = @_;
    my ($i, $j, $printbuf, $back, $fore, $hi);
    $printbuf="";
    for ($i=$y1; $i<=$y2; $i++) {
	substr($RS[4][$i], $x1, $x2-$x1) = $region->[1]->[$i-$y1];
	$printbuf.="\e[$i;$x1"."H";
	for ($j=$x1; $j<=$x2; $j++) {
	    $RS[3][$i][$j] = ${$region->[0]->[$i-$y1]}[$j-$x1];
	    $back = $RS[3][$i][$j] % 10;
	    $fore = ($RS[3][$i][$j]-$back) / 10;
	    $hi = ($fore > 7 ? 1 : 0);
	    $fore = ($fore > 7 ? $fore-8 : $fore);
	    $printbuf.="\e[0;$hi;3$fore;4$back"."m".substr($RS[4][$i], $j, 1);
	}
    }
    print $printbuf;
}

sub refresh_cursor {
    print ("\e[$RS[0];$RS[1]"); print ("H");
    print ("\e[?25h");
}

sub set_cur_pos {
    $RS[1]=shift;
    $RS[0]=shift;
    print ("\e[$RS[0];$RS[1]"); print ("H");
}

sub cursor_up {
    ($RS[0]>1) && ($RS[0]--);
    print ("\e[A");
}

sub cursor_down {
    ($RS[0]<24) && ($RS[0]++);
    print ("\e[B");
}

sub cursor_forward {
    ($RS[1]<81) && ($RS[1]++);
    print ("\e[C");
}

sub cursor_back {
    ($RS[1]>1) && ($RS[1]--);
    print ("\e[D");
}

sub bgcolor {
    if (($_[0] < 8) && ($_[0] >= 0)) {
	$RS[2]=$RS[2]-$RS[2]%10+$_[0];
    }
    my $back = $RS[2] % 10;
    my $fore = ($RS[2]-$back) / 10;
    my $hi = ($fore > 7 ? 1 : 0);
    $fore = ($fore > 7 ? $fore-8 : $fore);
    print "\e[0;$hi;3$fore;4$back"."m";
}

sub fgcolor {
    if (($_[0] < 16) && ($_[0] >= 0)) {
	$RS[2]=$RS[2]%10+($_[0]*10);
    }
    my $back = $RS[2] % 10;
    my $fore = ($RS[2]-$back) / 10;
    my $hi = ($fore > 7 ? 1 : 0);
    $fore = ($fore > 7 ? $fore-8 : $fore);
    print "\e[0;$hi;3$fore;4$back"."m";
}

sub cls {
    my ($i,$j) = (1,1);
    for ($i=1;$i<25;$i++) {
	for ($j=1;$j<81;$j++) {
	    $RS[3][$i][$j]=$RS[2];
	}
	$RS[4][$i]=(" " x 81);
    }
    print ("\e[2J");
}

sub cleol {
    my ($y,$x) = @RS[0..1];
    substr($RS[4][$y],$x,80-$x)= (" " x (80-$x));
    for ($x;$x<81;$x++) {
	$RS[3][$y][$x]=$RS[2];
    }
    print ("\e[K");
}

sub box {			# Draws your basic 3D box.
    my ($x1,$y1,$x2,$y2,$style,$bgcolor)=@_;
    my $lines=$x2-$x1;
    my $j;
    my ($TOPL,$BOTR);
    if ($style) {$TOPL=15; $BOTR=0}
    else {$TOPL=0; $BOTR=15}
    set_cur_pos($x1,$y1); 
    bgcolor ($bgcolor);
    fgcolor ($TOPL);
    pvprint ($TL); pvprint ($HZ x ($lines-1)); 
    fgcolor ($BOTR); pvprint ($TR); 
    for ($j=$y1+1; $j<$y2; $j++) {
	set_cur_pos($x1,$j);
	fgcolor ($TOPL); pvprint ($VT);
	pvprint (" " x ($lines-1));
	fgcolor ($BOTR); pvprint ($VT); 
    }
    set_cur_pos($x1,$y2); 
    fgcolor ($TOPL); pvprint ($BL); 
    fgcolor ($BOTR); pvprint ($HZ x ($lines-1));
    pvprint ($BR);
}

sub standard {			# Makes a standard screen (optimized)
    bgcolor (6); cls; bgcolor(7);
    set_cur_pos (1,1); cleol;
    set_cur_pos (1,2); cleol;
    set_cur_pos (1,3); cleol;
    box (2,1,79,3,1,7);
    box (2,4,79,24,0,6);
}

sub getkey {			# Gets a keystroke and returns a code
    my $key = getc;		# and the key if it's printable.
    my $keycode = 0;
    if ($key eq "\e") {
	$key = getc;
	if ($key eq "[") {	# Prolly a keypad key
	    $key = getc;
	    if ($key =~ /[A-D1-6]/) {
		($key eq "1") && (getc eq "~") && ($keycode = 1);
		($key eq "2") && (getc eq "~") && ($keycode = 2);
		($key eq "3") && (getc eq "~") && ($keycode = 3);
		($key eq "4") && (getc eq "~") && ($keycode = 4);
		($key eq "5") && (getc eq "~") && ($keycode = 5);
		($key eq "6") && (getc eq "~") && ($keycode = 6);
		($key eq "A") && ($keycode = 7);
		($key eq "B") && ($keycode = 8);
		($key eq "C") && ($keycode = 9);
		($key eq "D") && ($keycode = 10);
	    }
	}
	elsif ($key =~ /[WwBbFfIiQqVv<>DdXxHh]/) { # Meta keys
	    ($key =~ /[Qq]/) && ($keycode = 11);   # M-q
	    ($key eq "" 
	     || $key eq "") && ($keycode = 12);  # M-<del>
	    ($key =~ /[Bb]/) && ($keycode = 13);   # M-b
	    ($key =~ /[Dd]/) && ($keycode = 14);   # M-d
	    ($key =~ /[Vv]/) && ($keycode = 15);   # M-v
	    ($key eq "<") && ($keycode = 16);      # M-<
	    ($key eq ">") && ($keycode = 17);      # M->
	    ($key =~ /[Hh]/) && ($keycode = 18);   # M-h
	    ($key =~ /[Xx]/) && ($keycode = 19);   # M-x
	    ($key =~ /[Ff]/) && ($keycode = 20);   # M-f
	    ($key =~ /[Ii]/) && ($keycode = 21);   # M-i
	    ($key =~ /[Ww]/) && ($keycode = 22);   # M-w
	}
	else {
	    $keycode = 100;
	}
    }
    elsif ($key =~ /[A-Za-z0-9_ \t\n\r~\`!@#\$%^&*()\-+=\\|{}[\];:'"<>,.\/?]/) {
        ($keycode = 200);
    }
    return ($key, $keycode);
}

"Perlvision. (C) Ashish Gulhati, 1995";
