# tixMDIMenuBar --
#
#	A menu bar for MDI windows. It will display special buttons when the
#	MDI child window is maximized.
#
# Note:
#
# App programmer should never call the methods "maximize" and "restore"
# directly. They are called by the MDI window that controls this MDI
# menubar.
#
# To force a MDI window to maximize or restore, an app programmer should
# call the appropriate methods of the tixMDIWindow widget.
#
#

tixWidgetClass tixMDIMenuBar {
    -classname TixMDIMenuBar
    -superclass tixPrimitive
    -method {
	maximize restore
    }
    -flag {
	-command -mdiwindow -resbitmap -state -sysbitmap
    }
    -configspec {
	{-command command Command {}}
	{-mdiwindow mdiWindow MdiWindow {}}
	{-resbitmap resBitmap ResBitmap [tix getbitmap restore]}
	{-state state State normal}
	{-sysbitmap sysBitmap SysBitmap [tix getbitmap system]}
    }
}

#--------------------------
# Create Widget
#--------------------------
proc tixMDIMenuBar::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    set data(w:menubar) [frame $w.menubar]
    set data(w:system) [menubutton $w.system -relief raised\
	-bitmap $data(-sysbitmap) -anchor center -highlightthickness 0\
	-width 22 -height 22]
    set data(w:restore) [menubutton $w.restore -relief raised\
	-bitmap $data(-resbitmap) -anchor center -highlightthickness 0\
	-width 22 -height 22]

    pack $data(w:menubar) -side left -fill both -expand yes
}

proc tixMDIMenuBar::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

 
    bind $data(w:system) <1> 		   {%W config -relief sunken}
    bind $data(w:system) <ButtonRelease-1> {%W config -relief raised}
    bind $data(w:system) <Double-1> 	  "tixMDIMenuBar::CloseClient $w %X %Y"

    bind $data(w:restore) <1> 		     {%W config -relief sunken}
    bind $data(w:restore) <ButtonRelease-1>  {%W config -relief raised}
    bind $data(w:restore) <ButtonRelease-1> "+tixMDIMenuBar::Restore $w %X %Y"
}

#----------------------------------------------------------------------
#                         Public method
#----------------------------------------------------------------------
proc tixMDIMenuBar::restore {w} {
    upvar #0 $w data

    if {$data(-state) == "maximized"} {
	pack forget $data(w:system)
	pack forget $data(w:restore)
	set data(-state) normal
    }
}

proc tixMDIMenuBar::maximize {w} {
    upvar #0 $w data

    if {$data(-state) == "normal"} {
	pack $data(w:system) -side left -fill both
	pack $data(w:restore) -side right -fill both
	pack $data(w:menubar) -side left -fill both -expand yes \
	    -after $data(w:system)
	set data(-state) maximized
    }
}

#----------------------------------------------------------------------
#                         Internal commands
#----------------------------------------------------------------------
proc tixMDIMenuBar::CloseClient {w x y} {
    upvar #0 $w data

    if {[winfo containing $x $y] == $data(w:system)} {
	if {$data(-mdiwindow) != {}} {
	    $data(-mdiwindow) close
	}
    }
}

proc tixMDIMenuBar::Restore {w x y} {
    upvar #0 $w data

    if {[winfo containing $x $y] == $data(w:restore)} {
	if {$data(-mdiwindow) != {}} {
	    $data(-mdiwindow) restore
	}
    }
}
