tixWidgetClass tixMDIWindow {
    -classname TixMDIWindow
    -superclass tixPrimitive
    -method {
	add place maximize
    }
    -flag {
	-clienttype -menu -mnubar
    }
    -forcecall {
	-menu
    }
    -static {
	-clienttype
    }
    -configspec {
	{-clienttype clientType ClientType tixMwmClient}
	{-menu menu Menu {}}
	{-menubar menuBar MenuBar {}}
    }
}

proc tixMDIWindow::ConstructWidget {w} {
    upvar #0 $w data

    set data(w:rootwin) [frame $w.root]
    set data(w:hsb) [scrollbar $w.hsb]
    set data(w:vsb) [scrollbar $w.vsb]

    # ToDo
    # 	Will change to use Form to manage scrollbars intelligently

    pack $data(w:rootwin) -expand yes -fill both
}

#----------------------------------------------------------------------
#                  Configuration commands
#----------------------------------------------------------------------
proc tixMDIWindow::config-menu {w menu} {
    upvar #0 $w data
    
    if {$menu != {}} {
	set data(-menu) $menu
	tixMDIWindow::UpdateMenu $w
    }
}

#----------------------------------------------------------------------
#                  public methods
#----------------------------------------------------------------------
proc tixMDIWindow::add {w name args} {
    upvar #0 $w data

    set data(w:$name) $data(w:rootwin).$name
    eval $data(-clienttype) $data(w:$name) $args
    $data(w:$name) config \
	-command "tixMDIWindow::Callback $w $name"\
	-parent $w

    # Set the default sizes
    #
    set data(c:$name,x)     	0
    set data(c:$name,y) 	0
    set data(c:$name,width)	0
    set data(c:$name,height)	0

    tixDoWhenIdle tixMDIWindow::PlaceChild $w $name

    return $data(w:$name)
}

# place a child to some place
#
proc tixMDIWindow::place {w name args} {
    upvar #0 $w data

    set opt(-x)      $data(c:$name,x)
    set opt(-y)      $data(c:$name,y)
    set opt(-width)  $data(c:$name,width)
    set opt(-height) $data(c:$name,height)

    tixHandleOptions opt {-x -y -width -height} $args

    set data(c:$name,x)     	$opt(-x)  
    set data(c:$name,y) 	$opt(-y)
    set data(c:$name,width)	$opt(-width)  
    set data(c:$name,height)	$opt(-height) 

    tixDoWhenIdle tixMDIWindow::PlaceChild $w $name
}

proc tixMDIWindow::maximize {w name} {
    upvar #0 $w data


}

proc tixMDIWindow::PlaceChild {w name} {
    if {![winfo exists $w]} {
	return
    }

    upvar #0 $w data

    if {$data(c:$name,width) == 0} {
	set data(c:$name,width) [winfo reqwidth $data(w:$name)]
    }
    if {$data(c:$name,height) == 0} {
	set data(c:$name,height) [winfo reqheight $data(w:$name)]
    }

    tixMapWindow $data(w:$name)
    tixMoveResizeWindow $data(w:$name) $data(c:$name,x) $data(c:$name,y)\
	$data(c:$name,width) $data(c:$name,height)
}

#----------------------------------------------------------------------
#                  Private methods
#----------------------------------------------------------------------
proc tixMDIWindow::UpdateMenu {w} {
    upvar #0 $w data

    set menu $data(-menu)
    $menu delete 0 100
    $menu add command -label Cascade\
	-command "tixMDIWindow::Cascade $w"
    $menu add command -label Tile \
	-command "tixMDIWindow::Tile $w"
    $menu add command -label "Arrange Icons"\
	-command "tixMDIWindow::ArrangeIcons $w"
    $menu add sep
}

proc tixMDIWindow::Callback {w name action} {
    upvar #0 $w data

    case $action {
	maximize {
	    set W [winfo width  $data(w:rootwin)]
	    set H [winfo height $data(w:rootwin)]

	    set info [$data(w:$name) borderinfo]
	    set x1 [lindex $info 0]
	    set y1 [lindex $info 1]
	    set x2 [lindex $info 2]
	    set y2 [lindex $info 3]

	    place $data(w:$name) -x -$x1 -y -$y1 \
		-width  [expr $W + $x1 + $x2] \
		-height [expr $H + $y1 + $y2]

	    if {$data(-menubar) != {}} {
		$data(-menubar) maximize
	    }
	}
    }
}
