.so man.macros
'----------------------------------------------------------------------
.HS tixPanedWindow tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixPanedWindow \- Create and manipulate tixPanedWindow widgets
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixPanedWindow\fI \fIpathName ?\fIoptions\fR?
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
The PanedWindow widget supports all the standard options of a frame
widget. See the \fBoptions(n)\fR manual entry for details on the
standard options.
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
'
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
'
.fi
.IP
'
Specifies the command to invoke when the panes change their sizes.
This command is called with a list of integers that record the new
sizes of the panes. The sizes of the panes are listed in the order of
the panes' creation.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBhandleActiveBg\fR
Class:		\fBHandleActiveBg\fR
Switch:		\fB\-handleactivebg\fR
'
.fi
.IP
'
Specifies the active background color of the resize handles. When the
mouse cursor enters a resize handle, the resize handle will adopt
the active background color.
'----------END
'
'
'----------BEGIN
.LP
.nf
'
Name:		\fBhandleBg\fR
Class:		\fBBackground\fR
Switch:		\fB\-handlebg\fR
'
.fi
.IP
'
Specifies the normal background color of the resize handles.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBheight\fR
Class:		\fBHeight\fR
Switch:		\fB\-height\fR
.fi
.IP
Specifies the desired height for the window.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBorientation\fR
Class:		\fBOrientation\fR
Switch:		\fB\-orientation\fR
Alias:		\fB\-orient\fR
.fi
.IP
Specifies the orientation of the panes. Must be either \fBvertical\fR
or \fBhorizontal\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpaneBorderWidth\fR
Class:		\fBPaneBorderWidth\fR
Switch:		\fB\-paneborderwidth\fR
Alias:		\fB\-pandbd\fR
.fi
.IP
Specifies the border width of the panes.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpaneRelief\fR
Class:		\fBPaneRelief\fR
Switch:		\fB\-panerelief\fR
.fi
.IP
Specifies the border relief of the panes.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBseparatorActiveBg\fR
Class:		\fBSeparatorActiveBg\fR
Switch:		\fB\-separatoractivebg\fR
'
.fi
.IP
'
Specifies the active background color of the separators. When the user
grabs a resize handle, the separators
will adopt the active background color.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBseparatorBg\fR
Class:		\fBBackground\fR
Switch:		\fB\-separatorbg\fR
'
.fi
.IP
'
Specifies the normal background color of the separators.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBwidth\fR
Class:		\fBWidth\fR
Switch:		\fB\-width\fR
.fi
.IP
Specifies the desired width for the window.
'----------END
'----------------------------------------------------------------------
.SH SUBWIDGETS
.PP
'
All the pane subwidgets created as a result of the \fBadd\fR command
can be accessed by the \fBsubwidget\fR command. They are identified by
the \fBpaneName\fR parameter to the \fBadd\fR command.
'
.BE
'
'----------------------------------------------------------------------
.SH DESCRIPTION

.PP
'
The \fBtixPanedWindow\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a PanedWindow widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
PanedWindow widget such as its cursor and relief.
'
.PP
'
The PanedWindow widget allows the user to interactively manipulate the
sizes of several panes. The panes can be arranged either vertically or
horizontally. Each individual pane may have upper and lower limits of
its size. The user changes the sizes of the panes by dragging the
resize handle between two panes.
'
'----------------------------------------------------------------------
.SH "WIDGET COMMAND"
'
.PP
'
The \fBtixPanedWindow\fR command creates a new Tcl command whose name is
the same as the path name of the PanedWindow widget's window.  This
command may be used to invoke various operations on the widget.  It
has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
'
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
frame widget's path name. \fIOption\fR and the \fIarg\fRs determine
the exact behavior of the command.  The following commands are
possible for PanedWindow widgets:
'
.TP 
'
\fIpathName \fBadd\fI paneName \fR?\fIoption value ...\fR?
'
Adds a new pane subwidget with the name \fIpaneName\fR into the
PanedWindow widget. Additional configuration options can be
given to configure the new button subwidget. Three configuration
options are supported:
.RS
'
.TP
\fB\-min\fR
'
Specifies the minimum size of the new pane; the default is 0.
'
.TP
\fB\-max\fR
Specifies the maximum size of the new pane; the default is 10000.
'
.TP
\fB\-size\fR
Specifies the size of the new pane; if the \fB\-size\fR
option is not given, or set to the empty string, the PanedWindow
widget will use the natural size of the pane subwidget.
'
.RE
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixPanedWindow\fR command.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string. \fIOption\fR may be any
of the non-static options of the PanedWindow widget.
'
'
.TP
'
\fIpathName \fBpaneconfigure\fI paneName ?\fIoption\fR? \fI?value ...\fR?
'
'
When no option is given, prints out the values of all options of this
pane. If \fIoption\fR is specified with no \fIvalue\fR, then the
command returns the current value of that option. If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given pane's option(s) to have the given value(s); in this case the
command returns an empty string. \fIOption\fR may be \fB\-min\fR,
\fB\-max\fR and/or \fB\-size\fR.  The sizes of the panes may be changed
as a result of calling the \fBpaneconfigure\fR command.
'
.TP
\fIpathName \fBpanes\fR
'
Returns a list of the names of all panes.
'
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no options are given, returns the pathname of the subwidget of
the specified name.

When options are given, the widget command of the specified subwidget will
be called with these options.
'
'----------------------------------------------------------------------
.SH BINDINGS
'
The panes' sizes will be changed when the user drags the handles. The
change in the panes' sizes may be subjected to the \fB\-min\fR,
\fB\-max\fR and \fB\-size\fR options of the panes.
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
'
TIX, Container Widget
