.so man.macros
.HS tix tix 4.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tix\- Manipulate Tix internal state
.SH SYNOPSIS
\fBtix\fR \fIoption \fR?\fIarg arg ...\fR?
'
'----------------------------------------------------------------------
.SH "CONFIGURATION OPTIONS"
'
The Tix application context supports the following configuration
options. Usually, these options are set using the X resource database,
i.e., in the user's \fB\.Xdefault\fR file. For example, to choose a
different color scheme for the Tix widgets, these two lines can be
added to the user's \fB\.Xdefault\fR file:
.PP
.nf
  	*TixScheme:   Gray
	*TixFontSet:  14Point
.fi
'
'----------BEGIN
.LP
.nf
Name:		\fBbinding\fR
Class:		\fBBinding\fR
Switch:		\fB\-binding\fR
.fi
.IP
This is an obsolete option.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdebug\fR
Class:		\fBDebug\fR
Switch:		\fB\-debug\fR
.fi
.IP
Specifies whether the Tix widgets should run in debug mode.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBtixFontSet\fR
Class:		\fBTixFontSet\fR
Switch:		\fB\-fontset\fR
.fi
.IP
Specifies the fontset to use for the Tix widgets. Valid options are
\fBTK\fR, \fB12Point\fR and \fB14Point\fR. \fBTK\fR specifies that the
standard TK fonts should be used. The default value is \fB14Point\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBtixScheme\fR
Class:		\fBTixScheme\fR
Switch:		\fB\-scheme\fR
.fi
.IP
Specifies the color scheme to use for the Tix widgets. Valid options are
\fBTK\fR, \fBGray\fR, \fBBlue\fR, \fBSGIGray\fR and \fBTixGray\fR.
\fBTK\fR specifies that the standard TK color scheme should be used.
The default value is \fBTixGray\fR.
'----------END
'
.BE

.SH DESCRIPTION
.PP
The \fBtix\fR command provides access to miscellaneous elements of
Tix's internal state and the Tix \fBapplication context\fR.  Most of
the information manipulated by this command pertains to the
application as a whole, or to a screen or display, rather than to a
particular window.  The command can take any of a number of different
forms depending on the \fIoption\fR argument.  The legal forms are:
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may be any of the options described in the
\fBCONFIGURATION OPTIONS\fR section.
'
.TP
\fBtix \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the Tix application
context. If no \fIoption\fR is specified, returns a list describing
all of the available options (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s); in this case
the command returns an empty string. \fIOption\fR may be any of the
options described in the \fBCONFIGURATION OPTIONS\fR section.
'
'
.TP
\fBtix filedialog \fR?\fIclass\fR?
'
Returns the file selection dialog that may be shared among different
modules of this application. This command will create a file selection
dialog widget when it is called the first time. This dialog will be
returned by all subsequent calls to \fBtix filedialog\fR. An optional
\fIclass\fR parameter can be passed to specified what type of file
selection dialog widget is desired. Possible options are
\fBtixFileSelectDialog\fR or \fBtixExFileSelectDialog.\fR

.SH KEYWORDS
file selection dialog
