/* 
 * tixTherm.c --
 *
 *	This module implements "Thermoscale" widgets. [Some explanation here]
 *
 */

#include "tkPort.h"
#include <tkInt.h>
#include <default.h>
#include <tk.h>
#include <tix.h>
#include <inform.h>

/*
 * A data structure of the following type is kept for each
 * widget managed by this file:
 */

typedef struct ThermoscaleStruct {
    Tk_Window tkwin;		/* Window that embodies the widget.  NULL
				 * means window has been deleted but
				 * widget record hasn't been cleaned up yet. */
    Display *display;		/* X's token for the window's display. */
    Tcl_Interp *interp;		/* Interpreter associated with widget. */

    /*
     * Information used when displaying widget:
     */
    char *command;		/* Command prefix to use when invoking
				 * scrolling commands.  NULL means don't
				 * invoke commands.  Malloc'ed. */
    /*
     * Information used when displaying widget:
     */

    /* Border and general drawing */

    int borderWidth;		/* Width of 3-D borders. */
    Tk_3DBorder bgBorder;	/* Used for drawing background. */
    Tk_3DBorder activeBorder;	/* For drawing foreground shapes when
				 * active (i.e. when mouse is positioned
				 * over element).  NULL means use fgBorder. */
    int relief;			/* Indicates whether window as a whole is
				 * raised, sunken, or flat. */

    /* Text drawing */
    XFontStruct *fontPtr;	/* Information about text font, or NULL. */
    XColor *textColorPtr;	/* Color for drawing text. */
    GC textGC;			/* GC for drawing text in normal mode. */
    int ipadx, ipady;
    int wswidth, wsheight;	/* Width and height of the work-sheet area
				 * in pixels */
    Cursor cursor;		/* Current cursor for window, or None. */

    unsigned redrawing : 1;
} Thermoscale;

typedef Thermoscale   WidgetRecord;
typedef Thermoscale * WidgetPtr;

/*
 * hint:: Place these into a default.f file
 */
#define DEF_THERMOSCALE_ACTIVE_BG_COLOR	BISQUE2
#define DEF_THERMOSCALE_ACTIVE_BG_MONO	BLACK
#define DEF_THERMOSCALE_BG_COLOR	BISQUE1
#define DEF_THERMOSCALE_BG_MONO		WHITE
#define DEF_THERMOSCALE_BORDER_WIDTH	"2"
#define DEF_THERMOSCALE_COMMAND		""
#define DEF_THERMOSCALE_CURSOR		""
#define DEF_THERMOSCALE_FONT	      "-Adobe-Helvetica-Bold-R-Normal--*-120-*"
#define DEF_THERMOSCALE_FG_COLOR		BLACK
#define DEF_THERMOSCALE_FG_MONO		BLACK
#define DEF_THERMOSCALE_RELIEF		"sunken"
#define DEF_THERMOSCALE_WSWIDTH		"80"
#define DEF_THERMOSCALE_WSHEIGHT	"50"
#define DEF_THERMOSCALE_IPADX		"2"
#define DEF_THERMOSCALE_IPADX		"2"

/*
 * Information used for argv parsing.
 */
static Tk_ConfigSpec configSpecs[] = {
    {TK_CONFIG_BORDER, "-background", "background", "Background",
       DEF_THERMOSCALE_BG_COLOR, Tk_Offset(WidgetRecord, bgBorder),
       TK_CONFIG_COLOR_ONLY},

    {TK_CONFIG_BORDER, "-background", "background", "Background",
       DEF_THERMOSCALE_BG_MONO, Tk_Offset(WidgetRecord, bgBorder),
       TK_CONFIG_MONO_ONLY},

    {TK_CONFIG_SYNONYM, "-bd", "borderWidth", (char *) NULL,
       (char *) NULL, 0, 0},

    {TK_CONFIG_SYNONYM, "-bg", "background", (char *) NULL,
       (char *) NULL, 0, 0},

    {TK_CONFIG_PIXELS, "-borderwidth", "borderWidth", "BorderWidth",
       DEF_THERMOSCALE_BORDER_WIDTH, Tk_Offset(WidgetRecord, borderWidth), 0},

    {TK_CONFIG_STRING, "-command", "command", "Command",
       DEF_THERMOSCALE_COMMAND, Tk_Offset(WidgetRecord, command),
       TK_CONFIG_NULL_OK},

    {TK_CONFIG_ACTIVE_CURSOR, "-cursor", "cursor", "Cursor",
       DEF_THERMOSCALE_CURSOR, Tk_Offset(WidgetRecord, cursor),
       TK_CONFIG_NULL_OK},

    {TK_CONFIG_SYNONYM, "-fg", "foreground", (char *) NULL,
       (char *) NULL, 0, 0},

    {TK_CONFIG_FONT, "-font", "font", "Font",
       DEF_THERMOSCALE_FONT, Tk_Offset(WidgetRecord, fontPtr), 0},

    {TK_CONFIG_COLOR, "-foreground", "foreground", "Foreground",
       DEF_THERMOSCALE_FG_COLOR, Tk_Offset(WidgetRecord, textColorPtr),
       TK_CONFIG_COLOR_ONLY},

    {TK_CONFIG_COLOR, "-foreground", "foreground", "Foreground",
       DEF_THERMOSCALE_FG_MONO, Tk_Offset(WidgetRecord, textColorPtr),
       TK_CONFIG_MONO_ONLY},

    {TK_CONFIG_RELIEF, "-relief", "relief", "Relief",
       DEF_THERMOSCALE_RELIEF, Tk_Offset(WidgetRecord, relief), 0},

    {TK_CONFIG_RELIEF, "-ipadx", "ipadx", "Pad",
       DEF_THERMOSCALE_IPADX, Tk_Offset(WidgetRecord, ipadx), 0},

    {TK_CONFIG_RELIEF, "-ipady", "ipady", "Pad",
       DEF_THERMOSCALE_IPADY, Tk_Offset(WidgetRecord, ipady), 0},

    {TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
	(char *) NULL, 0, 0}
};

/*
 * Forward declarations for procedures defined later in this file:
 */

static int		WidgetConfigure _ANSI_ARGS_((Tcl_Interp *interp,
			    WidgetPtr wPtr, int argc, char **argv,
			    int flags));
static void		WidgetDestroy _ANSI_ARGS_((ClientData clientData));
static void		WidgetEventProc _ANSI_ARGS_((ClientData clientData,
			    XEvent *eventPtr));
static int		WidgetCommand _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *, int argc, char **argv));
static void		RedrawWhenIdle _ANSI_ARGS_((WidgetPtr wPtr));
static void		WidgetDisplay _ANSI_ARGS_((ClientData clientData));
static void		WidgetComputeGeometry _ANSI_ARGS_((WidgetPtr wPtr));




/*
 *--------------------------------------------------------------
 *
 * Tix_ThermoscaleCmd --
 *
 *	This procedure is invoked to process the "thermoscale" Tcl
 *	command.  It creates a new "Thermoscale" widget.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	A new widget is created and configured.
 *
 *--------------------------------------------------------------
 */
int
Inf_WorkSheetCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    Tk_Window main = (Tk_Window) clientData;
    WidgetPtr wPtr;
    Tk_Window tkwin;
    TkWindow* tkWin;

    if (argc < 2) {
	Tcl_AppendResult(interp, "wrong # args:  should be \"",
		argv[0], " pathName ?options?\"", (char *) NULL);
	return TCL_ERROR;
    }

    tkwin = Tk_CreateWindowFromPath(interp, main, argv[1], (char *) NULL);
    if (tkwin == NULL) {
	return TCL_ERROR;
    }

    Tk_SetClass(tkwin, "Thermoscale");

    /*
     * Allocate and initialize the widget record.
     */
    wPtr = (WidgetPtr) ckalloc(sizeof(WidgetRecord));
    wPtr->tkwin 	= tkwin;
    wPtr->display 	= Tk_Display(tkwin);
    wPtr->interp 	= interp;
    wPtr->command 	= NULL;
    wPtr->borderWidth 	= 0;
    wPtr->bgBorder 	= NULL;
    wPtr->activeBorder 	= NULL;
    wPtr->fontPtr	= NULL;
    wPtr->textColorPtr	= NULL;
    wPtr->textGC	= None;
    wPtr->relief 	= TK_RELIEF_FLAT;
    wPtr->cursor 	= None;
    wPtr->redrawing 	= 0;
    wPtr->wswidth  	= 0;
    wPtr->wsheight  	= 0;

    Tk_CreateEventHandler(wPtr->tkwin, ExposureMask|StructureNotifyMask,
	    WidgetEventProc, (ClientData) wPtr);
    Tcl_CreateCommand(interp, Tk_PathName(wPtr->tkwin), WidgetCommand,
	    (ClientData) wPtr, (void (*)()) NULL);
    if (WidgetConfigure(interp, wPtr, argc-2, argv+2, 0) != TCL_OK) {
	Tk_DestroyWindow(wPtr->tkwin);
	return TCL_ERROR;
    }

    interp->result = Tk_PathName(wPtr->tkwin);
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * WidgetCommand --
 *
 *	This procedure is invoked to process the Tcl command
 *	that corresponds to a widget managed by this module.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

static int
WidgetCommand(clientData, interp, argc, argv)
    ClientData clientData;		/* Information about the widget. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    WidgetPtr wPtr = (WidgetPtr) clientData;
    int result = TCL_OK;
    int length;
    char c;

    if (argc < 2) {
	Tcl_AppendResult(interp, "wrong # args: should be \"",
		argv[0], " option ?arg arg ...?\"", (char *) NULL);
	return TCL_ERROR;
    }
    Tk_Preserve((ClientData) wPtr);
    c = argv[1][0];
    length = strlen(argv[1]);
    if ((c == 'c') && (strncmp(argv[1], "configure", length) == 0)) {
	if (argc == 2) {
	    result = Tk_ConfigureInfo(interp, wPtr->tkwin, configSpecs,
		    (char *) wPtr, (char *) NULL, 0);
	} else if (argc == 3) {
	    result = Tk_ConfigureInfo(interp, wPtr->tkwin, configSpecs,
		    (char *) wPtr, argv[2], 0);
	} else {
	    result = WidgetConfigure(interp, wPtr, argc-2, argv+2,
		    TK_CONFIG_ARGV_ONLY);
	}
    } else if ((c == 's') && (strncmp(argv[1], "somecmd", length) == 0)) {

    } else {
	Tcl_AppendResult(interp, "bad option \"", argv[1],
		"\":  must be configure, position, or size", (char *) NULL);
	goto error;
    }

    Tk_Release((ClientData) wPtr);
    return result;

    error:
    Tk_Release((ClientData) wPtr);
    return TCL_ERROR;
}

/*
 *----------------------------------------------------------------------
 *
 * WidgetConfigure --
 *
 *	This procedure is called to process an argv/argc list in
 *	conjunction with the Tk option database to configure (or
 *	reconfigure) a Thermoscale widget.
 *
 * Results:
 *	The return value is a standard Tcl result.  If TCL_ERROR is
 *	returned, then interp->result contains an error message.
 *
 * Side effects:
 *	Configuration information, such as colors, border width,
 *	etc. get set for wPtr;  old resources get freed,
 *	if there were any.
 *
 *----------------------------------------------------------------------
 */

static int
WidgetConfigure(interp, wPtr, argc, argv, flags)
    Tcl_Interp *interp;			/* Used for error reporting. */
    WidgetPtr wPtr;			/* Information about widget. */
    int argc;				/* Number of valid entries in argv. */
    char **argv;			/* Arguments. */
    int flags;				/* Flags to pass to
					 * Tk_ConfigureWidget. */
{
    XGCValues gcValues;
    GC newGC;

    if (Tk_ConfigureWidget(interp, wPtr->tkwin, configSpecs,
	    argc, argv, (char *) wPtr, flags) != TCL_OK) {
	return TCL_ERROR;
    }

    /*
     * Note: GraphicsExpose events are disabled in normalTextGC because it's
     * used to copy stuff from an off-screen pixmap onto the screen (we know
     * that there's no problem with obscured areas).
     */

    gcValues.font 		= wPtr->fontPtr->fid;
    gcValues.foreground 	= wPtr->textColorPtr->pixel;
    gcValues.graphics_exposures = False;

    newGC = Tk_GetGC(wPtr->tkwin,
	    GCForeground|GCFont|GCGraphicsExposures, &gcValues);
    if (wPtr->textGC != None) {
	Tk_FreeGC(wPtr->display, wPtr->textGC);
    }
    wPtr->textGC = newGC;



    WidgetComputeGeometry(butPtr);


    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * WidgetEventProc --
 *
 *	This procedure is invoked by the Tk dispatcher for various
 *	events on Thermoscales.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	When the window gets deleted, internal structures get
 *	cleaned up.  When it gets exposed, it is redisplayed.
 *
 *--------------------------------------------------------------
 */

static void
WidgetEventProc(clientData, eventPtr)
    ClientData clientData;	/* Information about window. */
    XEvent *eventPtr;		/* Information about event. */
{
    WidgetPtr wPtr = (WidgetPtr) clientData;

    switch (eventPtr->type) {
      case DestroyNotify:
	Tcl_DeleteCommand(wPtr->interp, Tk_PathName(wPtr->tkwin));
	wPtr->tkwin = NULL;
	Tk_EventuallyFree((ClientData) wPtr, WidgetDestroy);
	break;

      case ConfigureNotify:
	WidgetDisplay(wPtr);
	break;

      case Expose:
	RedrawWhenIdle(wPtr);
	break;
    }
}

/*
 *----------------------------------------------------------------------
 *
 * WidgetDestroy --
 *
 *	This procedure is invoked by Tk_EventuallyFree or Tk_Release
 *	to clean up the internal structure of a Thermoscale at a safe time
 *	(when no-one is using it anymore).
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Everything associated with the Thermoscale is freed up.
 *
 *----------------------------------------------------------------------
 */

static void
WidgetDestroy(clientData)
    ClientData clientData;	/* Info about my widget. */
{
    WidgetPtr wPtr = (WidgetPtr) clientData;

    if (wPtr->textGC != None) {
	Tk_FreeGC(wPtr->display, wPtr->textGC);
    }

    Tk_FreeOptions(configSpecs, (char *) wPtr, wPtr->display, 0);
    ckfree((char *) wPtr);
}

/*
 *----------------------------------------------------------------------
 *
 * WidgetDisplay --
 *
 *	This procedure is invoked by Tk_EventuallyFree or Tk_Release
 *	to clean up the internal structure of a Thermoscale at a safe time
 *	(when no-one is using it anymore).
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Everything associated with the Thermoscale is freed up.
 *
 *----------------------------------------------------------------------
 */

static void
RedrawWhenIdle(wPtr)
    WidgetPtr wPtr;
{
    if (!wPtr->redrawing && Tk_IsMapped(wPtr->tkwin)) {
	wPtr->redrawing = 1;
	Tk_DoWhenIdle(WidgetDisplay, (ClientData)wPtr);
    }
}

/*
 *----------------------------------------------------------------------
 *
 * WidgetDisplay --
 *
 *	This procedure is invoked by Tk_EventuallyFree or Tk_Release
 *	to clean up the internal structure of a Thermoscale at a safe time
 *	(when no-one is using it anymore).
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Everything associated with the Thermoscale is freed up.
 *
 *----------------------------------------------------------------------
 */

static void
WidgetDisplay(clientData)
    ClientData clientData;	/* Info about my widget. */
{
    WidgetPtr wPtr = (WidgetPtr) clientData;
    Pixmap pixmap;
    Tk_Window tkwin = wPtr->tkwin;

    wPtr->redrawing = 0;		/* clear the redraw flag */

    pixmap = XCreatePixmap(wPtr->display, Tk_WindowId(tkwin),
	    Tk_Width(tkwin), Tk_Height(tkwin), Tk_Depth(tkwin));
    Tk_Fill3DRectangle(wPtr->display, pixmap, wPtr->bgBorder,
	    0, 0, Tk_Width(tkwin), Tk_Height(tkwin), wPtr->borderWidth,
	    wPtr->relief);

    /*
     * Copy the information from the off-screen pixmap onto the screen,
     * then delete the pixmap.
     */

    XCopyArea(wPtr->display, pixmap, Tk_WindowId(tkwin),
	wPtr->textGC, 0, 0, Tk_Width(tkwin), Tk_Height(tkwin), 0, 0);
    XFreePixmap(wPtr->display, pixmap);
}

/*
 *--------------------------------------------------------------
 *
 * WidgetComputeGeometry --
 *
 *	This procedure is invoked to process the Tcl command
 *	that corresponds to a widget managed by this module.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */
#define RULER_WIDTH 15

static void
WidgetComputeGeometry(wPtr)
    WidgetPtr wPtr;
{
    int w, h;

    w = wPtr->ipadx + RULER_WIDTH + wPtr->wswidth;
    h = wPtr->ipady + RULER_WIDTH + wPtr->wsheight;

    w += 2*wPtr->borderWidth;
    h += 2*wPtr->borderWidth;

    Tk_GeometryRequest(butPtr->tkwin, w, h);
}
