'\"
'\" Copyright 1993-1994 by AT&T Bell Laboratories.
'\"
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Bgexec command created by George Howlett.
'\"
.so man.macros
.HS blt_bgexec cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
blt_bgexec \- Run Unix commands in the background 
.SH SYNOPSIS
\fBblt_bgexec \fR?\fIswitches\fR? \fIvarname arg\fR ?\fIarg\fR ...?
.sp
\fBblt_bgexec \fR?\fIswitches\fR? \fIarg\fR ?\fIarg\fR ...?
.BE
.SH DESCRIPTION
.PP
This command executes one or more Unix
commands in the background as subprocesses, storing the output 
of the last subprocess in the variable \fIvarname\fR after it has completed.  
This allows Unix commands to be run in the background, while still collecting 
their output, to notify the Tcl interpreter when they terminate.
.PP
This command, used in conjunction with \fBtkwait\fR, is particularly useful 
for handling Tk events while waiting for a running UNIX program to finish.
.DS
\fBblt_bgexec \fIvarname command args\fR
.br
\fBtkwait variable\fR \fIvarname\fR
.DE
.PP
This allows expose events can be handled while waiting for one or more 
Unix commands to finish.  The program may also continue, possibly 
animating a busy 
cursor or icon, while waiting for the variable \fIvarname\fR to be set.
After all the subprocesses have completed, \fBblt_bgexec\fR will 
set \fIvarname\fR, triggering \fBtkwait\fR to return.
\fIVarname\fR will contain the output of the last subprocess.
.PP
If the initial arguments to \fBblt_bgexec\fR start with \fB\-\fR then
they are treated as command-line switches and are not part
of the variable name or pipeline specification.  The following 
switches are currently supported:
.TP 13
\fB\-keepnewline
Specifies that a trailing newline should be retained in the pipeline's 
output. Normally a trailing newline will be deleted.  
.TP 13
\fB\-killsignal \fInumber\fR
Specifies the number of the signal to be sent to the Unix subprocesses when 
cleaning up. If \fInumber\fR is \fC0\fR, then no signals are sent.  By 
default, subprocesses are sent signal \fC1\fR (SIGHUP).
.TP 13
\fB\-errorvar \fIstring\fR
Specifies the name of a global variable to be set with the contents of 
standard error after the last subprocess has completed.
.TP 13
\fB\-outputvar \fIstring\fR
Specifies the name of a global variable to be set with the contents of 
standard output after the last subprocess has completed.  If the 
command-line argument \fIvarname\fR is not specified, then this switch 
must be set.
.TP 13
\fB\-statusvar \fIstring\fR
Specifies the name of a global variable to be set with the status
of the last subprocess to complete.  This contents will be a list of 
status information in the form status token, exit code, and description.
.TP 13
\fB\-updatevar \fIstring\fR
Specifies the name of a global variable which is appended with the 
standard output of the last subprocess.  This variable is updated as data 
becomes available (i.e. read from the pipeline), unlike \fIvarname\fR which 
is set \fBafter\fR the last subprocess has completed.
.TP 13
\fB\-\|\-\fR
Marks the end of switches.  The argument following this one will
be treated as the output variable name \fIvarName\fR or the start of 
Unix command even if it starts with 
a \fB\-.
.PP
\fICommand\fR and \fIargs\fR may be in any form accepted by the Tcl \fBexec\fR
command.  You can also prematurely terminate the subprocesses by 
setting \fIvarname\fR 
before the last command has completed.  Each subprocess will be sent
a termination signal (see the \fB-killsignal\fR option).  
.SH BUGS
Care must be taken to prevent an application from preempting itself
by further user-interactions (such as button clicks).  The \fBblt_busy\fR
command is very useful in these situations (see the \fBblt_busy\fR manual).
.SH KEYWORDS
exec, background
