#! moat

xtAppInitialize

proc MakeUserForm {{root ""}} {
	set f [xmForm $root.form managed]
	$f setValues -marginHeight 5 -marginWidth 5

	xmLabel $f.userl managed -labelString "login name:" -x 5 -y 5
	xmTextField $f.user managed -value "" -y 5 -width 150 \
		-leftAttachment attach_widget -leftWidget $f.userl

	xmLabel $f.uidl managed -labelString "uid:" \
		-x 5 -topOffset 5 -topAttachment attach_widget -topWidget $f.userl
	xmTextField $f.uid managed -value "100" -width 100 \
		-topAttachment attach_opposite_widget -topWidget $f.uidl \
		-leftAttachment attach_widget -leftWidget $f.uidl

	xmLabel $f.gidl managed -labelString "gid:" \
		-topOffset 5 -x 5 -topAttachment attach_widget -topWidget $f.uid
	xmTextField $f.gid managed -value "100" -width 100 \
		-leftAttachment attach_widget -leftWidget $f.gidl \
		-topAttachment attach_opposite_widget -topWidget  $f.gidl

	xmLabel $f.gcosl managed -labelString "finger field:" \
		-topOffset 5 -x 5 -topAttachment attach_widget -topWidget $f.gid
	xmTextField $f.gcos managed -value ",,," -width 150 \
		-leftAttachment attach_widget -leftWidget $f.gcosl \
		-topAttachment attach_opposite_widget -topWidget $f.gcosl \
		-rightAttachment attach_form
	
	xmLabel $f.homel managed -labelString "home directory:" \
		-topOffset 5 -x 5 -topAttachment attach_widget -topWidget $f.gcos
	xmTextField $f.home managed -value "/users" -width 150 \
		-leftAttachment attach_widget -leftWidget $f.homel \
		-topAttachment attach_opposite_widget -topWidget $f.homel \
		-rightAttachment attach_form
	
	xmLabel $f.shelll managed -labelString "shell:" \
		-topOffset 5 -x 5 -topAttachment attach_widget -topWidget $f.home
	xmTextField $f.shell managed -value "/bin/sh" -width 80 \
		-leftAttachment attach_widget -leftWidget $f.shelll \
		-topAttachment attach_opposite_widget -topWidget $f.shelll \
		-rightAttachment attach_form \
		-bottomOffset 5 -bottomAttachment attach_form
	
	foreach w {user uid gid gcos home shell} {
	 	$f.$w modifyVerifyCallback "CheckUserField $f $w"
	}

	return $f
}

proc FieldCirculate {form widget wlist} {
	set i [expr ([lsearch $wlist $widget]+1)%[llength $wlist]]
	set widget [lindex $wlist $i]
	SetInputFocus $form.$widget
}

proc CheckUserField {form field} {
	switch $field {
		uid
			-
		gid {
			set id [expr 0+[$form.$field getString]]
			# $form.$field setValues -value $id
		}
	}
}

proc SetUserData {f pwdline} {
	set fields [split $pwdline ":"]
	
	$f.user setValues -value [lindex $fields 0]
	$f.uid  setValues -value [lindex $fields 2]
	$f.gid  setValues -value [lindex $fields 3]
	$f.gcos setValues -value [lindex $fields 4]
	$f.home setValues -value [lindex $fields 5]
	$f.shell  setValues -value [lindex $fields 6]
}

SetUserData [MakeUserForm] "js:*:100:101:John Smith,4858,321-4312,:/users/js:/bin/sh"

. realizeWidget
. mainLoop
