#! /bin/sh
#
#	cook - file construction tool
#	Copyright (C) 1993, 1994 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: shell script to generate the MANIFEST file
#
echo
echo
echo "MANIFEST	This file."
for f in $*
do
	case $f in
	MANIFEST)
		;;
	LICENSE)
		info="GNU General Public License"
		;;
	README)
		info="Blurb about cook"
		;;
	BUILDING)
		info="Instructions how to build, test and install cook"
		;;
	aux/CHANGES*)
		info="Change history of cook"
		;;
	Makefile)
		info="Instructions to make(1) how to build and test cook"
		;;
	common/patchlevel.h)
		info="The patch level of this distribution."
		;;
	doc/version.so)
		info="The patch level of this distribution."
		;;
	aux/new.so)
		info="Indirection to release note for this release."
		;;
	configure)
		info="Shell script to construct Makefile and common/config.h"
		;;
	Makefile.in)
		info="Template for Makefile, used by configure"
		;;
	common/config.h.in)
		info="Template for common/config.h, used by configure"
		;;
	aux/template/*)
		info="New file template."
		;;
	*)
		info=`awk '
/[ 	]MANIFEST:[ 	]/ {
	for (j = 1; j < NF; ++j)
		if ($j == "MANIFEST:")
			break;
	for (k = j + 1; k <= NF; ++k)
		printf(" %s", $k);
	printf("\n");
	exit;
}' $f`
		;;
	esac
	echo "$f	$info"
done
exit 0
