/*
 *	cook - file construction tool
 *	Copyright (C) 1990, 1991, 1992, 1993, 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for common/error.c
 */

#ifndef ERROR_H
#define ERROR_H

#include <main.h>

void error _((char *, ...));
void fatal _((char *, ...));
void nerror _((char *, ...));
void nfatal _((char *, ...));

#ifdef DEBUG
# if defined(__STDC__) || defined(__stdc__)
#  define assert(c) cook_assert((c) != 0, #c, __FILE__, __LINE__)
# else
#  define assert(c) cook_assert((c) != 0, "c", __FILE__, __LINE__)
# endif
void cook_assert _((int, char *, char *, int));
#else
# define assert(c)
#endif

typedef void (*quit_ty)_((void));
void quit_handler _((quit_ty));
void quit _((int));

void star _((void));
void star_eoln _((void));
void star_sync _((void));
void star_enable _((void));

#endif /* ERROR_H */
