/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement the home builtin function
 */

#include <ac/stdlib.h>
#include <pwd.h>

#include <builtin/home.h>
#include <error.h>


int
builtin_home(result, arg)
	wlist		*result;
	wlist		*arg;
{
	char		*cp;
	string_ty	*s;
	size_t		j;
	struct passwd	*pw;

	if (arg->wl_nwords < 2)
	{
		cp = getenv("HOME");
		if (!cp)
		{
			error("the HOME environment variable is not set");
			return -1;
		}
		s = str_from_c(cp);
		wl_append(result, s);
		str_free(s);
		return 0;
	}
	for (j = 1; j < arg->wl_nwords; ++j)
	{
		s = arg->wl_word[j];
		pw = getpwnam(s->str_text);
		if (!pw)
		{
			error("user \"%S\" unknown", s);
			return -1;
		}
		s = str_from_c(pw->pw_dir);
		wl_append(result, s);
		str_free(s);
	}
	return 0;
}
