/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement the split builtin function
 */

#include <builtin/split.h>
#include <expr.h>


int
builtin_split(result, arg)
	wlist		*result;
	wlist		*arg;
{
	size_t		j;

	if (arg->wl_nwords < 2)
	{
		expr_error
		(
			"%s: requires one or more arguments",
			arg->wl_word[0]->str_text
		);
		return -1;
	}
	for (j = 2; j < arg->wl_nwords; ++j)
	{
		wlist		wl;
		size_t		k;

		str2wl(&wl, arg->wl_word[j], arg->wl_word[1]->str_text, 0);
		for (k = 0; k < wl.wl_nwords; ++k)
			wl_append(result, wl.wl_word[k]);
		wl_free(&wl);
	}
	return 0;
}
