/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement builtin subst function
 */

#include <builtin/subst.h>
#include <expr.h>


int
builtin_subst(result, arg)
	wlist		*result;
	wlist		*arg;
{
	size_t		j;
	string_ty	*s;

	if (arg->wl_nwords < 3)
	{
		expr_error
		(
			"%s: requires at least two arguments",
			arg->wl_word[0]->str_text
		);
		return -1;
	}
	for (j = 3; j < arg->wl_nwords; ++j)
	{
		s =
			str_substitute
			(
				arg->wl_word[1],
				arg->wl_word[2],
				arg->wl_word[j]
			);
		wl_append(result, s);
		str_free(s);
	}
	return 0;
}
